/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.ui;

import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.internal.ui.SWTUtil;
import org.eclipse.debug.ui.ILaunchConfigurationDialog;
import org.eclipse.debug.ui.ILaunchConfigurationTab;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

public abstract class AbstractLaunchConfigurationTab
implements ILaunchConfigurationTab {
    private Control fControl;
    private ILaunchConfigurationDialog fLaunchConfigurationDialog;
    private String fErrorMessage;
    private String fMessage;
    private boolean fDirty = true;

    protected ILaunchConfigurationDialog getLaunchConfigurationDialog() {
        return this.fLaunchConfigurationDialog;
    }

    protected void updateLaunchConfigurationDialog() {
        if (this.getLaunchConfigurationDialog() != null) {
            this.getLaunchConfigurationDialog().updateButtons();
            this.getLaunchConfigurationDialog().updateMessage();
        }
    }

    public Control getControl() {
        return this.fControl;
    }

    protected void setControl(Control control) {
        this.fControl = control;
    }

    public String getErrorMessage() {
        return this.fErrorMessage;
    }

    public String getMessage() {
        return this.fMessage;
    }

    public void launched(ILaunch launch) {
    }

    public void setLaunchConfigurationDialog(ILaunchConfigurationDialog dialog) {
        this.fLaunchConfigurationDialog = dialog;
    }

    protected void setErrorMessage(String errorMessage) {
        this.fErrorMessage = errorMessage;
    }

    protected void setMessage(String message) {
        this.fMessage = message;
    }

    protected ILaunchManager getLaunchManager() {
        return DebugPlugin.getDefault().getLaunchManager();
    }

    public void dispose() {
    }

    protected Shell getShell() {
        Control control = this.getControl();
        if (control != null) {
            return control.getShell();
        }
        return null;
    }

    protected Button createPushButton(Composite parent, String label, Image image) {
        return SWTUtil.createPushButton(parent, label, image);
    }

    protected Button createRadioButton(Composite parent, String label) {
        return SWTUtil.createRadioButton(parent, label);
    }

    public boolean canSave() {
        return true;
    }

    public boolean isValid(ILaunchConfiguration launchConfig) {
        return true;
    }

    protected void createVerticalSpacer(Composite comp, int colSpan) {
        Label label = new Label(comp, 0);
        GridData gd = new GridData();
        gd.horizontalSpan = colSpan;
        label.setLayoutData((Object)gd);
        label.setFont(comp.getFont());
    }

    protected void createSeparator(Composite comp, int colSpan) {
        Label label = new Label(comp, 258);
        GridData gd = new GridData(768);
        gd.horizontalSpan = colSpan;
        label.setLayoutData((Object)gd);
    }

    public Image getImage() {
        return null;
    }

    protected void setAttribute(String attribute, ILaunchConfigurationWorkingCopy configuration, boolean value, boolean defaultValue) {
        if (value == defaultValue) {
            configuration.setAttribute(attribute, null);
        } else {
            configuration.setAttribute(attribute, value);
        }
    }

    protected boolean isDirty() {
        return this.fDirty;
    }

    protected void setDirty(boolean dirty) {
        this.fDirty = dirty;
    }

    public void activated(ILaunchConfigurationWorkingCopy workingCopy) {
        this.initializeFrom((ILaunchConfiguration)workingCopy);
    }

    public void deactivated(ILaunchConfigurationWorkingCopy workingCopy) {
        this.performApply(workingCopy);
    }
}

