/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.variables;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.swt.widgets.TreeItem;

public class ViewerState {
    private List fExpandedElements = null;
    private IPath[] fSelection = null;

    public ViewerState(TreeViewer viewer) {
        this.saveState(viewer);
    }

    public void saveState(TreeViewer viewer) {
        ArrayList expanded = new ArrayList();
        this.fExpandedElements = null;
        TreeItem[] items = viewer.getTree().getItems();
        try {
            int i = 0;
            while (i < items.length) {
                this.collectExandedItesm(items[i], expanded);
                ++i;
            }
            if (expanded.size() > 0) {
                this.fExpandedElements = expanded;
            }
        }
        catch (DebugException debugException) {
            this.fExpandedElements = null;
        }
        TreeItem[] selection = viewer.getTree().getSelection();
        this.fSelection = new IPath[selection.length];
        try {
            int i = 0;
            while (i < selection.length) {
                this.fSelection[i] = this.encodeVariable(selection[i]);
                ++i;
            }
        }
        catch (DebugException debugException) {
            this.fSelection = null;
        }
    }

    protected void collectExandedItesm(TreeItem item, List expanded) throws DebugException {
        if (item.getExpanded()) {
            expanded.add(this.encodeVariable(item));
            TreeItem[] items = item.getItems();
            int i = 0;
            while (i < items.length) {
                this.collectExandedItesm(items[i], expanded);
                ++i;
            }
        }
    }

    public void restoreState(TreeViewer viewer) {
        IVariable var;
        IPath path;
        int i;
        if (this.fExpandedElements != null) {
            ArrayList<IVariable> expansion = new ArrayList<IVariable>(this.fExpandedElements.size());
            i = 0;
            while (i < this.fExpandedElements.size()) {
                path = (IPath)this.fExpandedElements.get(i);
                if (path != null) {
                    try {
                        var = this.decodePath(path, viewer);
                        if (var != null) {
                            expansion.add(var);
                        }
                    }
                    catch (DebugException debugException) {}
                }
                ++i;
            }
            viewer.setExpandedElements(expansion.toArray());
        }
        if (this.fSelection != null) {
            ArrayList<IVariable> selection = new ArrayList<IVariable>(this.fSelection.length);
            i = 0;
            while (i < this.fSelection.length) {
                path = this.fSelection[i];
                try {
                    var = this.decodePath(path, viewer);
                    if (var != null) {
                        selection.add(var);
                    }
                }
                catch (DebugException debugException) {}
                ++i;
            }
            viewer.setSelection((ISelection)new StructuredSelection(selection));
        }
    }

    protected IPath encodeVariable(TreeItem item) throws DebugException {
        IVariable variable = (IVariable)item.getData();
        Path path = new Path(variable.getName());
        TreeItem parent = item.getParentItem();
        while (parent != null) {
            variable = (IVariable)parent.getData();
            path = new Path(variable.getName()).append((IPath)path);
            parent = parent.getParentItem();
        }
        return path;
    }

    protected IVariable decodePath(IPath path, TreeViewer viewer) throws DebugException {
        ITreeContentProvider contentProvider = (ITreeContentProvider)viewer.getContentProvider();
        String[] names = path.segments();
        Object parent = viewer.getInput();
        IVariable variable = null;
        int i = 0;
        while (i < names.length) {
            variable = null;
            Object[] children = contentProvider.getChildren(parent);
            String name = names[i];
            int j = 0;
            while (j < children.length) {
                IVariable var = (IVariable)children[j];
                if (var.getName().equals(name)) {
                    variable = var;
                    break;
                }
                ++j;
            }
            if (variable == null) {
                return null;
            }
            parent = variable;
            ++i;
        }
        return variable;
    }
}

