/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.variables;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILogicalStructureType;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IIndexedValue;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.views.IDebugExceptionHandler;
import org.eclipse.debug.internal.ui.views.variables.IndexedValuePartition;
import org.eclipse.debug.internal.ui.views.variables.IndexedVariablePartition;
import org.eclipse.debug.internal.ui.views.variables.VariablesView;
import org.eclipse.debug.ui.IDebugView;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class VariablesViewContentProvider
implements ITreeContentProvider {
    private IDebugView fDebugView;
    private HashMap fParentCache = new HashMap(10);
    private IDebugExceptionHandler fExceptionHandler = null;
    private boolean fUseObjectBrowsers;

    public VariablesViewContentProvider(IDebugView view) {
        this.setDebugView(view);
    }

    public Object[] getElements(Object parent) {
        return this.getChildren(parent);
    }

    public Object[] getChildren(Object parent) {
        Object[] children = null;
        try {
            if (parent instanceof IStackFrame) {
                children = ((IStackFrame)parent).getVariables();
            } else if (parent instanceof IVariable) {
                IVariable variable = (IVariable)parent;
                IValue value = variable.getValue();
                children = this.getModelSpecificChildren((IDebugElement)variable, value);
            }
            if (children != null) {
                this.cache(parent, children);
                return children;
            }
        }
        catch (DebugException de) {
            if (this.getExceptionHandler() != null) {
                this.getExceptionHandler().handleException(de);
            }
            DebugUIPlugin.log(de);
        }
        return new Object[0];
    }

    protected IVariable[] getModelSpecificChildren(IDebugElement parent, IValue value) throws DebugException {
        if (value == null) {
            return new IVariable[0];
        }
        if (value instanceof IndexedValuePartition) {
            return value.getVariables();
        }
        return this.getValueChildren(parent, value);
    }

    protected IVariable[] getValueChildren(IDebugElement parent, IValue value) throws DebugException {
        int partitionLength;
        IIndexedValue indexedValue;
        int valueLength;
        IValue logicalValue = this.getLogicalValue(value);
        if (logicalValue instanceof IIndexedValue && (valueLength = (indexedValue = (IIndexedValue)logicalValue).getSize()) > (partitionLength = this.getArrayPartitionSize())) {
            int numPartitions = valueLength / partitionLength;
            if (valueLength % partitionLength > 0) {
                ++numPartitions;
            }
            IVariable[] partitions = new IVariable[numPartitions];
            int partition = 0;
            int offset = 0;
            while (offset < valueLength) {
                int partitionSize = partitionLength;
                if (valueLength - offset < partitionLength) {
                    partitionSize = valueLength - offset;
                }
                partitions[partition] = new IndexedVariablePartition(parent, indexedValue, offset, partitionSize);
                ++partition;
                offset += partitionLength;
            }
            return partitions;
        }
        return logicalValue.getVariables();
    }

    private IValue getLogicalValue(IValue value) {
        ILogicalStructureType[] types;
        if (this.isShowLogicalStructure() && (types = DebugPlugin.getLogicalStructureTypes((IValue)value)).length > 0) {
            IPreferenceStore store = DebugUIPlugin.getDefault().getPreferenceStore();
            ILogicalStructureType type = null;
            boolean exist = false;
            int i = 0;
            while (i < types.length) {
                String key = "VAR_LS_" + types[i].getId();
                int setting = store.getInt(key);
                if (setting != 0) {
                    exist = true;
                    if (setting == 1) {
                        type = types[i];
                        break;
                    }
                } else {
                    store.setValue(types[i].getId(), -1);
                }
                ++i;
            }
            if (type == null && !exist) {
                type = types[0];
                store.setValue("VAR_LS_" + type.getId(), 1);
            }
            if (type != null) {
                try {
                    return type.getLogicalStructure(value);
                }
                catch (CoreException e) {
                    DebugUIPlugin.log(e);
                }
            }
        }
        return value;
    }

    protected void cache(Object parent, Object[] children) {
        int i = 0;
        while (i < children.length) {
            Object child = children[i];
            if (!this.fParentCache.containsKey(child)) {
                this.fParentCache.put(child, parent);
            }
            ++i;
        }
    }

    public Object getParent(Object item) {
        return this.fParentCache.get(item);
    }

    public void dispose() {
        this.fParentCache = null;
        this.setExceptionHandler(null);
    }

    protected void clearCache() {
        if (this.fParentCache != null) {
            this.fParentCache.clear();
        }
    }

    public void removeCache(Object[] children) {
        if (this.fParentCache == null) {
            return;
        }
        int i = 0;
        while (i < children.length) {
            this.fParentCache.remove(children[i]);
            ++i;
        }
    }

    public boolean hasChildren(Object element) {
        try {
            if (element instanceof IVariable) {
                if (element instanceof IndexedVariablePartition) {
                    return true;
                }
                element = ((IVariable)element).getValue();
            }
            if (element instanceof IValue) {
                return ((IValue)element).hasVariables();
            }
            if (element instanceof IStackFrame) {
                return ((IStackFrame)element).hasVariables();
            }
        }
        catch (DebugException de) {
            DebugUIPlugin.log(de);
            return false;
        }
        return false;
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        this.clearCache();
    }

    public List getCachedDecendants(Object parent) {
        Iterator children = this.fParentCache.keySet().iterator();
        ArrayList cachedChildren = new ArrayList(10);
        while (children.hasNext()) {
            Object child = children.next();
            if (!this.isCachedDecendant(child, parent)) continue;
            cachedChildren.add(child);
        }
        return cachedChildren;
    }

    protected boolean isCachedDecendant(Object child, Object parent) {
        Object p = this.getParent(child);
        while (p != null) {
            if (p.equals(parent)) {
                return true;
            }
            p = this.getParent(p);
        }
        return false;
    }

    protected String getDebugModelId(IDebugElement debugElement) {
        return debugElement.getModelIdentifier();
    }

    protected void setExceptionHandler(IDebugExceptionHandler handler) {
        this.fExceptionHandler = handler;
    }

    protected IDebugExceptionHandler getExceptionHandler() {
        return this.fExceptionHandler;
    }

    public void setShowLogicalStructure(boolean flag) {
        this.fUseObjectBrowsers = flag;
    }

    public boolean isShowLogicalStructure() {
        return this.fUseObjectBrowsers;
    }

    private void setDebugView(IDebugView view) {
        this.fDebugView = view;
    }

    protected IDebugView getDebugView() {
        return this.fDebugView;
    }

    protected int getArrayPartitionSize() {
        return ((VariablesView)this.getDebugView()).getArrayPartitionSize();
    }
}

