/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.variables;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.internal.ui.DebugPluginImages;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.DelegatingModelPresentation;
import org.eclipse.debug.internal.ui.IDebugHelpContextIds;
import org.eclipse.debug.internal.ui.LazyModelPresentation;
import org.eclipse.debug.internal.ui.VariablesViewModelPresentation;
import org.eclipse.debug.internal.ui.actions.ChangeVariableValueAction;
import org.eclipse.debug.internal.ui.actions.CollapseAllAction;
import org.eclipse.debug.internal.ui.actions.ShowTypesAction;
import org.eclipse.debug.internal.ui.actions.ToggleDetailPaneAction;
import org.eclipse.debug.internal.ui.views.AbstractDebugEventHandler;
import org.eclipse.debug.internal.ui.views.AbstractDebugEventHandlerView;
import org.eclipse.debug.internal.ui.views.IDebugExceptionHandler;
import org.eclipse.debug.internal.ui.views.variables.AvailableLogicalStructuresAction;
import org.eclipse.debug.internal.ui.views.variables.IndexedVariablePartition;
import org.eclipse.debug.internal.ui.views.variables.ToggleLogicalStructureAction;
import org.eclipse.debug.internal.ui.views.variables.VariablesViewContentProvider;
import org.eclipse.debug.internal.ui.views.variables.VariablesViewEventHandler;
import org.eclipse.debug.internal.ui.views.variables.VariablesViewMessages;
import org.eclipse.debug.internal.ui.views.variables.VariablesViewer;
import org.eclipse.debug.internal.ui.views.variables.ViewerState;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.IDebugView;
import org.eclipse.debug.ui.IValueDetailListener;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.Document;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.source.ISourceViewer;
import org.eclipse.jface.text.source.SourceViewer;
import org.eclipse.jface.text.source.SourceViewerConfiguration;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.ListenerList;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.viewers.AbstractTreeViewer;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IColorProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.StructuredViewer;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.custom.CLabel;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.custom.ViewForm;
import org.eclipse.swt.events.FocusAdapter;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.INullSelectionListener;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.actions.ActionFactory;
import org.eclipse.ui.console.actions.TextViewerAction;
import org.eclipse.ui.texteditor.FindReplaceAction;
import org.eclipse.ui.texteditor.IUpdate;

public class VariablesView
extends AbstractDebugEventHandlerView
implements ISelectionListener,
IPropertyChangeListener,
IValueDetailListener,
IDebugExceptionHandler,
INullSelectionListener {
    private VariablesViewModelPresentation fModelPresentation;
    private SashForm fSashForm;
    private ISourceViewer fDetailViewer;
    private IDocument fDetailDocument;
    private String fDebugModelIdentifier;
    private SourceViewerConfiguration fSourceViewerConfiguration;
    private IStructuredSelection fValueSelection = null;
    private IValue fLastValueDetail = null;
    private Iterator fSelectionIterator = null;
    private ISelectionChangedListener fTreeSelectionChangedListener;
    private ISelectionChangedListener fDetailSelectionChangedListener;
    private IDocumentListener fDetailDocumentListener;
    private VariablesViewSelectionProvider fSelectionProvider = new VariablesViewSelectionProvider();
    private List fSelectionActions = new ArrayList(3);
    private HashMap fSelectionStates = new HashMap(10);
    private ViewerState fLastState = null;
    private Viewer fFocusViewer = null;
    private static final int[] DEFAULT_SASH_WEIGHTS = new int[]{13, 6};
    private int[] fLastSashWeights;
    private boolean fToggledDetailOnce;
    private String fCurrentDetailPaneOrientation = "Variables.detail.orientation.hidden";
    private ToggleDetailPaneAction[] fToggleDetailPaneActions;
    protected static final String DETAIL_SELECT_ALL_ACTION = String.valueOf(IDebugView.SELECT_ALL_ACTION) + ".Detail";
    protected static final String VARIABLES_SELECT_ALL_ACTION = String.valueOf(IDebugView.SELECT_ALL_ACTION) + ".Variables";
    protected static final String DETAIL_COPY_ACTION = String.valueOf(ActionFactory.COPY.getId()) + ".Detail";
    protected static final String VARIABLES_COPY_ACTION = String.valueOf(ActionFactory.COPY.getId()) + ".Variables";
    protected static final String LOGICAL_STRUCTURE_TYPE_PREFIX = "VAR_LS_";
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public void dispose() {
        this.getSite().getPage().removeSelectionListener("org.eclipse.debug.ui.DebugView", (ISelectionListener)this);
        DebugUIPlugin.getDefault().getPreferenceStore().removePropertyChangeListener((IPropertyChangeListener)this);
        JFaceResources.getFontRegistry().removeListener((IPropertyChangeListener)this);
        Viewer viewer = this.getViewer();
        if (viewer != null) {
            this.getDetailDocument().removeDocumentListener(this.getDetailDocumentListener());
        }
        super.dispose();
    }

    protected void setViewerInput(IStructuredSelection ssel) {
        Object input;
        IStackFrame frame = null;
        if (ssel.size() == 1 && (input = ssel.getFirstElement()) instanceof IStackFrame) {
            frame = (IStackFrame)input;
        }
        this.getDetailViewer().setEditable(frame != null);
        Object current = this.getViewer().getInput();
        if (current == null && frame == null) {
            return;
        }
        if (current != null && current.equals(frame)) {
            return;
        }
        if (current != null) {
            this.fLastState = new ViewerState(this.getVariablesViewer());
            this.fSelectionStates.put(current, this.fLastState);
        }
        if (frame != null) {
            this.setDebugModel(frame.getModelIdentifier());
        }
        this.showViewer();
        this.getViewer().setInput((Object)frame);
        if (frame != null) {
            ViewerState state = (ViewerState)this.fSelectionStates.get(frame);
            if (state == null) {
                state = this.fLastState;
            }
            if (state != null) {
                state.restoreState(this.getVariablesViewer());
            }
        }
    }

    protected VariablesViewer getVariablesViewer() {
        return (VariablesViewer)this.getViewer();
    }

    protected void clearExpandedVariables(Object parent) {
        List list = null;
        if (parent instanceof IThread) {
            list = this.getCachedFrames((IThread)parent);
        } else if (parent instanceof IDebugTarget) {
            list = this.getCachedFrames((IDebugTarget)parent);
        }
        if (list != null) {
            Iterator frames = list.iterator();
            while (frames.hasNext()) {
                Object frame = frames.next();
                this.fSelectionStates.remove(frame);
            }
        }
    }

    protected List getCachedFrames(IThread thread) {
        ArrayList<IStackFrame> list = null;
        Iterator frames = this.fSelectionStates.keySet().iterator();
        while (frames.hasNext()) {
            IStackFrame frame = (IStackFrame)frames.next();
            if (!frame.getThread().equals(thread)) continue;
            if (list == null) {
                list = new ArrayList<IStackFrame>();
            }
            list.add(frame);
        }
        return list;
    }

    protected List getCachedFrames(IDebugTarget target) {
        ArrayList<IStackFrame> list = null;
        Iterator frames = this.fSelectionStates.keySet().iterator();
        while (frames.hasNext()) {
            IStackFrame frame = (IStackFrame)frames.next();
            if (!frame.getDebugTarget().equals(target)) continue;
            if (list == null) {
                list = new ArrayList<IStackFrame>();
            }
            list.add(frame);
        }
        return list;
    }

    protected void configureDetailsViewer() {
        LazyModelPresentation mp = (LazyModelPresentation)this.fModelPresentation.getPresentation(this.getDebugModel());
        SourceViewerConfiguration svc = null;
        if (mp != null) {
            try {
                svc = mp.newDetailsViewerConfiguration();
            }
            catch (CoreException e) {
                DebugUIPlugin.errorDialog(this.getSite().getShell(), VariablesViewMessages.getString("VariablesView.Error_1"), VariablesViewMessages.getString("VariablesView.Unable_to_configure_variable_details_area._2"), e);
            }
        }
        if (svc == null) {
            svc = new SourceViewerConfiguration();
            this.getDetailViewer().setEditable(false);
        }
        this.getDetailViewer().configure(svc);
        this.updateAction("ContentAssist");
        this.setDetailViewerConfiguration(svc);
    }

    public void propertyChange(PropertyChangeEvent event) {
        String propertyName = event.getProperty();
        if (propertyName.equals("Changed.Variable.RGB")) {
            this.getEventHandler().refresh();
        } else if (propertyName.equals("org.eclipse.debug.ui.DetailPaneFont")) {
            this.getDetailViewer().getTextWidget().setFont(JFaceResources.getFont((String)"org.eclipse.debug.ui.DetailPaneFont"));
        }
    }

    public Viewer createViewer(Composite parent) {
        TreeViewer variablesViewer = this.createTreeViewer(parent);
        this.createDetailsViewer();
        this.getSashForm().setMaximizedControl(variablesViewer.getControl());
        this.createOrientationActions();
        IPreferenceStore prefStore = DebugUIPlugin.getDefault().getPreferenceStore();
        String orientation = prefStore.getString(this.getDetailPanePreferenceKey());
        int i = 0;
        while (i < this.fToggleDetailPaneActions.length) {
            this.fToggleDetailPaneActions[i].setChecked(this.fToggleDetailPaneActions[i].getOrientation().equals(orientation));
            ++i;
        }
        this.setDetailPaneOrientation(orientation);
        return variablesViewer;
    }

    protected String getDetailPanePreferenceKey() {
        return "Variables.detail.orientation";
    }

    protected TreeViewer createTreeViewer(Composite parent) {
        this.fModelPresentation = new VariablesViewModelPresentation();
        DebugUIPlugin.getDefault().getPreferenceStore().addPropertyChangeListener((IPropertyChangeListener)this);
        JFaceResources.getFontRegistry().addListener((IPropertyChangeListener)this);
        this.setSashForm(new SashForm(parent, 0));
        final VariablesViewer variablesViewer = new VariablesViewer((Composite)this.getSashForm(), 770);
        variablesViewer.setContentProvider(this.createContentProvider());
        variablesViewer.setLabelProvider(this.createLabelProvider());
        variablesViewer.setUseHashlookup(true);
        variablesViewer.getControl().addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                VariablesView.this.getVariablesViewSelectionProvider().setUnderlyingSelectionProvider((ISelectionProvider)variablesViewer);
                VariablesView.this.setAction(IDebugView.SELECT_ALL_ACTION, VariablesView.this.getAction(VARIABLES_SELECT_ALL_ACTION));
                VariablesView.this.setAction(IDebugView.COPY_ACTION, VariablesView.this.getAction(VARIABLES_COPY_ACTION));
                VariablesView.this.getViewSite().getActionBars().updateActionBars();
                VariablesView.this.setFocusViewer((Viewer)VariablesView.this.getVariablesViewer());
            }
        });
        variablesViewer.addSelectionChangedListener(this.getTreeSelectionChangedListener());
        this.getVariablesViewSelectionProvider().setUnderlyingSelectionProvider((ISelectionProvider)variablesViewer);
        this.getSite().setSelectionProvider((ISelectionProvider)this.getVariablesViewSelectionProvider());
        this.getSite().getPage().addSelectionListener("org.eclipse.debug.ui.DebugView", (ISelectionListener)this);
        this.setEventHandler(this.createEventHandler());
        return variablesViewer;
    }

    protected IBaseLabelProvider createLabelProvider() {
        return new VariablesViewLabelProvider(this.getModelPresentation());
    }

    protected void createDetailsViewer() {
        ViewForm viewForm = new ViewForm((Composite)this.getSashForm(), 0x800000);
        CLabel detailsLabel = new CLabel((Composite)viewForm, 0);
        detailsLabel.setText(VariablesViewMessages.getString("VariablesView.44"));
        detailsLabel.setImage(DebugPluginImages.getImage("IMG_VIEW_VARIABLES"));
        viewForm.setTopLeft((Control)detailsLabel);
        SourceViewer detailsViewer = new SourceViewer((Composite)viewForm, null, 768);
        this.setDetailViewer((ISourceViewer)detailsViewer);
        detailsViewer.setDocument(this.getDetailDocument());
        detailsViewer.getTextWidget().setFont(JFaceResources.getFont((String)"org.eclipse.debug.ui.DetailPaneFont"));
        this.getDetailDocument().addDocumentListener(this.getDetailDocumentListener());
        detailsViewer.setEditable(false);
        Control control = detailsViewer.getControl();
        GridData gd = new GridData(1808);
        control.setLayoutData((Object)gd);
        viewForm.setContent(control);
        detailsViewer.getSelectionProvider().addSelectionChangedListener(this.getDetailSelectionChangedListener());
        detailsViewer.getControl().addFocusListener((FocusListener)new FocusAdapter(){

            public void focusGained(FocusEvent e) {
                VariablesView.this.getVariablesViewSelectionProvider().setUnderlyingSelectionProvider(VariablesView.this.getDetailViewer().getSelectionProvider());
                VariablesView.this.setAction(IDebugView.SELECT_ALL_ACTION, VariablesView.this.getAction(DETAIL_SELECT_ALL_ACTION));
                VariablesView.this.setAction(IDebugView.COPY_ACTION, VariablesView.this.getAction(DETAIL_COPY_ACTION));
                VariablesView.this.getViewSite().getActionBars().updateActionBars();
                VariablesView.this.setFocusViewer((Viewer)VariablesView.this.getDetailViewer());
            }
        });
        this.createDetailContextMenu((Control)detailsViewer.getTextWidget());
    }

    protected IContentProvider createContentProvider() {
        VariablesViewContentProvider cp = new VariablesViewContentProvider(this);
        cp.setExceptionHandler(this);
        return cp;
    }

    protected AbstractDebugEventHandler createEventHandler() {
        return new VariablesViewEventHandler(this);
    }

    protected String getHelpContextId() {
        return IDebugHelpContextIds.VARIABLE_VIEW;
    }

    public void setDetailPaneOrientation(String orientation) {
        if (orientation.equals(this.fCurrentDetailPaneOrientation)) {
            return;
        }
        if (orientation.equals("Variables.detail.orientation.hidden")) {
            this.hideDetailPane();
        } else {
            int vertOrHoriz = orientation.equals("Variables.detail.orientation.underneath") ? 512 : 256;
            this.getSashForm().setOrientation(vertOrHoriz);
            if ("Variables.detail.orientation.hidden".equals(this.fCurrentDetailPaneOrientation)) {
                this.showDetailPane();
            }
        }
        this.fCurrentDetailPaneOrientation = orientation;
        DebugUIPlugin.getDefault().getPreferenceStore().setValue(this.getDetailPanePreferenceKey(), orientation);
    }

    private void hideDetailPane() {
        if (this.fToggledDetailOnce) {
            this.setLastSashWeights(this.getSashForm().getWeights());
        }
        this.getSashForm().setMaximizedControl(this.getViewer().getControl());
    }

    private void showDetailPane() {
        this.getSashForm().setMaximizedControl(null);
        this.getSashForm().setWeights(this.getLastSashWeights());
        this.populateDetailPane();
        this.revealTreeSelection();
        this.fToggledDetailOnce = true;
    }

    protected void revealTreeSelection() {
        Object selected;
        ISelection selection;
        VariablesViewer viewer = this.getVariablesViewer();
        if (viewer != null && (selection = viewer.getSelection()) instanceof IStructuredSelection && (selected = ((IStructuredSelection)selection).getFirstElement()) != null) {
            viewer.reveal(selected);
        }
    }

    public void toggleDetailPaneWordWrap(boolean on) {
        this.fDetailViewer.getTextWidget().setWordWrap(on);
    }

    protected int[] getLastSashWeights() {
        if (this.fLastSashWeights == null) {
            this.fLastSashWeights = DEFAULT_SASH_WEIGHTS;
        }
        return this.fLastSashWeights;
    }

    protected void setLastSashWeights(int[] weights) {
        this.fLastSashWeights = weights;
    }

    protected void createDetailContextMenu(Control menuControl) {
        MenuManager menuMgr = new MenuManager();
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager mgr) {
                VariablesView.this.fillDetailContextMenu(mgr);
            }
        });
        Menu menu = menuMgr.createContextMenu(menuControl);
        menuControl.setMenu(menu);
        this.getSite().registerContextMenu("org.eclipse.debug.ui.VariableView.detail", menuMgr, this.getDetailViewer().getSelectionProvider());
        this.addContextMenuManager((IMenuManager)menuMgr);
    }

    protected void createActions() {
        Object action = new ShowTypesAction(this);
        this.setAction("ShowTypeNames", (IAction)action);
        action = new ToggleLogicalStructureAction(this);
        this.setAction("ToggleContentProviders", (IAction)action);
        action = new CollapseAllAction((AbstractTreeViewer)this.getVariablesViewer());
        this.setAction("CollapseAll", (IAction)action);
        action = new ChangeVariableValueAction(this.getViewer());
        action.setEnabled(false);
        this.setAction("ChangeVariableValue", (IAction)action);
        this.setAction("Double_Click_ActionId", (IAction)action);
        TextViewerAction textAction = new TextViewerAction((ITextViewer)this.getDetailViewer(), 13);
        textAction.setActionDefinitionId("org.eclipse.ui.edit.text.contentAssist.proposals");
        textAction.configureAction(VariablesViewMessages.getString("VariablesView.Co&ntent_Assist_3"), "", "");
        textAction.setImageDescriptor(DebugPluginImages.getImageDescriptor("IMG_ELCL_CONTENT_ASSIST"));
        textAction.setHoverImageDescriptor(DebugPluginImages.getImageDescriptor("IMG_LCL_CONTENT_ASSIST"));
        textAction.setDisabledImageDescriptor(DebugPluginImages.getImageDescriptor("IMG_DLCL_CONTENT_ASSIST"));
        this.setAction("ContentAssist", (IAction)textAction);
        this.getSite().getKeyBindingService().registerAction((IAction)textAction);
        textAction = new TextViewerAction((ITextViewer)this.getDetailViewer(), 7);
        textAction.configureAction(VariablesViewMessages.getString("VariablesView.Select_&All_5"), "", "");
        this.setAction(DETAIL_SELECT_ALL_ACTION, (IAction)textAction);
        textAction = new TextViewerAction((ITextViewer)this.getDetailViewer(), 4);
        textAction.configureAction(VariablesViewMessages.getString("VariablesView.&Copy_8"), "", "");
        this.setAction(DETAIL_COPY_ACTION, (IAction)textAction);
        textAction = new TextViewerAction((ITextViewer)this.getDetailViewer(), 3);
        textAction.configureAction(VariablesViewMessages.getString("VariablesView.Cu&t_11"), "", "");
        this.setAction(ActionFactory.CUT.getId(), (IAction)textAction);
        textAction = new TextViewerAction((ITextViewer)this.getDetailViewer(), 5);
        textAction.configureAction(VariablesViewMessages.getString("VariablesView.&Paste_14"), "", "");
        this.setAction(ActionFactory.PASTE.getId(), (IAction)textAction);
        ResourceBundle bundle = ResourceBundle.getBundle("org.eclipse.debug.internal.ui.views.variables.VariablesViewMessages");
        this.setAction(ActionFactory.FIND.getId(), (IAction)new FindReplaceAction(bundle, "find_replace_action.", (IWorkbenchPart)this));
        this.fSelectionActions.add(ActionFactory.COPY.getId());
        this.fSelectionActions.add(ActionFactory.CUT.getId());
        this.fSelectionActions.add(ActionFactory.PASTE.getId());
        this.updateAction(ActionFactory.FIND.getId());
    }

    private void createOrientationActions() {
        IActionBars actionBars = this.getViewSite().getActionBars();
        IMenuManager viewMenu = actionBars.getMenuManager();
        this.fToggleDetailPaneActions = new ToggleDetailPaneAction[3];
        this.fToggleDetailPaneActions[0] = new ToggleDetailPaneAction(this, "Variables.detail.orientation.underneath", null);
        this.fToggleDetailPaneActions[1] = new ToggleDetailPaneAction(this, "Variables.detail.orientation.right", null);
        this.fToggleDetailPaneActions[2] = new ToggleDetailPaneAction(this, "Variables.detail.orientation.hidden", this.getToggleActionLabel());
        viewMenu.add((IContributionItem)new Separator());
        viewMenu.add((IAction)this.fToggleDetailPaneActions[0]);
        viewMenu.add((IAction)this.fToggleDetailPaneActions[1]);
        viewMenu.add((IAction)this.fToggleDetailPaneActions[2]);
        viewMenu.add((IContributionItem)new Separator());
    }

    protected String getToggleActionLabel() {
        return VariablesViewMessages.getString("VariablesView.41");
    }

    protected void configureToolBar(IToolBarManager tbm) {
        tbm.add((IContributionItem)new Separator(this.getClass().getName()));
        tbm.add((IContributionItem)new Separator("renderGroup"));
        tbm.add(this.getAction("ShowTypeNames"));
        tbm.add(this.getAction("ToggleContentProviders"));
        tbm.add(this.getAction("CollapseAll"));
    }

    protected void fillContextMenu(IMenuManager menu) {
        menu.add((IContributionItem)new Separator("emptyVariableGroup"));
        menu.add((IContributionItem)new Separator("variableGroup"));
        menu.add(this.getAction("ChangeVariableValue"));
        AvailableLogicalStructuresAction action = new AvailableLogicalStructuresAction(this);
        if (action.isEnabled()) {
            menu.add((IAction)action);
        }
        menu.add((IContributionItem)new Separator("emptyRenderGroup"));
        menu.add((IContributionItem)new Separator("emptyNavigationGroup"));
        menu.add((IContributionItem)new Separator("additions"));
    }

    protected void fillDetailContextMenu(IMenuManager menu) {
        menu.add((IContributionItem)new Separator("variableGroup"));
        menu.add(this.getAction("ContentAssist"));
        menu.add((IContributionItem)new Separator());
        menu.add(this.getAction(ActionFactory.CUT.getId()));
        menu.add(this.getAction(String.valueOf(ActionFactory.COPY.getId()) + ".Detail"));
        menu.add(this.getAction(ActionFactory.PASTE.getId()));
        menu.add(this.getAction(DETAIL_SELECT_ALL_ACTION));
        menu.add((IContributionItem)new Separator("FIND"));
        menu.add(this.getAction(ActionFactory.FIND.getId()));
        menu.add((IContributionItem)new Separator("additions"));
    }

    protected ISelectionChangedListener getTreeSelectionChangedListener() {
        if (this.fTreeSelectionChangedListener == null) {
            this.fTreeSelectionChangedListener = new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    if (event.getSelectionProvider().equals((Object)VariablesView.this.getVariablesViewer())) {
                        VariablesView.this.clearStatusLine();
                        VariablesView.this.getVariablesViewSelectionProvider().fireSelectionChanged(event);
                        if (VariablesView.this.getSashForm().getMaximizedControl() == VariablesView.this.getViewer().getControl()) {
                            return;
                        }
                        IStructuredSelection selection = (IStructuredSelection)event.getSelection();
                        VariablesView.this.populateDetailPaneFromSelection(selection);
                        VariablesView.this.treeSelectionChanged(event);
                    }
                }
            };
        }
        return this.fTreeSelectionChangedListener;
    }

    protected void treeSelectionChanged(SelectionChangedEvent event) {
    }

    public void populateDetailPane() {
        Viewer viewer;
        if (this.isDetailPaneVisible() && (viewer = this.getViewer()) != null) {
            IStructuredSelection selection = (IStructuredSelection)viewer.getSelection();
            this.populateDetailPaneFromSelection(selection);
        }
    }

    protected void populateDetailPaneFromSelection(IStructuredSelection selection) {
        try {
            this.getDetailDocument().set("");
            if (!selection.isEmpty()) {
                IValue val = null;
                Object obj = selection.getFirstElement();
                if (obj instanceof IndexedVariablePartition) {
                    return;
                }
                if (obj instanceof IVariable) {
                    val = ((IVariable)obj).getValue();
                } else if (obj instanceof IExpression) {
                    val = ((IExpression)obj).getValue();
                }
                if (val == null) {
                    return;
                }
                if (this.fValueSelection != null && this.fValueSelection.equals(selection)) {
                    return;
                }
                this.setDebugModel(val.getModelIdentifier());
                this.fValueSelection = selection;
                this.fSelectionIterator = selection.iterator();
                this.fSelectionIterator.next();
                this.fLastValueDetail = val;
                this.getModelPresentation().computeDetail(val, this);
            }
        }
        catch (DebugException de) {
            DebugUIPlugin.log(de);
            this.getDetailDocument().set(VariablesViewMessages.getString("VariablesView.<error_occurred_retrieving_value>_18"));
        }
    }

    public void detailComputed(final IValue value, final String result) {
        Runnable runnable = new Runnable(){

            public void run() {
                if (VariablesView.this.isAvailable()) {
                    if (value == VariablesView.this.fLastValueDetail) {
                        String insert = result;
                        int length = VariablesView.this.getDetailDocument().get().length();
                        if (length > 0) {
                            insert = "\n" + result;
                        }
                        try {
                            VariablesView.this.getDetailDocument().replace(length, 0, insert);
                        }
                        catch (BadLocationException e) {
                            DebugUIPlugin.log(e);
                        }
                        VariablesView.this.fLastValueDetail = null;
                    }
                    if (VariablesView.this.fSelectionIterator != null && VariablesView.this.fSelectionIterator.hasNext()) {
                        Object obj = VariablesView.this.fSelectionIterator.next();
                        IValue val = null;
                        try {
                            if (obj instanceof IVariable) {
                                val = ((IVariable)obj).getValue();
                            } else if (obj instanceof IExpression) {
                                val = ((IExpression)obj).getValue();
                            }
                            VariablesView.this.fLastValueDetail = val;
                            VariablesView.this.getModelPresentation().computeDetail(val, VariablesView.this);
                        }
                        catch (DebugException e) {
                            DebugUIPlugin.log(e);
                            VariablesView.this.getDetailDocument().set(VariablesViewMessages.getString("VariablesView.<error_occurred_retrieving_value>_18"));
                        }
                    } else {
                        VariablesView.this.fValueSelection = null;
                        VariablesView.this.fSelectionIterator = null;
                    }
                }
            }
        };
        this.asyncExec(runnable);
    }

    protected ISelectionChangedListener getDetailSelectionChangedListener() {
        if (this.fDetailSelectionChangedListener == null) {
            this.fDetailSelectionChangedListener = new ISelectionChangedListener(){

                public void selectionChanged(SelectionChangedEvent event) {
                    if (event.getSelectionProvider().equals(VariablesView.this.getVariablesViewSelectionProvider().getUnderlyingSelectionProvider())) {
                        VariablesView.this.getVariablesViewSelectionProvider().fireSelectionChanged(event);
                        VariablesView.this.updateSelectionDependentActions();
                    }
                }
            };
        }
        return this.fDetailSelectionChangedListener;
    }

    protected IDocumentListener getDetailDocumentListener() {
        if (this.fDetailDocumentListener == null) {
            this.fDetailDocumentListener = new IDocumentListener(){

                public void documentAboutToBeChanged(DocumentEvent event) {
                }

                public void documentChanged(DocumentEvent event) {
                    VariablesView.this.updateAction(ActionFactory.FIND.getId());
                }
            };
        }
        return this.fDetailDocumentListener;
    }

    protected IDocument getDetailDocument() {
        if (this.fDetailDocument == null) {
            this.fDetailDocument = new Document();
        }
        return this.fDetailDocument;
    }

    protected IDebugModelPresentation getModelPresentation() {
        if (this.fModelPresentation == null) {
            this.fModelPresentation = new VariablesViewModelPresentation();
        }
        return this.fModelPresentation;
    }

    private void setDetailViewer(ISourceViewer viewer) {
        this.fDetailViewer = viewer;
    }

    protected ISourceViewer getDetailViewer() {
        return this.fDetailViewer;
    }

    protected SashForm getSashForm() {
        return this.fSashForm;
    }

    private void setSashForm(SashForm sashForm) {
        this.fSashForm = sashForm;
    }

    public Object getAdapter(Class required) {
        IBaseLabelProvider labelProvider;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("[Lorg.eclipse.jface.text.IFindReplaceTarget;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz.equals(required)) {
            return this.getDetailViewer().getFindReplaceTarget();
        }
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("[Lorg.eclipse.jface.text.ITextViewer;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz2.equals(required)) {
            return this.getDetailViewer();
        }
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("[Lorg.eclipse.debug.ui.IDebugModelPresentation;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if (clazz3.equals(required) && (labelProvider = this.getStructuredViewer().getLabelProvider()) instanceof VariablesViewLabelProvider) {
            return ((VariablesViewLabelProvider)labelProvider).getPresentation();
        }
        return super.getAdapter(required);
    }

    protected void updateSelectionDependentActions() {
        Iterator iterator = this.fSelectionActions.iterator();
        while (iterator.hasNext()) {
            this.updateAction((String)iterator.next());
        }
    }

    protected void updateAction(String actionId) {
        IAction action = this.getAction(actionId);
        if (action instanceof IUpdate) {
            ((IUpdate)action).update();
        }
    }

    protected boolean isDetailPaneVisible() {
        return !this.fToggleDetailPaneActions[2].isChecked();
    }

    protected void setDebugModel(String id) {
        if (id != this.fDebugModelIdentifier) {
            this.fDebugModelIdentifier = id;
            this.configureDetailsViewer();
        } else {
            this.updateAction("ContentAssist");
        }
    }

    protected String getDebugModel() {
        return this.fDebugModelIdentifier;
    }

    private void setDetailViewerConfiguration(SourceViewerConfiguration config) {
        this.fSourceViewerConfiguration = config;
    }

    protected SourceViewerConfiguration getDetailViewerConfiguration() {
        return this.fSourceViewerConfiguration;
    }

    protected Control getDefaultControl() {
        return this.getSashForm();
    }

    public void handleException(DebugException e) {
        this.showMessage(e.getMessage());
    }

    protected VariablesViewSelectionProvider getVariablesViewSelectionProvider() {
        return this.fSelectionProvider;
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (!this.isAvailable() || !this.isVisible()) {
            return;
        }
        if (selection == null) {
            this.setViewerInput((IStructuredSelection)new StructuredSelection());
        } else if (selection instanceof IStructuredSelection) {
            this.setViewerInput((IStructuredSelection)selection);
        } else {
            this.getDetailViewer().setEditable(false);
        }
        this.updateAction("ContentAssist");
    }

    public void doubleClick(DoubleClickEvent event) {
        IAction action = this.getAction("Double_Click_ActionId");
        if (action != null && action.isEnabled()) {
            action.run();
        } else {
            ISelection selection = event.getSelection();
            if (!(selection instanceof IStructuredSelection)) {
                return;
            }
            IStructuredSelection ss = (IStructuredSelection)selection;
            Object o = ss.getFirstElement();
            if (o != null) {
                TreeViewer tViewer;
                boolean expanded = (tViewer = (TreeViewer)this.getViewer()).getExpandedState(o);
                tViewer.setExpandedState(o, !expanded);
            }
        }
    }

    public void setFocus() {
        if (this.getFocusViewer() == null) {
            super.setFocus();
        } else {
            this.getFocusViewer().getControl().setFocus();
        }
    }

    protected void setFocusViewer(Viewer viewer) {
        this.fFocusViewer = viewer;
    }

    protected Viewer getFocusViewer() {
        return this.fFocusViewer;
    }

    public IDebugModelPresentation getPresentation(String id) {
        if (this.getViewer() instanceof StructuredViewer) {
            VariablesViewLabelProvider vvlp = (VariablesViewLabelProvider)((StructuredViewer)this.getViewer()).getLabelProvider();
            IDebugModelPresentation lp = vvlp.getPresentation();
            if (lp instanceof DelegatingModelPresentation) {
                return ((DelegatingModelPresentation)lp).getPresentation(id);
            }
            if (lp instanceof LazyModelPresentation && ((LazyModelPresentation)lp).getDebugModelIdentifier().equals(id)) {
                return lp;
            }
        }
        return null;
    }

    public Composite getDetailViewerParent() {
        return this.getSashForm();
    }

    public boolean isMainViewerAvailable() {
        return this.isAvailable();
    }

    public void setShowLogicalStructure(boolean flag) {
        ((VariablesViewContentProvider)this.getStructuredViewer().getContentProvider()).setShowLogicalStructure(flag);
    }

    public boolean isShowLogicalStructure() {
        return ((VariablesViewContentProvider)this.getStructuredViewer().getContentProvider()).isShowLogicalStructure();
    }

    protected int getArrayPartitionSize() {
        return 100;
    }

    protected void becomesHidden() {
        this.setViewerInput((IStructuredSelection)new StructuredSelection());
        super.becomesHidden();
    }

    protected void becomesVisible() {
        super.becomesVisible();
        IViewPart part = this.getSite().getPage().findView("org.eclipse.debug.ui.DebugView");
        if (part != null) {
            ISelection selection = this.getSite().getPage().getSelection("org.eclipse.debug.ui.DebugView");
            this.selectionChanged((IWorkbenchPart)part, selection);
        }
    }

    protected class VariablesViewLabelProvider
    implements ILabelProvider,
    IColorProvider {
        protected IDebugModelPresentation presentation;

        public VariablesViewLabelProvider(IDebugModelPresentation presentation) {
            this.presentation = presentation;
        }

        public IDebugModelPresentation getPresentation() {
            return this.presentation;
        }

        public Image getImage(Object element) {
            return this.presentation.getImage(element);
        }

        public String getText(Object element) {
            return this.presentation.getText(element);
        }

        public void addListener(ILabelProviderListener listener) {
            this.presentation.addListener(listener);
        }

        public void dispose() {
            this.presentation.dispose();
        }

        public boolean isLabelProperty(Object element, String property) {
            return this.presentation.isLabelProperty(element, property);
        }

        public void removeListener(ILabelProviderListener listener) {
            this.presentation.removeListener(listener);
        }

        public Color getForeground(Object element) {
            if (element instanceof IVariable) {
                IVariable variable = (IVariable)element;
                try {
                    if (variable.hasValueChanged()) {
                        return DebugUIPlugin.getPreferenceColor("Changed.Variable.RGB");
                    }
                }
                catch (DebugException e) {
                    DebugUIPlugin.log(e);
                }
            }
            return null;
        }

        public Color getBackground(Object element) {
            return null;
        }
    }

    class VariablesViewSelectionProvider
    implements ISelectionProvider {
        private ListenerList fListeners = new ListenerList();
        private ISelectionProvider fUnderlyingSelectionProvider;

        VariablesViewSelectionProvider() {
        }

        public void addSelectionChangedListener(ISelectionChangedListener listener) {
            this.fListeners.add((Object)listener);
        }

        public ISelection getSelection() {
            return this.getUnderlyingSelectionProvider().getSelection();
        }

        public void removeSelectionChangedListener(ISelectionChangedListener listener) {
            this.fListeners.remove((Object)listener);
        }

        public void setSelection(ISelection selection) {
            this.getUnderlyingSelectionProvider().setSelection(selection);
        }

        protected ISelectionProvider getUnderlyingSelectionProvider() {
            return this.fUnderlyingSelectionProvider;
        }

        protected void setUnderlyingSelectionProvider(ISelectionProvider underlyingSelectionProvider) {
            this.fUnderlyingSelectionProvider = underlyingSelectionProvider;
        }

        protected void fireSelectionChanged(SelectionChangedEvent event) {
            Object[] listeners = this.fListeners.getListeners();
            int i = 0;
            while (i < listeners.length) {
                ISelectionChangedListener listener = (ISelectionChangedListener)listeners[i];
                listener.selectionChanged(event);
                ++i;
            }
        }
    }
}

