/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.launch;

import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.internal.ui.views.launch.Decoration;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class TextEditorSelection
extends Decoration {
    protected ITextEditor fEditor;
    protected int fLine;
    protected int fOffset;
    protected int fLength;
    protected IThread fThread;

    public TextEditorSelection(ITextEditor editor, int lineNumber, int offset, int length, IThread thread) {
        this.fEditor = editor;
        this.fOffset = offset;
        this.fLength = length;
        this.fThread = thread;
        this.fLine = lineNumber;
    }

    public IThread getThread() {
        return this.fThread;
    }

    public void remove() {
        ISelectionProvider provider = this.fEditor.getSelectionProvider();
        if (provider == null) {
            return;
        }
        ITextSelection textSelection = (ITextSelection)provider.getSelection();
        if (textSelection.isEmpty()) {
            return;
        }
        int offset = textSelection.getOffset();
        int length = textSelection.getLength();
        if (this.fOffset == offset && this.fLength == length) {
            ITextSelection nullSelection = this.getNullSelection(this.fLine, this.fOffset);
            this.fEditor.getSelectionProvider().setSelection((ISelection)nullSelection);
        }
    }

    protected ITextSelection getNullSelection(final int startLine, final int startChar) {
        return new ITextSelection(){

            public int getStartLine() {
                return startLine;
            }

            public int getEndLine() {
                return startLine;
            }

            public int getOffset() {
                return startChar;
            }

            public String getText() {
                return "";
            }

            public int getLength() {
                return 0;
            }

            public boolean isEmpty() {
                return true;
            }
        };
    }
}

