/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.launch;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.ListIterator;
import java.util.Set;
import java.util.Vector;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.views.DebugUIViewsMessages;
import org.eclipse.debug.internal.ui.views.launch.LaunchViewDecoratingLabelProvider;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ILabelDecorator;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.jface.viewers.LabelProviderChangedEvent;
import org.eclipse.swt.graphics.Image;

public class LaunchViewLabelDecorator
extends LabelProvider
implements ILabelDecorator,
IDebugEventSetListener {
    private IDebugModelPresentation fPresentation;
    private LaunchViewDecoratingLabelProvider fLabelProvider;
    protected LabelJob fNextJob = null;
    private Set resumedThreads = new HashSet();
    private IStackFrame fCurrentStackFrame = null;
    private Object fCurrentStackFrameLock = new Object();

    public LaunchViewLabelDecorator(IDebugModelPresentation presentation) {
        this.fPresentation = presentation;
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
    }

    public void setLabelProvider(LaunchViewDecoratingLabelProvider labelProvider) {
        this.fLabelProvider = labelProvider;
    }

    public Image decorateImage(Image image, Object element) {
        return image;
    }

    public String decorateText(String text, Object element) {
        this.computeText(element);
        return text;
    }

    public void computeText(Object element) {
        LaunchViewLabelDecorator launchViewLabelDecorator = this;
        synchronized (launchViewLabelDecorator) {
            if (this.fNextJob == null) {
                this.fNextJob = new LabelJob(DebugUIViewsMessages.getString("LaunchViewLabelDecorator.0"), this.fPresentation);
            }
            this.fNextJob.computeText(element);
        }
    }

    public void labelsComputed(final Object[] computedElements) {
        DebugUIPlugin.getStandardDisplay().asyncExec(new Runnable(){

            public void run() {
                LaunchViewLabelDecorator.this.fireLabelProviderChanged(new LabelProviderChangedEvent((IBaseLabelProvider)LaunchViewLabelDecorator.this, computedElements));
            }
        });
    }

    public void handleDebugEvents(DebugEvent[] events) {
        int i = 0;
        while (i < events.length) {
            DebugEvent event = events[i];
            if (event.getKind() == 2) {
                this.handleSuspendEvent(event);
            } else if (event.getKind() == 8) {
                this.handleTerminateEvent(event);
            } else if (event.getKind() == 1) {
                this.handleResumeEvent(event);
            }
            ++i;
        }
    }

    private void handleResumeEvent(DebugEvent event) {
        if (event.getSource() instanceof IThread && (event.isEvaluation() || event.isStepStart())) {
            IStackFrame frame;
            IThread thread = (IThread)event.getSource();
            Object object = this.fCurrentStackFrameLock;
            synchronized (object) {
                if (this.fCurrentStackFrame == null) {
                    return;
                }
                frame = this.fCurrentStackFrame;
            }
            if (thread == frame.getThread()) {
                this.resumedThreads.add(thread);
            }
        }
    }

    private void handleTerminateEvent(DebugEvent event) {
        Object source = event.getSource();
        if (source instanceof IDebugTarget) {
            ArrayList copiedThreads = new ArrayList(this.resumedThreads);
            ListIterator iterator = copiedThreads.listIterator();
            while (iterator.hasNext()) {
                IThread thread = (IThread)iterator.next();
                if (thread.getDebugTarget() != source) continue;
                iterator.remove();
            }
            Set set = this.resumedThreads;
            synchronized (set) {
                this.resumedThreads.retainAll(copiedThreads);
            }
        }
    }

    private void handleSuspendEvent(DebugEvent event) {
        Object source = event.getSource();
        Set set = this.resumedThreads;
        synchronized (set) {
            if (!this.resumedThreads.remove(source)) {
                return;
            }
        }
        if (!event.isEvaluation() && (event.getDetail() & 8) == 0) {
            return;
        }
        IThread thread = (IThread)source;
        try {
            IStackFrame[] frames = thread.getStackFrames();
            int i = 0;
            while (i < frames.length) {
                this.computeText(frames[i]);
                ++i;
            }
        }
        catch (DebugException debugException) {}
    }

    public void dispose() {
        super.dispose();
        DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
    }

    protected class LabelJob
    extends Job
    implements ISchedulingRule {
        private Vector fElementQueue = new Vector();
        private IDebugModelPresentation fJobPresentation;

        public LabelJob(String name, IDebugModelPresentation presentation) {
            super(name);
            this.fJobPresentation = presentation;
            this.setRule(this);
        }

        public void computeText(Object element) {
            if (!this.fElementQueue.contains(element)) {
                if (element instanceof IStackFrame) {
                    this.fElementQueue.add(element);
                } else {
                    this.fElementQueue.add(0, element);
                }
            }
            this.schedule();
        }

        public IStatus run(IProgressMonitor monitor) {
            LabelJob labelJob = this;
            synchronized (labelJob) {
                LaunchViewLabelDecorator.this.fNextJob = null;
            }
            int numElements = this.fElementQueue.size();
            monitor.beginTask(MessageFormat.format(DebugUIViewsMessages.getString("LaunchViewLabelDecorator.1"), Integer.toString(numElements)), numElements);
            while (!this.fElementQueue.isEmpty() && !monitor.isCanceled()) {
                StringBuffer message = new StringBuffer(MessageFormat.format(DebugUIViewsMessages.getString("LaunchViewLabelDecorator.1"), Integer.toString(this.fElementQueue.size())));
                if (LaunchViewLabelDecorator.this.fNextJob != null) {
                    message.append(MessageFormat.format(DebugUIViewsMessages.getString("LaunchViewLabelDecorator.2"), Integer.toString(LaunchViewLabelDecorator.this.fNextJob.fElementQueue.size())));
                }
                monitor.setTaskName(message.toString());
                int blockSize = 10;
                if (this.fElementQueue.size() < blockSize) {
                    blockSize = this.fElementQueue.size();
                }
                ArrayList computedElements = new ArrayList();
                int i = 0;
                while (i < blockSize) {
                    Object object;
                    Object element = this.fElementQueue.remove(0);
                    if (element == null) break;
                    if (element instanceof IStackFrame) {
                        object = LaunchViewLabelDecorator.this.fCurrentStackFrameLock;
                        synchronized (object) {
                            LaunchViewLabelDecorator.this.fCurrentStackFrame = (IStackFrame)element;
                        }
                        IThread thread = LaunchViewLabelDecorator.this.fCurrentStackFrame.getThread();
                        Set set = LaunchViewLabelDecorator.this.resumedThreads;
                        synchronized (set) {
                            if (!thread.isTerminated() && !thread.isSuspended()) {
                                LaunchViewLabelDecorator.this.resumedThreads.add(thread);
                            }
                        }
                    }
                    LaunchViewLabelDecorator.this.fLabelProvider.textComputed(element, this.fJobPresentation.getText(element));
                    object = LaunchViewLabelDecorator.this.fCurrentStackFrameLock;
                    synchronized (object) {
                        LaunchViewLabelDecorator.this.fCurrentStackFrame = null;
                    }
                    computedElements.add(element);
                    ++i;
                }
                LaunchViewLabelDecorator.this.labelsComputed(computedElements.toArray());
                monitor.worked(computedElements.size());
            }
            monitor.done();
            return Status.OK_STATUS;
        }

        public boolean contains(ISchedulingRule rule) {
            return rule instanceof LabelJob && this.fJobPresentation == ((LabelJob)rule).fJobPresentation;
        }

        public boolean isConflicting(ISchedulingRule rule) {
            return rule instanceof LabelJob && this.fJobPresentation == ((LabelJob)rule).fJobPresentation;
        }
    }
}

