/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.launch;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.ILaunchesListener;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.views.AbstractDebugEventHandler;
import org.eclipse.debug.internal.ui.views.launch.LaunchView;
import org.eclipse.debug.internal.ui.views.launch.LaunchViewer;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;

public class LaunchViewEventHandler
extends AbstractDebugEventHandler
implements ILaunchesListener {
    private ThreadTimer fThreadTimer = new ThreadTimer();
    private IStackFrame fLastStackFrame = null;

    public LaunchViewEventHandler(LaunchView view) {
        super(view);
        DebugPlugin plugin = DebugPlugin.getDefault();
        plugin.getLaunchManager().addLaunchListener((ILaunchesListener)this);
    }

    protected void doHandleDebugEvents(DebugEvent[] events) {
        this.fThreadTimer.handleDebugEvents(events);
        Object suspendee = null;
        int i = 0;
        while (i < events.length) {
            DebugEvent event = events[i];
            Object source = event.getSource();
            if (!(source instanceof IStackFrame || source instanceof IThread || source instanceof IDebugTarget || source instanceof IProcess)) {
                return;
            }
            switch (event.getKind()) {
                case 4: {
                    this.insert(source);
                    if (!(source instanceof IDebugTarget)) break;
                    ILaunch launch = ((IDebugTarget)source).getLaunch();
                    this.getLaunchView().autoExpand(launch, false, true);
                    break;
                }
                case 8: {
                    if (source instanceof IThread) {
                        this.clearSourceSelection(source);
                        this.fThreadTimer.getTimedOutThreads().remove(source);
                        this.remove(source);
                        break;
                    }
                    if (source instanceof IDebugTarget) {
                        this.clearSourceSelection(source);
                    }
                    Object parent = ((ITreeContentProvider)this.getTreeViewer().getContentProvider()).getParent(source);
                    this.refresh(parent);
                    break;
                }
                case 1: {
                    this.doHandleResumeEvent(event, source);
                    break;
                }
                case 2: {
                    if (suspendee != null && suspendee.equals(source)) break;
                    this.doHandleSuspendEvent(source, event);
                    suspendee = source;
                    break;
                }
                case 16: {
                    IStackFrame lastFrame;
                    if (source instanceof IStackFrame && source.equals(lastFrame = this.getLaunchView().getStackFrame())) {
                        this.getLaunchView().setStackFrame(null);
                    }
                    if (event.getDetail() == 256) {
                        this.labelChanged(source);
                        break;
                    }
                    this.refresh(source);
                }
            }
            ++i;
        }
    }

    protected void doHandleResumeEvent(DebugEvent event, Object source) {
        if (!event.isEvaluation()) {
            this.clearSourceSelection(source);
        }
        if (event.isEvaluation() || event.isStepStart()) {
            IThread thread = this.getThread(source);
            if (thread != null) {
                this.fThreadTimer.startTimer(thread);
            }
            return;
        }
        this.refresh(source);
        if (source instanceof IThread) {
            try {
                IThread[] threads = ((IThread)source).getDebugTarget().getThreads();
                int i = 0;
                while (i < threads.length) {
                    IStackFrame frame = threads[i].getTopStackFrame();
                    if (frame != null) {
                        this.selectAndReveal(frame);
                        return;
                    }
                    ++i;
                }
            }
            catch (DebugException debugException) {}
            this.selectAndReveal(source);
            return;
        }
    }

    protected void updateRunningThread(IThread thread) {
        this.labelChanged(thread);
        this.getLaunchViewer().updateStackFrameImages(thread);
        this.clearSourceSelection(thread);
    }

    protected void doHandleSuspendEvent(Object element, DebugEvent event) {
        IThread thread = this.getThread(element);
        if (thread != null) {
            this.fThreadTimer.stopTimer((IThread)element);
        }
        boolean wasTimedOut = this.fThreadTimer.getTimedOutThreads().remove(thread);
        if (event.isEvaluation() && (event.getDetail() & 0x80) != 0 && thread != null && !wasTimedOut) {
            return;
        }
        if (element instanceof IThread) {
            this.doHandleSuspendThreadEvent((IThread)element, event, wasTimedOut);
            return;
        }
        this.refresh(element);
    }

    protected void doHandleSuspendThreadEvent(IThread thread, DebugEvent event, boolean wasTimedOut) {
        if (!thread.isSuspended()) {
            return;
        }
        boolean evaluationEvent = event.isEvaluation();
        try {
            IStackFrame frame = thread.getTopStackFrame();
            if (frame != null && frame.equals(this.fLastStackFrame)) {
                if (wasTimedOut) {
                    this.getLaunchViewer().updateStackFrameImages(thread);
                }
                this.getLaunchViewer().update(new Object[]{thread, frame}, null);
                if (!evaluationEvent) {
                    this.getLaunchViewer().setSelection((ISelection)new StructuredSelection((Object)frame));
                } else if (wasTimedOut) {
                    this.getLaunchView().showEditorForCurrentSelection();
                }
                return;
            }
        }
        catch (DebugException debugException) {}
        this.getLaunchView().autoExpand(thread, true, !evaluationEvent);
        try {
            this.fLastStackFrame = thread.getTopStackFrame();
        }
        catch (DebugException debugException) {
            this.fLastStackFrame = null;
        }
    }

    protected void updateForDebugEvents(DebugEvent[] events) {
        super.updateForDebugEvents(events);
        if (this.isViewVisible()) {
            return;
        }
        this.doHandleDebugEvents(events);
    }

    public void dispose() {
        super.dispose();
        this.fThreadTimer.stop();
        DebugPlugin plugin = DebugPlugin.getDefault();
        plugin.getLaunchManager().removeLaunchListener((ILaunchesListener)this);
    }

    private void clearSourceSelection(Object source) {
        if (this.getViewer() != null) {
            this.getLaunchView().clearSourceSelection(source);
        }
    }

    protected LaunchViewer getLaunchViewer() {
        return (LaunchViewer)this.getViewer();
    }

    protected LaunchView getLaunchView() {
        return (LaunchView)this.getView();
    }

    private IThread getThread(Object element) {
        IThread thread = null;
        if (element instanceof IThread) {
            thread = (IThread)element;
        } else if (element instanceof IStackFrame) {
            thread = ((IStackFrame)element).getThread();
        }
        return thread;
    }

    public void launchesAdded(final ILaunch[] launches) {
        Runnable r = new Runnable(){

            public void run() {
                if (LaunchViewEventHandler.this.isAvailable()) {
                    if (launches.length == 1) {
                        LaunchViewEventHandler.this.insert(launches[0]);
                    } else {
                        LaunchViewEventHandler.this.refresh();
                    }
                    int i = 0;
                    while (i < launches.length) {
                        if (launches[i].hasChildren()) {
                            LaunchViewEventHandler.this.getLaunchView().autoExpand(launches[i], false, i == launches.length - 1);
                        }
                        ++i;
                    }
                }
            }
        };
        this.getView().syncExec(r);
    }

    public void launchesChanged(final ILaunch[] launches) {
        Runnable r = new Runnable(){

            public void run() {
                if (LaunchViewEventHandler.this.isAvailable()) {
                    if (launches.length == 1) {
                        LaunchViewEventHandler.this.refresh(launches[0]);
                    } else {
                        LaunchViewEventHandler.this.refresh();
                    }
                    int i = 0;
                    while (i < launches.length) {
                        if (launches[i].hasChildren()) {
                            LaunchViewEventHandler.this.getLaunchView().autoExpand(launches[i], false, i == launches.length - 1);
                        }
                        ++i;
                    }
                }
            }
        };
        this.getView().syncExec(r);
    }

    public void launchesRemoved(final ILaunch[] launches) {
        Runnable r = new Runnable(){

            public void run() {
                if (LaunchViewEventHandler.this.isAvailable()) {
                    if (launches.length == 1) {
                        LaunchViewEventHandler.this.remove(launches[0]);
                    } else {
                        LaunchViewEventHandler.this.refresh();
                    }
                    ILaunchManager lm = DebugPlugin.getDefault().getLaunchManager();
                    IDebugTarget[] targets = lm.getDebugTargets();
                    if (targets.length > 0) {
                        IDebugTarget target = targets[targets.length - 1];
                        try {
                            IThread[] threads = target.getThreads();
                            int i = 0;
                            while (i < threads.length) {
                                if (threads[i].isSuspended()) {
                                    LaunchViewEventHandler.this.getLaunchView().autoExpand(threads[i], false, true);
                                    return;
                                }
                                ++i;
                            }
                        }
                        catch (DebugException de) {
                            DebugUIPlugin.log(de);
                        }
                        LaunchViewEventHandler.this.getLaunchView().autoExpand(target.getLaunch(), false, true);
                    }
                }
            }
        };
        this.getView().asyncExec(r);
    }

    class ThreadTimer {
        private Thread fThread;
        private long TIMEOUT = 500L;
        private long timeEmpty = 0L;
        private long MAX_TIME_EMPTY = 3000L;
        private boolean fStopped = false;
        private Object fLock = new Object();
        HashMap fStopTimes = new HashMap();
        HashSet fTimedOutThreads = new HashSet();

        ThreadTimer() {
        }

        public Set getTimedOutThreads() {
            return this.fTimedOutThreads;
        }

        public void handleDebugEvents(DebugEvent[] events) {
            if (this.fStopped) {
                return;
            }
            int i = 0;
            int numEvents = events.length;
            while (i < numEvents) {
                DebugEvent event = events[i];
                if (event.getKind() == 8 && event.getSource() instanceof IDebugTarget) {
                    ILaunch[] launches = DebugPlugin.getDefault().getLaunchManager().getLaunches();
                    int j = 0;
                    while (j < launches.length) {
                        IDebugTarget[] targets = launches[j].getDebugTargets();
                        int k = 0;
                        while (k < targets.length) {
                            IDebugTarget target = targets[k];
                            if (target != null && !target.isDisconnected() && !target.isTerminated()) {
                                return;
                            }
                            ++k;
                        }
                        ++j;
                    }
                    this.stop();
                    return;
                }
                ++i;
            }
        }

        public void startTimer(IThread thread) {
            Object object = this.fLock;
            synchronized (object) {
                this.fStopTimes.put(thread, new Long(System.currentTimeMillis() + this.TIMEOUT));
                if (this.fThread == null) {
                    this.startThread();
                }
            }
        }

        public void stop() {
            Object object = this.fLock;
            synchronized (object) {
                this.fStopped = true;
                this.fThread = null;
                this.fStopTimes.clear();
            }
        }

        public void stopTimer(IThread thread) {
            Object object = this.fLock;
            synchronized (object) {
                this.fStopTimes.remove(thread);
            }
        }

        private void startThread() {
            this.fThread = new Thread(new Runnable(this){
                final /* synthetic */ ThreadTimer this$1;
                {
                    this.this$1 = threadTimer;
                }

                public void run() {
                    ThreadTimer.access$0(this.this$1, false);
                    while (!ThreadTimer.access$1(this.this$1)) {
                        ThreadTimer.access$2(this.this$1);
                    }
                }
            }, "Thread timer");
            this.fThread.start();
        }

        private void checkTimers() {
            Map.Entry[] entries;
            long timeToWait = this.TIMEOUT;
            Object object = this.fLock;
            synchronized (object) {
                if (this.fStopTimes.size() == 0) {
                    if (this.timeEmpty == 0L) {
                        this.timeEmpty = System.currentTimeMillis();
                    } else if (System.currentTimeMillis() - this.timeEmpty > this.MAX_TIME_EMPTY) {
                        this.stop();
                        return;
                    }
                } else {
                    this.timeEmpty = 0L;
                }
                entries = this.fStopTimes.entrySet().toArray(new Map.Entry[0]);
            }
            long currentTime = System.currentTimeMillis();
            Map.Entry entry = null;
            int i = 0;
            int numEntries = entries.length;
            while (i < numEntries) {
                entry = entries[i];
                Long entryValue = (Long)entry.getValue();
                if (entryValue != null) {
                    long stopTime = entryValue;
                    if (stopTime <= currentTime) {
                        IThread thread = (IThread)entry.getKey();
                        this.fStopTimes.remove(thread);
                        LaunchViewEventHandler.this.getView().asyncExec(new Runnable(this, thread){
                            final /* synthetic */ ThreadTimer this$1;
                            private final /* synthetic */ IThread val$thread;
                            {
                                this.this$1 = threadTimer;
                                this.val$thread = iThread;
                            }

                            public void run() {
                                this.this$1.fTimedOutThreads.add(this.val$thread);
                                ThreadTimer.access$3(this.this$1).updateRunningThread(this.val$thread);
                            }
                        });
                    } else {
                        timeToWait = Math.min(timeToWait, stopTime - currentTime);
                    }
                }
                ++i;
            }
            try {
                Thread.sleep(timeToWait);
            }
            catch (InterruptedException interruptedException) {}
        }

        static /* synthetic */ void access$0(ThreadTimer threadTimer, boolean bl) {
            threadTimer.fStopped = bl;
        }

        static /* synthetic */ boolean access$1(ThreadTimer threadTimer) {
            return threadTimer.fStopped;
        }

        static /* synthetic */ void access$2(ThreadTimer threadTimer) {
            threadTimer.checkTimers();
        }

        static /* synthetic */ LaunchViewEventHandler access$3(ThreadTimer threadTimer) {
            return threadTimer.LaunchViewEventHandler.this;
        }
    }
}

