/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.expression;

import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IErrorReportingExpression;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.debug.core.model.IWatchExpression;
import org.eclipse.debug.internal.ui.ColorManager;
import org.eclipse.debug.internal.ui.IDebugHelpContextIds;
import org.eclipse.debug.internal.ui.views.AbstractDebugEventHandler;
import org.eclipse.debug.internal.ui.views.expression.ExpressionViewContentProvider;
import org.eclipse.debug.internal.ui.views.expression.ExpressionViewEventHandler;
import org.eclipse.debug.internal.ui.views.variables.VariablesView;
import org.eclipse.debug.internal.ui.views.variables.VariablesViewContentProvider;
import org.eclipse.debug.internal.ui.views.variables.VariablesViewMessages;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.ui.IWorkbenchPart;

public class ExpressionView
extends VariablesView {
    protected IBaseLabelProvider createLabelProvider() {
        return new ExpressionViewLabelProvider(this.getModelPresentation());
    }

    protected IContentProvider createContentProvider() {
        return new ExpressionViewContentProvider(this);
    }

    protected AbstractDebugEventHandler createEventHandler() {
        return new ExpressionViewEventHandler(this);
    }

    protected String getHelpContextId() {
        return IDebugHelpContextIds.EXPRESSION_VIEW;
    }

    protected void setInitialContent() {
        this.getViewer().setInput((Object)DebugPlugin.getDefault().getExpressionManager());
    }

    protected void configureToolBar(IToolBarManager tbm) {
        super.configureToolBar(tbm);
        tbm.add((IContributionItem)new Separator("emptyExpressionGroup"));
        tbm.add((IContributionItem)new Separator("expressionGroup"));
    }

    protected void fillContextMenu(IMenuManager menu) {
        menu.add((IContributionItem)new Separator("emptyExpressionGroup"));
        menu.add((IContributionItem)new Separator("expressionGroup"));
        menu.add(this.getAction("ChangeVariableValue"));
        menu.add((IContributionItem)new Separator("emptyRenderGroup"));
        menu.add((IContributionItem)new Separator("additions"));
    }

    public void selectionChanged(IWorkbenchPart part, ISelection selection) {
        if (selection instanceof IStructuredSelection) {
            IDebugElement context = null;
            IStructuredSelection ss = (IStructuredSelection)selection;
            if (ss.size() < 2) {
                Object object = ss.getFirstElement();
                if (object instanceof IDebugElement) {
                    context = (IDebugElement)object;
                } else if (object instanceof ILaunch) {
                    context = ((ILaunch)object).getDebugTarget();
                }
            }
            IExpression[] expressions = DebugPlugin.getDefault().getExpressionManager().getExpressions();
            int i = 0;
            while (i < expressions.length) {
                IExpression expression = expressions[i];
                if (expression instanceof IWatchExpression) {
                    ((IWatchExpression)expression).setExpressionContext(context);
                }
                ++i;
            }
        }
        this.updateAction("ContentAssist");
    }

    protected void setViewerInput(IStructuredSelection ssel) {
    }

    protected void treeSelectionChanged(SelectionChangedEvent event) {
        Object input;
        IStructuredSelection ssel;
        super.treeSelectionChanged(event);
        ISelection selection = event.getSelection();
        if (selection instanceof IStructuredSelection && (ssel = (IStructuredSelection)selection).size() == 1 && (input = ssel.getFirstElement()) instanceof IDebugElement) {
            this.getDetailViewer().setEditable(true);
            return;
        }
        this.getDetailViewer().setEditable(false);
    }

    protected String getDetailPanePreferenceKey() {
        return "Expressions.detail.orientation";
    }

    protected String getToggleActionLabel() {
        return VariablesViewMessages.getString("ExpressionView.4");
    }

    protected void createActions() {
        super.createActions();
        this.setInitialContent();
    }

    protected class ExpressionViewLabelProvider
    extends VariablesView.VariablesViewLabelProvider {
        public Color getForeground(Object element) {
            Object parent;
            boolean expressionWithError = false;
            IErrorReportingExpression expression = null;
            if (element instanceof IErrorReportingExpression) {
                expression = (IErrorReportingExpression)element;
            } else if (element instanceof String && (parent = ((VariablesViewContentProvider)ExpressionView.this.getVariablesViewer().getContentProvider()).getParent(element)) instanceof IErrorReportingExpression) {
                expression = (IErrorReportingExpression)parent;
            }
            if (expression != null && expression.hasErrors()) {
                expressionWithError = true;
            }
            if (expressionWithError) {
                return ColorManager.getDefault().getColor(new RGB(255, 0, 0));
            }
            return super.getForeground(element);
        }

        public ExpressionViewLabelProvider(IDebugModelPresentation presentation) {
            super(ExpressionView.this, presentation);
        }
    }
}

