/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.console;

import java.text.MessageFormat;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.internal.ui.DebugPluginImages;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.views.console.ConsoleMessages;
import org.eclipse.debug.internal.ui.views.console.ProcessConsolePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.ui.console.AbstractConsole;
import org.eclipse.ui.console.IConsoleView;
import org.eclipse.ui.part.IPageBookViewPage;

public class ProcessConsole
extends AbstractConsole
implements IDebugEventSetListener {
    private IProcess fProcess = null;

    public IPageBookViewPage createPage(IConsoleView view) {
        return new ProcessConsolePage(view, this);
    }

    protected ImageDescriptor computeImageDescriptor() {
        ILaunchConfiguration configuration = this.getProcess().getLaunch().getLaunchConfiguration();
        if (configuration != null) {
            try {
                ILaunchConfigurationType type = configuration.getType();
                return DebugPluginImages.getImageDescriptor(type.getIdentifier());
            }
            catch (CoreException e) {
                DebugUIPlugin.log(e);
            }
        }
        return null;
    }

    protected String computeName() {
        ILaunchConfiguration configuration = this.getProcess().getLaunch().getLaunchConfiguration();
        if (configuration != null) {
            if (this.getProcess().isTerminated()) {
                return MessageFormat.format(ConsoleMessages.getString("ProcessConsole.0"), configuration.getName());
            }
            return configuration.getName();
        }
        if (this.getProcess().isTerminated()) {
            return MessageFormat.format(ConsoleMessages.getString("ProcessConsole.0"), this.getProcess().getLabel());
        }
        return this.getProcess().getLabel();
    }

    public ProcessConsole(IProcess process) {
        super("", null);
        this.fProcess = process;
        this.setName(this.computeName());
        this.setImageDescriptor(this.computeImageDescriptor());
    }

    public IProcess getProcess() {
        return this.fProcess;
    }

    protected void dispose() {
        super.dispose();
        DebugPlugin.getDefault().removeDebugEventListener((IDebugEventSetListener)this);
    }

    protected void init() {
        super.init();
        DebugPlugin.getDefault().addDebugEventListener((IDebugEventSetListener)this);
    }

    public void handleDebugEvents(DebugEvent[] events) {
        int i = 0;
        while (i < events.length) {
            DebugEvent event = events[i];
            if (event.getSource().equals(this.getProcess())) {
                Runnable r = new Runnable(){

                    public void run() {
                        ProcessConsole.this.setName(ProcessConsole.this.computeName());
                    }
                };
                DebugUIPlugin.getStandardDisplay().asyncExec(r);
            }
            ++i;
        }
    }
}

