/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.console;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchListener;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.views.console.ConsoleDocumentProvider;
import org.eclipse.debug.internal.ui.views.console.ConsoleLineNotifier;
import org.eclipse.debug.internal.ui.views.console.ConsoleMessages;
import org.eclipse.debug.internal.ui.views.console.ProcessConsole;
import org.eclipse.debug.ui.console.IConsoleColorProvider;
import org.eclipse.debug.ui.console.IConsoleLineTracker;
import org.eclipse.jface.text.IDocument;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.IConsoleManager;
import org.eclipse.ui.console.IConsoleView;
import org.eclipse.ui.texteditor.IDocumentProvider;

public class ConsoleDocumentManager
implements ILaunchListener {
    private Map fColorProviders;
    private Map fLineTrackers;
    protected IDocumentProvider fDefaultDocumentProvider = null;

    public void launchRemoved(ILaunch launch) {
        this.removeLaunch(launch);
    }

    protected void removeLaunch(ILaunch launch) {
        IProcess[] processes = launch.getProcesses();
        IConsoleManager manager = ConsolePlugin.getDefault().getConsoleManager();
        int i = 0;
        while (i < processes.length) {
            IProcess iProcess = processes[i];
            IConsole console = this.getConsole(iProcess);
            if (console != null) {
                manager.removeConsoles(new IConsole[]{console});
            }
            IDocumentProvider provider = this.getDocumentProvider();
            provider.disconnect((Object)iProcess);
            ++i;
        }
    }

    private IConsole getConsole(IProcess process) {
        IConsoleManager manager = ConsolePlugin.getDefault().getConsoleManager();
        IConsole[] consoles = manager.getConsoles();
        int i = 0;
        while (i < consoles.length) {
            ProcessConsole pc;
            IConsole console = consoles[i];
            if (console instanceof ProcessConsole && (pc = (ProcessConsole)console).getProcess().equals(process)) {
                return pc;
            }
            ++i;
        }
        return null;
    }

    public void launchAdded(ILaunch launch) {
        this.launchChanged(launch);
    }

    public void launchChanged(final ILaunch launch) {
        if (launch.getProcesses().length > 0) {
            DebugUIPlugin.getStandardDisplay().syncExec(new Runnable(){

                public void run() {
                    IProcess[] processes = launch.getProcesses();
                    int i = 0;
                    while (i < processes.length) {
                        if (ConsoleDocumentManager.this.getConsoleDocument(processes[i]) == null) {
                            IProcess process = processes[i];
                            IDocumentProvider provider = ConsoleDocumentManager.this.getDocumentProvider();
                            try {
                                provider.connect((Object)process);
                            }
                            catch (CoreException coreException) {}
                            ProcessConsole pc = new ProcessConsole(process);
                            ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{pc});
                        }
                        ++i;
                    }
                }
            });
        }
    }

    public IDocument getConsoleDocument(IProcess process) {
        IDocumentProvider provider = this.getDocumentProvider();
        return provider.getDocument((Object)process);
    }

    private IDocumentProvider getDocumentProvider() {
        if (this.fDefaultDocumentProvider == null) {
            this.fDefaultDocumentProvider = new ConsoleDocumentProvider();
        }
        return this.fDefaultDocumentProvider;
    }

    public void startup() {
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        launchManager.addLaunchListener((ILaunchListener)this);
        ILaunch[] launches = launchManager.getLaunches();
        int i = 0;
        while (i < launches.length) {
            this.launchAdded(launches[i]);
            ++i;
        }
    }

    public void shutdown() {
        ILaunchManager launchManager = DebugPlugin.getDefault().getLaunchManager();
        ILaunch[] launches = launchManager.getLaunches();
        int i = 0;
        while (i < launches.length) {
            ILaunch launch = launches[i];
            this.removeLaunch(launch);
            ++i;
        }
        launchManager.removeLaunchListener((ILaunchListener)this);
    }

    protected void aboutToWriteSystemErr(IProcess process) {
        if (DebugUIPlugin.getDefault().getPreferenceStore().getBoolean("DEBUG.consoleOpenOnErr")) {
            this.showConsole(process);
        }
    }

    protected void aboutToWriteSystemOut(IProcess process) {
        if (DebugUIPlugin.getDefault().getPreferenceStore().getBoolean("DEBUG.consoleOpenOnOut")) {
            this.showConsole(process);
        }
    }

    protected void showConsole(final IProcess process) {
        final IConsole console = this.getConsole(process);
        DebugUIPlugin.getStandardDisplay().asyncExec(new Runnable(){

            public void run() {
                IWorkbenchPage page;
                IWorkbenchWindow window = DebugUIPlugin.getActiveWorkbenchWindow();
                if (window != null && (page = window.getActivePage()) != null) {
                    IViewPart consoleView = page.findView("org.eclipse.ui.console.ConsoleView");
                    if (consoleView == null) {
                        IWorkbenchPart activePart = page.getActivePart();
                        try {
                            consoleView = page.showView("org.eclipse.ui.console.ConsoleView");
                        }
                        catch (PartInitException pie) {
                            DebugUIPlugin.log(pie);
                        }
                        page.activate(activePart);
                    } else {
                        boolean bringToTop = ConsoleDocumentManager.this.shouldBringToTop(process, consoleView);
                        if (bringToTop) {
                            page.bringToTop((IWorkbenchPart)consoleView);
                        }
                    }
                    if (consoleView instanceof IConsoleView) {
                        ((IConsoleView)consoleView).display(console);
                    }
                }
            }
        });
    }

    private boolean shouldBringToTop(IProcess process, IViewPart consoleView) {
        IConsole pinnedConsole;
        IConsoleView cView;
        boolean bringToTop = true;
        if (consoleView instanceof IConsoleView && (cView = (IConsoleView)consoleView).isPinned() && (pinnedConsole = cView.getConsole()) instanceof ProcessConsole) {
            ProcessConsole pConsole = (ProcessConsole)pinnedConsole;
            bringToTop = process.equals(pConsole.getProcess());
        }
        return bringToTop;
    }

    public IConsoleColorProvider getColorProvider(String type) {
        IConfigurationElement extension;
        if (this.fColorProviders == null) {
            this.fColorProviders = new HashMap();
            IPluginDescriptor descriptor = DebugUIPlugin.getDefault().getDescriptor();
            IExtensionPoint extensionPoint = descriptor.getExtensionPoint("consoleColorProviders");
            IConfigurationElement[] elements = extensionPoint.getConfigurationElements();
            int i = 0;
            while (i < elements.length) {
                IConfigurationElement extension2 = elements[i];
                this.fColorProviders.put(extension2.getAttributeAsIs("processType"), extension2);
                ++i;
            }
        }
        if ((extension = (IConfigurationElement)this.fColorProviders.get(type)) != null) {
            try {
                Object colorProvider = extension.createExecutableExtension("class");
                if (colorProvider instanceof IConsoleColorProvider) {
                    return (IConsoleColorProvider)colorProvider;
                }
                DebugUIPlugin.logErrorMessage(MessageFormat.format(ConsoleMessages.getString("ConsoleDocumentManager.1"), extension.getDeclaringExtension().getUniqueIdentifier()));
            }
            catch (CoreException e) {
                DebugUIPlugin.log(e);
            }
        }
        return null;
    }

    public ConsoleLineNotifier newLineNotifier(String type) {
        if (this.fLineTrackers == null) {
            this.fLineTrackers = new HashMap();
            IPluginDescriptor descriptor = DebugUIPlugin.getDefault().getDescriptor();
            IExtensionPoint extensionPoint = descriptor.getExtensionPoint("consoleLineTrackers");
            IConfigurationElement[] elements = extensionPoint.getConfigurationElements();
            int i = 0;
            while (i < elements.length) {
                IConfigurationElement extension = elements[i];
                String processType = extension.getAttributeAsIs("processType");
                ArrayList<IConfigurationElement> list = (ArrayList<IConfigurationElement>)this.fLineTrackers.get(processType);
                if (list == null) {
                    list = new ArrayList<IConfigurationElement>();
                    this.fLineTrackers.put(processType, list);
                }
                list.add(extension);
                ++i;
            }
        }
        List extensions = (List)this.fLineTrackers.get(type);
        ConsoleLineNotifier lineNotifier = null;
        if (extensions != null) {
            lineNotifier = new ConsoleLineNotifier();
            Iterator iter = extensions.iterator();
            while (iter.hasNext()) {
                IConfigurationElement extension = (IConfigurationElement)iter.next();
                try {
                    Object tracker = extension.createExecutableExtension("class");
                    if (tracker instanceof IConsoleLineTracker) {
                        lineNotifier.addConsoleListener((IConsoleLineTracker)tracker);
                        continue;
                    }
                    DebugUIPlugin.logErrorMessage(MessageFormat.format(ConsoleMessages.getString("ConsoleDocumentManager.2"), extension.getDeclaringExtension().getUniqueIdentifier()));
                }
                catch (CoreException e) {
                    DebugUIPlugin.log(e);
                }
            }
        }
        return lineNotifier;
    }
}

