/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.views.breakpoints;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.ListIterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IBreakpointManager;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.DelegatingModelPresentation;
import org.eclipse.debug.internal.ui.IDebugHelpContextIds;
import org.eclipse.debug.internal.ui.actions.LinkBreakpointsWithDebugViewAction;
import org.eclipse.debug.internal.ui.actions.OpenBreakpointMarkerAction;
import org.eclipse.debug.internal.ui.actions.ShowSupportedBreakpointsAction;
import org.eclipse.debug.internal.ui.views.DebugUIViewsMessages;
import org.eclipse.debug.internal.ui.views.breakpoints.BreakpointsSorter;
import org.eclipse.debug.internal.ui.views.breakpoints.BreakpointsViewContentProvider;
import org.eclipse.debug.internal.ui.views.breakpoints.BreakpointsViewEventHandler;
import org.eclipse.debug.ui.AbstractDebugView;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IMemento;
import org.eclipse.ui.ISelectionListener;
import org.eclipse.ui.IWorkbenchPart;

public class BreakpointsView
extends AbstractDebugView
implements ISelectionListener {
    private BreakpointsViewEventHandler fEventHandler;
    private ICheckStateListener fCheckListener = new ICheckStateListener(){

        public void checkStateChanged(CheckStateChangedEvent event) {
            BreakpointsView.this.handleCheckStateChanged(event);
        }
    };
    private boolean fIsTrackingSelection = false;
    private static String KEY_IS_TRACKING_SELECTION = "isTrackingSelection";
    private static String KEY_VALUE = "value";

    public void createPartControl(Composite parent) {
        super.createPartControl(parent);
        if (this.getViewer() != null) {
            this.initializeCheckedState();
        }
    }

    protected Viewer createViewer(Composite parent) {
        CheckboxTableViewer viewer = CheckboxTableViewer.newCheckList((Composite)parent, (int)770);
        viewer.setContentProvider((IContentProvider)new BreakpointsViewContentProvider());
        viewer.setLabelProvider((IBaseLabelProvider)new DelegatingModelPresentation());
        viewer.setSorter((ViewerSorter)new BreakpointsSorter());
        viewer.setInput((Object)DebugPlugin.getDefault().getBreakpointManager());
        viewer.addCheckStateListener(this.fCheckListener);
        this.getSite().setSelectionProvider((ISelectionProvider)viewer);
        this.initIsTrackingSelection();
        this.setEventHandler(new BreakpointsViewEventHandler(this));
        return viewer;
    }

    private void initIsTrackingSelection() {
        IMemento node;
        IMemento memento = this.getMemento();
        if (memento != null && (node = memento.getChild(KEY_IS_TRACKING_SELECTION)) != null) {
            this.setTrackSelection(Boolean.valueOf(node.getString(KEY_VALUE)));
            return;
        }
        this.setTrackSelection(false);
    }

    protected void initializeCheckedState() {
        IBreakpointManager manager = DebugPlugin.getDefault().getBreakpointManager();
        CheckboxTableViewer viewer = this.getCheckboxViewer();
        Object[] elements = ((IStructuredContentProvider)viewer.getContentProvider()).getElements((Object)manager);
        ArrayList<Object> breakpoints = new ArrayList<Object>(elements.length);
        int i = 0;
        while (i < elements.length) {
            breakpoints.add(elements[i]);
            ++i;
        }
        ListIterator iterator = breakpoints.listIterator();
        while (iterator.hasNext()) {
            try {
                if (((IBreakpoint)iterator.next()).isEnabled()) continue;
                iterator.remove();
            }
            catch (CoreException e) {
                DebugUIPlugin.log(e);
            }
        }
        viewer.setCheckedElements(breakpoints.toArray());
    }

    private CheckboxTableViewer getCheckboxViewer() {
        return (CheckboxTableViewer)this.getViewer();
    }

    private void handleCheckStateChanged(CheckStateChangedEvent event) {
        Object source = event.getElement();
        if (!(source instanceof IBreakpoint)) {
            return;
        }
        IBreakpoint breakpoint = (IBreakpoint)source;
        boolean enable = event.getChecked();
        try {
            breakpoint.setEnabled(enable);
        }
        catch (CoreException e) {
            String titleState = enable ? DebugUIViewsMessages.getString("BreakpointsView.6") : DebugUIViewsMessages.getString("BreakpointsView.7");
            String messageState = enable ? DebugUIViewsMessages.getString("BreakpointsView.8") : DebugUIViewsMessages.getString("BreakpointsView.9");
            DebugUIPlugin.errorDialog(DebugUIPlugin.getShell(), MessageFormat.format(DebugUIViewsMessages.getString("BreakpointsView.10"), titleState), MessageFormat.format(DebugUIViewsMessages.getString("BreakpointsView.11"), messageState), e);
            this.getCheckboxViewer().removeCheckStateListener(this.fCheckListener);
            event.getCheckable().setChecked(source, !event.getChecked());
            this.getCheckboxViewer().addCheckStateListener(this.fCheckListener);
        }
    }

    protected String getHelpContextId() {
        return IDebugHelpContextIds.BREAKPOINT_VIEW;
    }

    public void dispose() {
        this.getCheckboxViewer().removeCheckStateListener(this.fCheckListener);
        IAction action = this.getAction("ShowBreakpointsForModel");
        if (action != null) {
            ((ShowSupportedBreakpointsAction)action).dispose();
        }
        this.getSite().getPage().removeSelectionListener("org.eclipse.debug.ui.DebugView", (ISelectionListener)this);
        super.dispose();
        if (this.getEventHandler() != null) {
            this.getEventHandler().dispose();
        }
    }

    protected void createActions() {
        OpenBreakpointMarkerAction action = new OpenBreakpointMarkerAction((ISelectionProvider)this.getViewer());
        this.setAction("GotoMarker", (IAction)action);
        this.setAction("Double_Click_ActionId", (IAction)action);
        this.setAction("ShowBreakpointsForModel", (IAction)new ShowSupportedBreakpointsAction(this.getStructuredViewer(), this));
        this.setAction("LinkWithDebugView", (IAction)new LinkBreakpointsWithDebugViewAction(this));
    }

    protected void fillContextMenu(IMenuManager menu) {
        this.updateObjects();
        menu.add((IContributionItem)new Separator("emptyNavigationGroup"));
        menu.add((IContributionItem)new Separator("navigationGroup"));
        menu.add(this.getAction("GotoMarker"));
        menu.add((IContributionItem)new Separator("emptyBreakpointGroup"));
        menu.add((IContributionItem)new Separator("breakpointGroup"));
        menu.add((IContributionItem)new Separator("emptyRenderGroup"));
        menu.add((IContributionItem)new Separator("additions"));
    }

    protected void configureToolBar(IToolBarManager tbm) {
        tbm.add((IContributionItem)new Separator("breakpointGroup"));
        tbm.add(this.getAction("ShowBreakpointsForModel"));
        tbm.add(this.getAction("GotoMarker"));
        tbm.add(this.getAction("LinkWithDebugView"));
        tbm.add((IContributionItem)new Separator("renderGroup"));
    }

    protected BreakpointsViewEventHandler getEventHandler() {
        return this.fEventHandler;
    }

    private void setEventHandler(BreakpointsViewEventHandler eventHandler) {
        this.fEventHandler = eventHandler;
    }

    protected void becomesVisible() {
        super.becomesVisible();
        this.getViewer().refresh();
        this.initializeCheckedState();
    }

    public void selectionChanged(IWorkbenchPart part, ISelection sel) {
        if (sel.isEmpty() || !this.isTrackingSelection()) {
            return;
        }
        IStructuredSelection selection = (IStructuredSelection)sel;
        Iterator iter = selection.iterator();
        Object firstElement = iter.next();
        if (firstElement == null || iter.hasNext()) {
            return;
        }
        IThread thread = null;
        if (firstElement instanceof IStackFrame) {
            thread = ((IStackFrame)firstElement).getThread();
        } else if (firstElement instanceof IThread) {
            thread = (IThread)firstElement;
        } else {
            return;
        }
        Object[] breakpoints = thread.getBreakpoints();
        this.getViewer().setSelection((ISelection)new StructuredSelection(breakpoints), true);
    }

    public boolean isTrackingSelection() {
        return this.fIsTrackingSelection;
    }

    public void setTrackSelection(boolean trackSelection) {
        this.fIsTrackingSelection = trackSelection;
        if (trackSelection) {
            this.getSite().getPage().addSelectionListener("org.eclipse.debug.ui.DebugView", (ISelectionListener)this);
        } else {
            this.getSite().getPage().removeSelectionListener("org.eclipse.debug.ui.DebugView", (ISelectionListener)this);
        }
    }

    public void saveState(IMemento memento) {
        super.saveState(memento);
        IMemento node = memento.createChild(KEY_IS_TRACKING_SELECTION);
        node.putString(KEY_VALUE, String.valueOf(this.fIsTrackingSelection));
    }
}

