/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.preferences;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class MultipleInputDialog
extends Dialog {
    protected String title;
    protected String[] fieldLabels;
    protected String[] initialValues;
    protected Map textMap = new HashMap();
    protected Map valueMap = new HashMap();
    protected List validateList = new ArrayList();

    protected void okPressed() {
        Set entries = this.textMap.entrySet();
        Iterator iter = entries.iterator();
        while (iter.hasNext()) {
            Map.Entry element = iter.next();
            this.valueMap.put(element.getKey(), ((Text)element.getValue()).getText());
        }
        this.textMap.clear();
        super.okPressed();
    }

    public MultipleInputDialog(Shell shell, String title, String[] fieldLabels, String[] initialValues) {
        super(shell);
        this.title = title;
        this.fieldLabels = fieldLabels;
        this.initialValues = initialValues;
    }

    protected Control createContents(Composite parent) {
        Control control = super.createContents(parent);
        Iterator iter = this.validateList.iterator();
        while (iter.hasNext()) {
            Text text = (Text)this.textMap.get(iter.next());
            if (text == null) continue;
            this.validateNotEmpty(text);
        }
        return control;
    }

    protected Control createDialogArea(Composite parent) {
        Composite mainComposite = (Composite)super.createDialogArea(parent);
        this.createFields(mainComposite);
        return mainComposite;
    }

    protected void createFields(Composite mainComposite) {
        Composite fieldComposite = new Composite(mainComposite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        GridData gridData = new GridData(1808);
        fieldComposite.setLayout((Layout)layout);
        fieldComposite.setLayoutData((Object)gridData);
        int i = 0;
        while (i < this.fieldLabels.length) {
            String fieldLabel = this.fieldLabels[i];
            Label label = new Label(fieldComposite, 0);
            label.setLayoutData((Object)new GridData(256));
            label.setText(fieldLabel);
            label.setFont(mainComposite.getFont());
            final Text text = new Text(fieldComposite, 2052);
            gridData = new GridData(768);
            gridData.widthHint = 200;
            text.setLayoutData((Object)gridData);
            text.setFont(mainComposite.getFont());
            if (this.initialValues != null && this.initialValues.length >= i) {
                text.setText(this.initialValues[i]);
            }
            if (this.validateList.contains(fieldLabel)) {
                text.addModifyListener(new ModifyListener(){

                    public void modifyText(ModifyEvent e) {
                        MultipleInputDialog.this.validateNotEmpty(text);
                    }
                });
            }
            this.textMap.put(fieldLabel, text);
            ++i;
        }
    }

    public void validateNotEmpty(Text text) {
        boolean enable = text.getText().trim().length() > 0;
        this.getButton(0).setEnabled(enable);
    }

    public void disallowEmpty(String fieldLabel) {
        this.validateList.add(fieldLabel);
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        if (this.title != null) {
            shell.setText(this.title);
        }
    }

    public String getValue(String fieldLabel) {
        return (String)this.valueMap.get(fieldLabel);
    }
}

