/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.preferences;

import java.text.MessageFormat;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.IDebugHelpContextIds;
import org.eclipse.debug.internal.ui.preferences.DebugPreferencesMessages;
import org.eclipse.debug.internal.ui.preferences.IDebugPreferenceConstants;
import org.eclipse.debug.ui.IDebugUIConstants;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.ColorFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.preference.RadioGroupFieldEditor;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.help.WorkbenchHelp;

public class DebugPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage,
IDebugPreferenceConstants {
    public DebugPreferencePage() {
        super(1);
        IPreferenceStore store = DebugUIPlugin.getDefault().getPreferenceStore();
        this.setPreferenceStore(store);
        this.setDescription(DebugPreferencesMessages.getString("DebugPreferencePage.General_Settings_for_Debugging_1"));
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        WorkbenchHelp.setHelp((Control)this.getControl(), (String)IDebugHelpContextIds.DEBUG_PREFERENCE_PAGE);
    }

    protected void createFieldEditors() {
        this.addField((FieldEditor)new BooleanFieldEditor(IDebugUIConstants.PREF_BUILD_BEFORE_LAUNCH, DebugPreferencesMessages.getString("DebugPreferencePage.auto_build_before_launch"), 0, this.getFieldEditorParent()));
        this.createWaitForBuildEditor();
        this.createSpacer(this.getFieldEditorParent(), 2);
        this.addField((FieldEditor)new BooleanFieldEditor(IDebugUIConstants.PREF_AUTO_REMOVE_OLD_LAUNCHES, DebugPreferencesMessages.getString("DebugPreferencePage.Remove_terminated_launches_when_a_new_launch_is_created_1"), 0, this.getFieldEditorParent()));
        this.addField((FieldEditor)new BooleanFieldEditor(IDebugUIConstants.PREF_REUSE_EDITOR, DebugPreferencesMessages.getString("DebugPreferencePage.Reuse_editor_when_displa&ying_source_code_1"), 0, this.getFieldEditorParent()));
        this.addField((FieldEditor)new BooleanFieldEditor(IDebugUIConstants.PREF_ACTIVATE_WORKBENCH, DebugPreferencesMessages.getString("DebugPreferencePage.Activate_the_&workbench_when_a_breakpoint_is_hit_1"), 0, this.getFieldEditorParent()));
        this.createSpacer(this.getFieldEditorParent(), 2);
        this.createSaveBeforeLaunchEditors();
        this.createSpacer(this.getFieldEditorParent(), 2);
        this.addField((FieldEditor)new ColorFieldEditor("Changed.Variable.RGB", DebugPreferencesMessages.getString("DebugPreferencePage.1"), this.getFieldEditorParent()));
        final IntegerFieldEditor editor = new IntegerFieldEditor(IDebugUIConstants.PREF_MAX_HISTORY_SIZE, DebugPreferencesMessages.getString("DebugPreferencePage.10"), this.getFieldEditorParent());
        int historyMax = 20;
        editor.setTextLimit(Integer.toString(historyMax).length());
        editor.setErrorMessage(MessageFormat.format(DebugPreferencesMessages.getString("DebugPreferencePage.11"), new Integer(1), new Integer(historyMax)));
        editor.setValidateStrategy(0);
        editor.setValidRange(1, historyMax);
        editor.setPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty().equals("field_editor_is_valid")) {
                    DebugPreferencePage.this.setValid(editor.isValid());
                }
            }
        });
        this.addField((FieldEditor)editor);
    }

    public void init(IWorkbench workbench) {
    }

    private void createSaveBeforeLaunchEditors() {
        this.addField((FieldEditor)new RadioGroupFieldEditor(IDebugUIConstants.PREF_SAVE_DIRTY_EDITORS_BEFORE_LAUNCH_RADIO, DebugPreferencesMessages.getString("DebugPreferencePage.Save_dirty_editors_before_launching_4"), 3, (String[][])new String[][]{{DebugPreferencesMessages.getString("DebugPreferencePage.&Never_5"), IDebugUIConstants.PREF_NEVER_SAVE_DIRTY_EDITORS_BEFORE_LAUNCH}, {DebugPreferencesMessages.getString("DebugPreferencePage.&Prompt_6"), IDebugUIConstants.PREF_PROMPT_SAVE_DIRTY_EDITORS_BEFORE_LAUNCH}, {DebugPreferencesMessages.getString("DebugPreferencePage.Auto-sav&e_7"), IDebugUIConstants.PREF_AUTOSAVE_DIRTY_EDITORS_BEFORE_LAUNCH}}, this.getFieldEditorParent(), true));
    }

    private void createWaitForBuildEditor() {
        this.addField((FieldEditor)new RadioGroupFieldEditor(IDebugUIConstants.PREF_WAIT_FOR_BUILD, DebugPreferencesMessages.getString("DebugPreferencePage.12"), 3, (String[][])new String[][]{{DebugPreferencesMessages.getString("DebugPreferencePage.13"), "never"}, {DebugPreferencesMessages.getString("DebugPreferencePage.14"), "prompt"}, {DebugPreferencesMessages.getString("DebugPreferencePage.15"), "always"}}, this.getFieldEditorParent(), true));
    }

    protected void createSpacer(Composite composite, int columnSpan) {
        Label label = new Label(composite, 0);
        GridData gd = new GridData();
        gd.horizontalSpan = columnSpan;
        label.setLayoutData((Object)gd);
    }

    public boolean performOk() {
        boolean ok = super.performOk();
        DebugUIPlugin.getDefault().savePluginPreferences();
        return ok;
    }
}

