/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.preferences;

import java.util.ArrayList;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.IDebugHelpContextIds;
import org.eclipse.debug.internal.ui.preferences.DebugActionGroupsActionContentProvider;
import org.eclipse.debug.internal.ui.preferences.DebugActionGroupsContentProvider;
import org.eclipse.debug.internal.ui.preferences.DebugActionGroupsLabelProvider;
import org.eclipse.debug.internal.ui.preferences.DebugActionGroupsManager;
import org.eclipse.debug.internal.ui.preferences.DebugPreferencesMessages;
import org.eclipse.debug.internal.ui.preferences.IDebugPreferenceConstants;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.viewers.CheckStateChangedEvent;
import org.eclipse.jface.viewers.CheckboxTableViewer;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ICheckStateListener;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.help.WorkbenchHelp;
import org.eclipse.ui.model.WorkbenchViewerSorter;

public class DebugActionGroupsPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private CheckboxTableViewer fDebugActionGroupViewer;
    private Label actionLabel;
    private TableViewer actionViewer;
    private boolean fStateChanged = false;

    public DebugActionGroupsPreferencePage() {
        this.setPreferenceStore(DebugUIPlugin.getDefault().getPreferenceStore());
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        WorkbenchHelp.setHelp((Control)this.getControl(), (String)IDebugHelpContextIds.DEBUG_ACTION_GROUPS_PREFERENCE_PAGE);
    }

    protected Control createContents(Composite parent) {
        Font font = parent.getFont();
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        layout.makeColumnsEqualWidth = true;
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        composite.setLayout((Layout)layout);
        GridData data = new GridData();
        data.verticalAlignment = 4;
        data.horizontalAlignment = 4;
        composite.setLayoutData((Object)data);
        Label descLabel = new Label(composite, 64);
        descLabel.setText(DebugPreferencesMessages.getString("DebugActionGroupsPreferencePage.Select_the_action_groups_to_be_displayed_in_Debug_views_1"));
        descLabel.setFont(font);
        data = new GridData(768);
        data.horizontalSpan = 2;
        descLabel.setLayoutData((Object)data);
        Composite actionSetGroup = new Composite(composite, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        actionSetGroup.setLayout((Layout)layout);
        data = new GridData(1808);
        actionSetGroup.setLayoutData((Object)data);
        Label selectionLabel = new Label(actionSetGroup, 0);
        selectionLabel.setText(DebugPreferencesMessages.getString("DebugActionGroupsPreferencePage.&Available_Debug_Action_Groups__2"));
        selectionLabel.setFont(font);
        Table viewActionSetTable = new Table(actionSetGroup, 67618);
        TableLayout tableLayout = new TableLayout();
        ColumnLayoutData[] columnLayoutData = new ColumnLayoutData[]{new ColumnWeightData(100)};
        tableLayout.addColumnData(columnLayoutData[0]);
        viewActionSetTable.setLayout((Layout)tableLayout);
        viewActionSetTable.setFont(font);
        new TableColumn(viewActionSetTable, 0);
        this.fDebugActionGroupViewer = new CheckboxTableViewer(viewActionSetTable);
        data = new GridData(1808);
        this.fDebugActionGroupViewer.getTable().setLayoutData((Object)data);
        this.fDebugActionGroupViewer.getTable().setFont(font);
        this.fDebugActionGroupViewer.setLabelProvider((IBaseLabelProvider)new DebugActionGroupsLabelProvider());
        DebugActionGroupsContentProvider contentProvider = new DebugActionGroupsContentProvider(this.fDebugActionGroupViewer);
        this.fDebugActionGroupViewer.setContentProvider((IContentProvider)contentProvider);
        this.fDebugActionGroupViewer.setInput((Object)DebugUIPlugin.getDefault());
        this.fDebugActionGroupViewer.setSorter((ViewerSorter)new WorkbenchViewerSorter());
        this.fDebugActionGroupViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                IStructuredSelection sel = (IStructuredSelection)event.getSelection();
                DebugActionGroupsManager.DebugActionGroup viewActionSet = null;
                if (sel.getFirstElement() instanceof DebugActionGroupsManager.DebugActionGroup) {
                    viewActionSet = (DebugActionGroupsManager.DebugActionGroup)sel.getFirstElement();
                }
                if (viewActionSet != DebugActionGroupsPreferencePage.this.actionViewer.getInput()) {
                    DebugActionGroupsPreferencePage.this.actionViewer.setInput((Object)viewActionSet);
                }
            }
        });
        this.fDebugActionGroupViewer.addCheckStateListener(new ICheckStateListener(){

            public void checkStateChanged(CheckStateChangedEvent event) {
                DebugActionGroupsManager.DebugActionGroup viewActionSet = (DebugActionGroupsManager.DebugActionGroup)event.getElement();
                viewActionSet.setVisible(event.getChecked());
                DebugActionGroupsPreferencePage.this.fStateChanged = true;
            }
        });
        Composite actionGroup = new Composite(composite, 0);
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        actionGroup.setLayout((Layout)layout);
        data = new GridData(1808);
        actionGroup.setLayoutData((Object)data);
        this.actionLabel = new Label(actionGroup, 0);
        this.actionLabel.setText(DebugPreferencesMessages.getString("DebugActionGroupsPreferencePage.Actions_in_Group__3"));
        this.actionLabel.setFont(font);
        this.actionViewer = new TableViewer(actionGroup, 2048);
        data = new GridData(1808);
        this.actionViewer.getTable().setLayoutData((Object)data);
        this.actionViewer.getTable().setFont(font);
        this.actionViewer.setLabelProvider((IBaseLabelProvider)new DebugActionGroupsLabelProvider());
        this.actionViewer.setContentProvider((IContentProvider)new DebugActionGroupsActionContentProvider());
        this.actionViewer.setSorter((ViewerSorter)new WorkbenchViewerSorter());
        Display disp = Display.getCurrent();
        Color clr = disp.getSystemColor(22);
        this.actionViewer.getTable().setBackground(clr);
        return composite;
    }

    public void init(IWorkbench workbench) {
    }

    public boolean performOk() {
        if (this.fStateChanged) {
            DebugActionGroupsManager.getDefault().updateDebugActionGroups();
            this.persistDebugActionGroups();
        }
        DebugUIPlugin.getDefault().savePluginPreferences();
        return true;
    }

    protected void persistDebugActionGroups() {
        IStructuredContentProvider contentProvider = (IStructuredContentProvider)this.fDebugActionGroupViewer.getContentProvider();
        Object[] debugActionGroups = contentProvider.getElements(null);
        ArrayList<String> enabled = new ArrayList<String>(debugActionGroups.length);
        ArrayList<String> disabled = new ArrayList<String>(debugActionGroups.length);
        int i = 0;
        while (i < debugActionGroups.length) {
            DebugActionGroupsManager.DebugActionGroup group = (DebugActionGroupsManager.DebugActionGroup)debugActionGroups[i];
            if (group.isVisible()) {
                enabled.add(group.getId());
            } else {
                disabled.add(group.getId());
            }
            ++i;
        }
        String prefEnabled = DebugActionGroupsManager.getDefault().serializeList(enabled);
        String prefDisabled = DebugActionGroupsManager.getDefault().serializeList(disabled);
        this.getPreferenceStore().setValue(IDebugPreferenceConstants.PREF_ENABLED_DEBUG_ACTION_GROUPS, prefEnabled);
        this.getPreferenceStore().setValue(IDebugPreferenceConstants.PREF_DISABLED_DEBUG_ACTION_GROUPS, prefDisabled);
    }
}

