/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.preferences;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.preferences.DebugPreferencesMessages;
import org.eclipse.debug.internal.ui.preferences.IDebugPreferenceConstants;
import org.eclipse.debug.ui.AbstractDebugView;
import org.eclipse.debug.ui.IDebugView;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IViewPart;

public class DebugActionGroupsManager
implements IMenuListener {
    public static final int TYPE_TOOLBAR = 0;
    public static final int TYPE_VIEW_MENU = 1;
    public static final int TYPE_CONTEXT_MENU = 2;
    protected List fDebugViews = new ArrayList(6);
    protected Map fDebugViewsWithMenu = new HashMap(6);
    protected Map fDebugActionGroups;
    protected Map fDebugActionGroupActionIds;
    protected Map fDebugActionGroupActions = new HashMap();
    protected static DebugActionGroupsManager fgManager;
    static /* synthetic */ Class class$0;

    private DebugActionGroupsManager() {
    }

    public static DebugActionGroupsManager getDefault() {
        if (fgManager == null) {
            fgManager = new DebugActionGroupsManager();
            fgManager.startup();
        }
        return fgManager;
    }

    public static boolean defaultExists() {
        return fgManager != null;
    }

    public void startup() {
        this.initialize();
    }

    public void shutdown() {
        Iterator iterator = this.fDebugActionGroupActions.values().iterator();
        while (iterator.hasNext()) {
            List actions = (List)iterator.next();
            Iterator itr = actions.iterator();
            while (itr.hasNext()) {
                DebugActionGroupAction action = (DebugActionGroupAction)itr.next();
                action.dispose();
            }
        }
    }

    private List persistedEnabledActionGroups() {
        String enabled = DebugUIPlugin.getDefault().getPreferenceStore().getString(IDebugPreferenceConstants.PREF_ENABLED_DEBUG_ACTION_GROUPS);
        if (enabled != null) {
            return this.parseList(enabled);
        }
        return Collections.EMPTY_LIST;
    }

    private List persistedDisabledActionGroups() {
        String enabled = DebugUIPlugin.getDefault().getPreferenceStore().getString(IDebugPreferenceConstants.PREF_DISABLED_DEBUG_ACTION_GROUPS);
        if (enabled != null) {
            return this.parseList(enabled);
        }
        return Collections.EMPTY_LIST;
    }

    private void initialize() {
        IPluginDescriptor descriptor = DebugUIPlugin.getDefault().getDescriptor();
        IExtensionPoint extensionPoint = descriptor.getExtensionPoint("debugActionGroups");
        IConfigurationElement[] infos = extensionPoint.getConfigurationElements();
        if (infos.length == 0) {
            return;
        }
        this.fDebugActionGroupActionIds = new HashMap();
        this.fDebugActionGroups = new HashMap(10);
        List userEnabledGroups = this.persistedEnabledActionGroups();
        List userDisabledGroups = this.persistedDisabledActionGroups();
        int i = 0;
        while (i < infos.length) {
            IConfigurationElement configurationElement = infos[i];
            String id = configurationElement.getAttribute("id");
            String visible = configurationElement.getAttribute("visible");
            boolean isVisible = true;
            if (visible != null) {
                isVisible = Boolean.valueOf(visible);
            }
            if (!isVisible && userEnabledGroups.contains(id)) {
                isVisible = true;
            } else if (isVisible && userDisabledGroups.contains(id)) {
                isVisible = false;
            }
            String name = configurationElement.getAttribute("name");
            if (id != null && name != null) {
                if (this.fDebugActionGroups.get(id) != null) {
                    DebugUIPlugin.logErrorMessage(MessageFormat.format(DebugPreferencesMessages.getString("DebugActionGroupsManager.Duplicate_action_group_id"), id));
                } else {
                    IConfigurationElement[] children = configurationElement.getChildren();
                    if (children.length != 0) {
                        DebugActionGroup viewActionSet = new DebugActionGroup(id, name, isVisible);
                        this.fDebugActionGroups.put(id, viewActionSet);
                        int j = 0;
                        while (j < children.length) {
                            IConfigurationElement actionElement = children[j];
                            String actionId = actionElement.getAttribute("id");
                            if (actionId != null) {
                                viewActionSet.add(actionId);
                                this.fDebugActionGroupActionIds.put(actionId, viewActionSet.getId());
                            }
                            ++j;
                        }
                    }
                }
            } else {
                String errorId = "";
                if (id != null) {
                    errorId = ": " + id;
                }
                DebugUIPlugin.logErrorMessage(String.valueOf(DebugPreferencesMessages.getString("DebugActionGroupsManager.Improperly_specified_debug_action_group_4")) + errorId);
            }
            ++i;
        }
    }

    public void updateDebugActionGroups() {
        Iterator iterator = this.fDebugViews.iterator();
        while (iterator.hasNext()) {
            IDebugView view = (IDebugView)iterator.next();
            this.updateDebugActionGroups(view);
        }
    }

    protected void updateDebugActionGroups(IViewPart viewPart) {
        IMenuManager menuManager;
        IDebugView debugView;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("[Lorg.eclipse.debug.ui.IDebugView;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        if ((debugView = (IDebugView)viewPart.getAdapter((Class)clazz)) == null) {
            return;
        }
        IActionBars actionBars = viewPart.getViewSite().getActionBars();
        IToolBarManager toolBarManager = actionBars.getToolBarManager();
        boolean refresh = false;
        if (this.processContributionItems(toolBarManager.getItems(), viewPart.getTitle(), viewPart.getSite().getId(), 0)) {
            toolBarManager.markDirty();
            refresh = true;
        }
        if (this.processContributionItems((menuManager = actionBars.getMenuManager()).getItems(), viewPart.getTitle(), viewPart.getSite().getId(), 1)) {
            menuManager.markDirty();
            refresh = true;
        }
        if (refresh) {
            actionBars.updateActionBars();
        }
    }

    protected boolean processContributionItems(IContributionItem[] items, String viewName, String viewId, int type) {
        boolean visibilityChanged = false;
        int i = 0;
        while (i < items.length) {
            DebugActionGroup actionSet;
            String viewActionSetId;
            ActionContributionItem item;
            String id;
            IContributionItem iContributionItem = items[i];
            if (iContributionItem instanceof ActionContributionItem && (id = (item = (ActionContributionItem)iContributionItem).getId()) != null && (viewActionSetId = (String)this.fDebugActionGroupActionIds.get(id)) != null && (actionSet = (DebugActionGroup)this.fDebugActionGroups.get(viewActionSetId)) != null) {
                iContributionItem.setVisible(actionSet.isVisible());
                visibilityChanged = true;
                DebugActionGroupAction action = new DebugActionGroupAction(id, item.getAction().getText(), viewName, viewId, item.getAction().getImageDescriptor(), type);
                ArrayList<DebugActionGroupAction> actions = (ArrayList<DebugActionGroupAction>)this.fDebugActionGroupActions.get(id);
                if (actions == null) {
                    actions = new ArrayList<DebugActionGroupAction>(1);
                    actions.add(action);
                    this.fDebugActionGroupActions.put(id, actions);
                } else if (!actions.contains(action)) {
                    actions.add(action);
                }
            }
            ++i;
        }
        return visibilityChanged;
    }

    public void registerView(final IDebugView view) {
        if (this.fDebugActionGroupActionIds == null || this.fDebugViews.contains(view)) {
            return;
        }
        ArrayList<IMenuManager> menus = null;
        if (view instanceof AbstractDebugView) {
            menus = ((AbstractDebugView)view).getContextMenuManagers();
        }
        if (menus == null) {
            menus = new ArrayList<IMenuManager>(1);
            menus.add(view.getContextMenuManager());
        }
        Iterator itr = menus.iterator();
        while (itr.hasNext()) {
            IMenuManager menu = (IMenuManager)itr.next();
            if (menu == null) continue;
            menu.addMenuListener((IMenuListener)this);
        }
        final ArrayList<IMenuManager> contextMenus = menus;
        final Display display = view.getSite().getPage().getWorkbenchWindow().getShell().getDisplay();
        if (display != null && !display.isDisposed()) {
            display.asyncExec(new Runnable(){

                public void run() {
                    if (!display.isDisposed()) {
                        DebugActionGroupsManager.this.updateDebugActionGroups(view);
                        DebugActionGroupsManager.this.fDebugViews.add(view);
                        Iterator iter = contextMenus.iterator();
                        while (iter.hasNext()) {
                            IMenuManager menu = (IMenuManager)iter.next();
                            if (menu == null) continue;
                            DebugActionGroupsManager.this.fDebugViewsWithMenu.put(menu, view);
                            Menu swtMenu = ((MenuManager)menu).getMenu();
                            if (swtMenu.isDisposed()) continue;
                            swtMenu.notifyListeners(22, new Event());
                            swtMenu.notifyListeners(23, new Event());
                        }
                    }
                }
            });
        }
    }

    public void deregisterView(IDebugView view) {
        if (this.fDebugActionGroupActionIds != null && this.fDebugViews.remove(view)) {
            ArrayList<IMenuManager> managers = null;
            if (view instanceof AbstractDebugView) {
                managers = ((AbstractDebugView)view).getContextMenuManagers();
            }
            if (managers == null) {
                managers = new ArrayList<IMenuManager>(1);
                managers.add(view.getContextMenuManager());
            }
            Iterator mitr = managers.iterator();
            while (mitr.hasNext()) {
                IMenuManager manager = (IMenuManager)mitr.next();
                if (manager == null) continue;
                manager.removeMenuListener((IMenuListener)this);
                this.fDebugViewsWithMenu.remove(manager);
            }
            Collection actionCollections = this.fDebugActionGroupActions.values();
            ArrayList<String> removed = new ArrayList<String>();
            Iterator<Object> iterator = actionCollections.iterator();
            while (iterator.hasNext()) {
                List actions = (List)iterator.next();
                Iterator itr = actions.iterator();
                while (itr.hasNext()) {
                    DebugActionGroupAction action = (DebugActionGroupAction)itr.next();
                    if (!action.getViewId().equals(view.getSite().getId())) continue;
                    removed.add(action.getId());
                    action.dispose();
                }
            }
            iterator = removed.iterator();
            while (iterator.hasNext()) {
                String actionId = (String)iterator.next();
                this.fDebugActionGroupActions.remove(actionId);
            }
        }
    }

    public void menuAboutToShow(IMenuManager manager) {
        IDebugView view = (IDebugView)this.fDebugViewsWithMenu.get(manager);
        if (view != null) {
            String viewName = view.getTitle();
            String viewId = view.getSite().getId();
            this.processContributionItems(manager.getItems(), viewName, viewId, 2);
        }
    }

    protected List parseList(String listString) {
        ArrayList<String> list = new ArrayList<String>(10);
        StringTokenizer tokenizer = new StringTokenizer(listString, ",");
        while (tokenizer.hasMoreTokens()) {
            String token = tokenizer.nextToken();
            list.add(token);
        }
        return list;
    }

    protected String serializeList(List list) {
        if (list == null) {
            return "";
        }
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            String element = (String)iterator.next();
            if (i > 0) {
                buffer.append(',');
            }
            buffer.append(element);
            ++i;
        }
        return buffer.toString();
    }

    protected class DebugActionGroup {
        private String fId;
        private boolean fVisible;
        private String fName;
        private List fActionIds = new ArrayList();

        protected DebugActionGroup(String id, String name, boolean visible) {
            this.fId = id;
            this.fVisible = visible;
            this.fName = name;
        }

        public int hashCode() {
            return this.fId.hashCode();
        }

        public boolean equals(Object obj) {
            if (obj instanceof DebugActionGroup) {
                DebugActionGroup s = (DebugActionGroup)obj;
                return this.fId == s.fId;
            }
            return false;
        }

        protected void add(String actionId) {
            this.fActionIds.add(actionId);
        }

        protected String getName() {
            return this.fName;
        }

        protected boolean isVisible() {
            return this.fVisible;
        }

        protected void setVisible(boolean visible) {
            this.fVisible = visible;
        }

        protected List getActionIds() {
            return this.fActionIds;
        }

        protected String getId() {
            return this.fId;
        }
    }

    protected class DebugActionGroupAction {
        private String fId;
        private String fName;
        private String fViewName;
        private String fViewId;
        private ImageDescriptor fImageDescriptor;
        private Image fImage;
        private int fType;

        protected DebugActionGroupAction(String id, String name, String viewName, String viewId, ImageDescriptor imageDescriptor, int type) {
            this.fType = type;
            this.fId = id;
            this.fName = this.cleanName(name);
            this.fImageDescriptor = imageDescriptor;
            this.fViewName = viewName;
            this.fViewId = viewId;
        }

        public int hashCode() {
            return this.fId.hashCode() | this.fViewId.hashCode() | this.fType;
        }

        public boolean equals(Object obj) {
            if (obj instanceof DebugActionGroupAction) {
                DebugActionGroupAction s = (DebugActionGroupAction)obj;
                return this.getId() == s.getId() && this.getViewId() == s.getViewId() && this.fType == s.fType;
            }
            return false;
        }

        protected String getName() {
            StringBuffer buff = new StringBuffer(this.fName);
            buff.append(" (");
            buff.append(this.fViewName);
            buff.append(DebugPreferencesMessages.getString("DebugActionGroupsManager._view__6"));
            buff.append(this.getDescriptor());
            buff.append(')');
            return buff.toString();
        }

        protected Image getImage() {
            if (this.fImage == null && this.fImageDescriptor != null) {
                this.fImage = this.fImageDescriptor.createImage(true);
            }
            return this.fImage;
        }

        protected void dispose() {
            if (this.fImage != null) {
                this.fImage.dispose();
            }
        }

        protected String getDescriptor() {
            switch (this.fType) {
                case 0: {
                    return DebugPreferencesMessages.getString("DebugActionGroupsManager.toolbar_7");
                }
                case 2: {
                    return DebugPreferencesMessages.getString("DebugActionGroupsManager.context_menu_8");
                }
                case 1: {
                    return DebugPreferencesMessages.getString("DebugActionGroupsManager.pull-down_menu_1");
                }
            }
            return "";
        }

        protected String cleanName(String name) {
            int i = name.indexOf(64);
            if (i >= 0) {
                name = name.substring(0, i);
            }
            if ((i = name.indexOf(38)) >= 0) {
                name = String.valueOf(name.substring(0, i)) + name.substring(i + 1);
            }
            return name;
        }

        protected String getId() {
            return this.fId;
        }

        protected String getViewId() {
            return this.fViewId;
        }
    }
}

