/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.preferences;

import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.IDebugHelpContextIds;
import org.eclipse.debug.internal.ui.preferences.BooleanFieldEditor2;
import org.eclipse.debug.internal.ui.preferences.DebugPreferencesMessages;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.ColorFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.help.WorkbenchHelp;

public class ConsolePreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private BooleanFieldEditor2 fWrapEditor = null;
    private ConsoleIntegerFieldEditor fWidthEditor = null;
    private BooleanFieldEditor2 fUseBufferSize = null;
    private ConsoleIntegerFieldEditor fBufferSizeEditor = null;
    private ConsoleIntegerFieldEditor fTabSizeEditor = null;

    public ConsolePreferencePage() {
        super(1);
        this.setDescription(DebugPreferencesMessages.getString("ConsolePreferencePage.Console_settings"));
        this.setPreferenceStore(DebugUIPlugin.getDefault().getPreferenceStore());
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        WorkbenchHelp.setHelp((Control)this.getControl(), (String)IDebugHelpContextIds.CONSOLE_PREFERENCE_PAGE);
    }

    public void createFieldEditors() {
        this.fWrapEditor = new BooleanFieldEditor2("Console.wrap", DebugPreferencesMessages.getString("ConsolePreferencePage.Wrap_text_1"), 0, this.getFieldEditorParent());
        this.addField((FieldEditor)this.fWrapEditor);
        this.fWidthEditor = new ConsoleIntegerFieldEditor("Console.width", DebugPreferencesMessages.getString("ConsolePreferencePage.Console_width"), this.getFieldEditorParent());
        this.addField((FieldEditor)this.fWidthEditor);
        this.fWidthEditor.setValidRange(80, 0x7FFFFFFE);
        this.fWidthEditor.setErrorMessage(DebugPreferencesMessages.getString("ConsolePreferencePage.console_width"));
        this.fWrapEditor.getChangeControl(this.getFieldEditorParent()).addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConsolePreferencePage.this.updateWidthEditor();
            }
        });
        this.fUseBufferSize = new BooleanFieldEditor2("Console.limitConsoleOutput", DebugPreferencesMessages.getString("ConsolePreferencePage.Limit_console_output_1"), 0, this.getFieldEditorParent());
        this.addField((FieldEditor)this.fUseBufferSize);
        this.fBufferSizeEditor = new ConsoleIntegerFieldEditor("Console.lowWaterMark", DebugPreferencesMessages.getString("ConsolePreferencePage.Console_buffer_size_(characters)__2"), this.getFieldEditorParent());
        this.addField((FieldEditor)this.fBufferSizeEditor);
        this.fBufferSizeEditor.setValidRange(1000, Integer.MAX_VALUE);
        this.fBufferSizeEditor.setErrorMessage(DebugPreferencesMessages.getString("ConsolePreferencePage.The_console_buffer_size_must_be_at_least_1000_characters._1"));
        this.fUseBufferSize.getChangeControl(this.getFieldEditorParent()).addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ConsolePreferencePage.this.updateBufferSizeEditor();
            }
        });
        this.fTabSizeEditor = new ConsoleIntegerFieldEditor("Console.console_tab_width", DebugPreferencesMessages.getString("ConsolePreferencePage.12"), this.getFieldEditorParent());
        this.addField((FieldEditor)this.fTabSizeEditor);
        this.fTabSizeEditor.setValidRange(1, 100);
        this.fTabSizeEditor.setErrorMessage(DebugPreferencesMessages.getString("ConsolePreferencePage.13"));
        this.addField((FieldEditor)new BooleanFieldEditor("DEBUG.consoleOpenOnOut", DebugPreferencesMessages.getString("ConsolePreferencePage.Show_&Console_View_when_there_is_program_output_3"), 0, this.getFieldEditorParent()));
        this.addField((FieldEditor)new BooleanFieldEditor("DEBUG.consoleOpenOnErr", DebugPreferencesMessages.getString("ConsolePreferencePage.Show_&Console_View_when_there_is_program_error_3"), 0, this.getFieldEditorParent()));
        ColorFieldEditor sysout = new ColorFieldEditor("Console.stdOutColor", DebugPreferencesMessages.getString("ConsolePreferencePage.Standard_Out__2"), this.getFieldEditorParent());
        ColorFieldEditor syserr = new ColorFieldEditor("Console.stdErrColor", DebugPreferencesMessages.getString("ConsolePreferencePage.Standard_Error__3"), this.getFieldEditorParent());
        ColorFieldEditor sysin = new ColorFieldEditor("Console.stdInColor", DebugPreferencesMessages.getString("ConsolePreferencePage.Standard_In__4"), this.getFieldEditorParent());
        this.addField((FieldEditor)sysout);
        this.addField((FieldEditor)syserr);
        this.addField((FieldEditor)sysin);
    }

    public void init(IWorkbench workbench) {
    }

    public boolean performOk() {
        boolean ok = super.performOk();
        IPreferenceStore store = DebugUIPlugin.getDefault().getPreferenceStore();
        int low = store.getInt("Console.lowWaterMark");
        int high = low + 8000;
        store.setValue("Console.highWaterMark", high);
        DebugUIPlugin.getDefault().savePluginPreferences();
        return ok;
    }

    protected void initialize() {
        super.initialize();
        this.updateWidthEditor();
        this.updateBufferSizeEditor();
    }

    protected void updateWidthEditor() {
        Button b = this.fWrapEditor.getChangeControl(this.getFieldEditorParent());
        this.fWidthEditor.getTextControl(this.getFieldEditorParent()).setEnabled(b.getSelection());
        this.fWidthEditor.getLabelControl(this.getFieldEditorParent()).setEnabled(b.getSelection());
    }

    protected void updateBufferSizeEditor() {
        Button b = this.fUseBufferSize.getChangeControl(this.getFieldEditorParent());
        this.fBufferSizeEditor.getTextControl(this.getFieldEditorParent()).setEnabled(b.getSelection());
        this.fBufferSizeEditor.getLabelControl(this.getFieldEditorParent()).setEnabled(b.getSelection());
    }

    protected void performDefaults() {
        super.performDefaults();
        this.updateWidthEditor();
    }

    protected boolean canClearErrorMessage() {
        return this.fWidthEditor.isValid() && this.fBufferSizeEditor.isValid();
    }

    public void propertyChange(PropertyChangeEvent event) {
        if (event.getProperty().equals("field_editor_is_valid")) {
            boolean newValue = (Boolean)event.getNewValue();
            if (newValue) {
                if (this.fWidthEditor != null && event.getSource() != this.fWidthEditor) {
                    this.fWidthEditor.refreshValidState();
                }
                if (this.fBufferSizeEditor != null && event.getSource() != this.fBufferSizeEditor) {
                    this.fBufferSizeEditor.refreshValidState();
                }
                this.checkState();
            } else {
                super.propertyChange(event);
            }
        } else {
            super.propertyChange(event);
        }
    }

    protected class ConsoleIntegerFieldEditor
    extends IntegerFieldEditor {
        public ConsoleIntegerFieldEditor(String name, String labelText, Composite parent) {
            super(name, labelText, parent);
        }

        protected void refreshValidState() {
            super.refreshValidState();
        }

        protected void clearErrorMessage() {
            if (ConsolePreferencePage.this.canClearErrorMessage()) {
                super.clearErrorMessage();
            }
        }
    }
}

