/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.launchConfigurations;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationListener;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.internal.ui.DebugPluginImages;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.IDebugHelpContextIds;
import org.eclipse.debug.internal.ui.PixelConverter;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationsMessages;
import org.eclipse.debug.ui.AbstractLaunchConfigurationTab;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveRegistry;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.help.WorkbenchHelp;

public class PerspectivesTab
extends AbstractLaunchConfigurationTab
implements ILaunchConfigurationListener {
    private ILaunchConfigurationType fType = null;
    private String[] fModeIds = null;
    private String[] fPerspectiveLabels = null;
    private Map fPerspectiveIds = null;
    private Combo[] fCombos = null;
    private boolean fInitializing = false;

    public void dispose() {
        super.dispose();
        DebugPlugin.getDefault().getLaunchManager().removeLaunchConfigurationListener((ILaunchConfigurationListener)this);
    }

    public void launchConfigurationAdded(ILaunchConfiguration configuration) {
    }

    public void launchConfigurationChanged(ILaunchConfiguration configuration) {
        if (!configuration.isWorkingCopy() && configuration.getName().startsWith(this.getLaunchConfigurationType().getIdentifier())) {
            int i = 0;
            while (i < this.fModeIds.length) {
                String mode = this.fModeIds[i];
                try {
                    String persp = configuration.getAttribute(mode, null);
                    if (persp == null) {
                        persp = "perspective_default";
                    }
                    DebugUITools.setLaunchPerspective(this.getLaunchConfigurationType(), mode, persp);
                }
                catch (CoreException e) {
                    DebugUIPlugin.log(e);
                }
                ++i;
            }
        }
    }

    public void launchConfigurationRemoved(ILaunchConfiguration configuration) {
    }

    public PerspectivesTab(ILaunchConfigurationType type) {
        this.fType = type;
        DebugPlugin.getDefault().getLaunchManager().addLaunchConfigurationListener((ILaunchConfigurationListener)this);
    }

    public Image getImage() {
        return DebugPluginImages.getImage("IMG_OBJS_PERSPECTIVE_TAB");
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        this.setControl((Control)composite);
        WorkbenchHelp.setHelp((Control)this.getControl(), (String)IDebugHelpContextIds.LAUNCH_CONFIGURATION_DIALOG_PERSPECTIVE_TAB);
        GridLayout layout = new GridLayout(2, false);
        composite.setLayout((Layout)layout);
        GridData gd = new GridData(1808);
        composite.setLayoutData((Object)gd);
        composite.setFont(parent.getFont());
        Label label = new Label(composite, 16448);
        label.setFont(parent.getFont());
        label.setText(MessageFormat.format(LaunchConfigurationsMessages.getString("PerspectivesTab.0"), this.getLaunchConfigurationType().getName()));
        gd = new GridData();
        PixelConverter converter = new PixelConverter((Control)label);
        gd.widthHint = converter.convertWidthInCharsToPixels(80);
        gd.horizontalSpan = 2;
        label.setLayoutData((Object)gd);
        String[] modes = DebugPlugin.getDefault().getLaunchManager().getLaunchModes();
        ArrayList<String> supported = new ArrayList<String>();
        int i = 0;
        while (i < modes.length) {
            String string = modes[i];
            if (this.getLaunchConfigurationType().supportsMode(string)) {
                supported.add(string);
            }
            ++i;
        }
        this.fModeIds = supported.toArray(new String[supported.size()]);
        final IPerspectiveRegistry registry = PlatformUI.getWorkbench().getPerspectiveRegistry();
        IPerspectiveDescriptor[] descriptors = registry.getPerspectives();
        this.fPerspectiveLabels = new String[descriptors.length + 1];
        this.fPerspectiveLabels[0] = LaunchConfigurationsMessages.getString("PerspectivesTab.1");
        this.fPerspectiveIds = new HashMap(descriptors.length);
        int i2 = 0;
        while (i2 < descriptors.length) {
            IPerspectiveDescriptor descriptor = descriptors[i2];
            this.fPerspectiveLabels[i2 + 1] = descriptor.getLabel();
            this.fPerspectiveIds.put(descriptor.getLabel(), descriptor.getId());
            ++i2;
        }
        this.createVerticalSpacer(composite, 2);
        this.fCombos = new Combo[this.fModeIds.length];
        i2 = 0;
        while (i2 < this.fModeIds.length) {
            label = new Label(composite, 0);
            label.setFont(composite.getFont());
            gd = new GridData(1);
            gd.horizontalSpan = 1;
            label.setLayoutData((Object)gd);
            String text = DebugPlugin.getDefault().getLaunchManager().getLaunchModeLabel(this.fModeIds[i2]);
            label.setText(MessageFormat.format(LaunchConfigurationsMessages.getString("PerspectivesTab.2"), text));
            Combo combo = new Combo(composite, 8);
            combo.setFont(composite.getFont());
            combo.setItems(this.fPerspectiveLabels);
            combo.setData((Object)this.fModeIds[i2]);
            gd = new GridData(1);
            combo.setLayoutData((Object)gd);
            this.fCombos[i2] = combo;
            combo.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    PerspectivesTab.this.updateLaunchConfigurationDialog();
                }
            });
            ++i2;
        }
        this.createVerticalSpacer(composite, 2);
        Button restoreDefaults = this.createPushButton(composite, LaunchConfigurationsMessages.getString("PerspectivesTab.3"), null);
        restoreDefaults.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                int i = 0;
                while (i < PerspectivesTab.this.fCombos.length) {
                    String mode = (String)PerspectivesTab.this.fCombos[i].getData();
                    String def = DebugUIPlugin.getDefault().getPerspectiveManager().getDefaultLaunchPerspective(PerspectivesTab.this.getLaunchConfigurationType(), mode);
                    if (def == null) {
                        PerspectivesTab.this.fCombos[i].setText(LaunchConfigurationsMessages.getString("PerspectivesTab.1"));
                    } else {
                        IPerspectiveDescriptor descriptor = registry.findPerspectiveWithId(def);
                        PerspectivesTab.this.fCombos[i].setText(descriptor.getLabel());
                    }
                    ++i;
                }
                PerspectivesTab.this.updateLaunchConfigurationDialog();
            }
        });
    }

    public void setDefaults(ILaunchConfigurationWorkingCopy configuration) {
        int i = 0;
        while (i < this.fModeIds.length) {
            String mode = this.fModeIds[i];
            configuration.setAttribute(mode, null);
            ++i;
        }
    }

    public void initializeFrom(ILaunchConfiguration configuration) {
        this.fInitializing = true;
        IPerspectiveRegistry registry = PlatformUI.getWorkbench().getPerspectiveRegistry();
        int i = 0;
        while (i < this.fModeIds.length) {
            String mode = this.fModeIds[i];
            try {
                String persp = configuration.getAttribute(mode, null);
                if (persp == null) {
                    persp = DebugUITools.getLaunchPerspective(this.getLaunchConfigurationType(), mode);
                }
                if ("perspective_none".equals(persp)) {
                    persp = null;
                }
                IPerspectiveDescriptor descriptor = null;
                if (persp != null) {
                    descriptor = registry.findPerspectiveWithId(persp);
                }
                if (descriptor == null) {
                    this.fCombos[i].setText(LaunchConfigurationsMessages.getString("PerspectivesTab.1"));
                } else {
                    this.fCombos[i].setText(descriptor.getLabel());
                }
            }
            catch (CoreException e) {
                DebugUIPlugin.log(e);
            }
            ++i;
        }
        this.fInitializing = false;
    }

    public void performApply(ILaunchConfigurationWorkingCopy configuration) {
        int i = 0;
        while (i < this.fCombos.length) {
            this.updateConfigFromCombo(this.fCombos[i], configuration);
            ++i;
        }
    }

    protected void updateConfigFromCombo(Combo combo, ILaunchConfigurationWorkingCopy workingCopy) {
        if (!this.fInitializing) {
            String mode = (String)combo.getData();
            String persp = combo.getText();
            persp = persp.equals(LaunchConfigurationsMessages.getString("PerspectivesTab.1")) ? "perspective_none" : (String)this.fPerspectiveIds.get(persp);
            String def = DebugUIPlugin.getDefault().getPerspectiveManager().getDefaultLaunchPerspective(this.getLaunchConfigurationType(), mode);
            if (def == null) {
                def = "perspective_none";
            }
            if (persp.equals(def)) {
                persp = null;
            }
            workingCopy.setAttribute(mode, persp);
        }
    }

    public String getName() {
        return LaunchConfigurationsMessages.getString("PerspectivesTab.7");
    }

    protected ILaunchConfigurationType getLaunchConfigurationType() {
        return this.fType;
    }

    public void activated(ILaunchConfigurationWorkingCopy workingCopy) {
    }

    public void deactivated(ILaunchConfigurationWorkingCopy workingCopy) {
    }
}

