/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.launchConfigurations;

import java.io.IOException;
import java.io.StringReader;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.DebugEvent;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.IDebugEventSetListener;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.ILaunchListener;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.IInternalDebugUIConstants;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationManager;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationPresentationManager;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationTabGroupExtension;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationsMessages;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugUIConstants;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.WorkbenchException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class PerspectiveManager
implements ILaunchListener,
IDebugEventSetListener {
    private Map fPreferenceMap;
    private static final String ELEMENT_PERSPECTIVES = "launchPerspectives";
    private static final String ELEMENT_PERSPECTIVE = "launchPerspective";
    private static final String ATTR_TYPE_ID = "configurationType";
    private static final String ATTR_MODE_ID = "mode";
    private static final String ATTR_PERSPECTIVE_ID = "perspective";

    public void startup() {
        DebugPlugin plugin = DebugPlugin.getDefault();
        plugin.getLaunchManager().addLaunchListener((ILaunchListener)this);
        plugin.addDebugEventListener((IDebugEventSetListener)this);
    }

    public void shutdown() {
        DebugPlugin plugin = DebugPlugin.getDefault();
        plugin.getLaunchManager().removeLaunchListener((ILaunchListener)this);
        plugin.removeDebugEventListener((IDebugEventSetListener)this);
    }

    public void launchRemoved(ILaunch launch) {
    }

    public void launchChanged(ILaunch launch) {
    }

    public void launchAdded(ILaunch launch) {
        String perspectiveId = null;
        try {
            perspectiveId = this.getPerspectiveId(launch);
        }
        catch (CoreException e) {
            String name = DebugUIPlugin.getModelPresentation().getText(launch);
            this.switchFailed(e, name);
        }
        ILaunchConfiguration configuration = launch.getLaunchConfiguration();
        if (configuration != null && !LaunchConfigurationManager.isVisible(configuration)) {
            perspectiveId = null;
        }
        if (perspectiveId != null) {
            this.switchToPerspective(perspectiveId);
        }
    }

    protected void switchToPerspective(final String id) {
        this.async(new Runnable(){

            public void run() {
                IWorkbenchWindow window = DebugUIPlugin.getActiveWorkbenchWindow();
                if (window != null) {
                    try {
                        window.getWorkbench().showPerspective(id, window);
                    }
                    catch (WorkbenchException e) {
                        DebugUIPlugin.errorDialog(DebugUIPlugin.getShell(), LaunchConfigurationsMessages.getString("PerspectiveManager.Error_1"), MessageFormat.format(LaunchConfigurationsMessages.getString("PerspectiveManager.Unable_to_switch_to_perspective__{0}_2"), id), e);
                    }
                }
            }
        });
    }

    protected void async(Runnable r) {
        Display d = DebugUIPlugin.getStandardDisplay();
        if (d != null && !d.isDisposed()) {
            d.asyncExec(r);
        }
    }

    protected void sync(Runnable r) {
        Display d = DebugUIPlugin.getStandardDisplay();
        if (d != null && !d.isDisposed()) {
            d.syncExec(r);
        }
    }

    protected void switchFailed(final Throwable t, final String launchName) {
        this.sync(new Runnable(){

            public void run() {
                DebugUIPlugin.errorDialog(DebugUIPlugin.getShell(), LaunchConfigurationsMessages.getString("PerspectiveManager.Error_1"), MessageFormat.format(LaunchConfigurationsMessages.getString("PerspectiveManager.Unable_to_switch_perpsectives_as_specified_by_launch__{0}_4"), launchName), t);
            }
        });
    }

    public void handleDebugEvents(DebugEvent[] events) {
        int i = 0;
        while (i < events.length) {
            DebugEvent event = events[i];
            if (event.getKind() == 2 && (event.getDetail() == 16 || event.getDetail() == 8)) {
                ILaunch launch = null;
                Object source = event.getSource();
                if (source instanceof IDebugElement) {
                    launch = ((IDebugElement)source).getLaunch();
                } else if (source instanceof IProcess) {
                    launch = ((IProcess)source).getLaunch();
                }
                String perspectiveId = null;
                try {
                    perspectiveId = this.getPerspectiveId(launch);
                }
                catch (CoreException e) {
                    DebugUIPlugin.log(e);
                }
                final String id = perspectiveId;
                Runnable r = new Runnable(){

                    public void run() {
                        IViewPart part;
                        IWorkbenchPage page;
                        String targetId = id;
                        IWorkbenchWindow window = DebugUIPlugin.getActiveWorkbenchWindow();
                        if (window == null) {
                            return;
                        }
                        if (targetId == null && (page = window.getActivePage()) != null && (part = page.findView("org.eclipse.debug.ui.DebugView")) == null) {
                            targetId = IDebugUIConstants.ID_DEBUG_PERSPECTIVE;
                        }
                        if (targetId != null) {
                            Shell shell = window.getShell();
                            if (shell != null) {
                                if (shell.getMinimized()) {
                                    shell.setMinimized(false);
                                }
                                if (DebugUIPlugin.getDefault().getPreferenceStore().getBoolean(IDebugUIConstants.PREF_ACTIVATE_WORKBENCH)) {
                                    shell.forceActive();
                                }
                            }
                            PerspectiveManager.this.switchToPerspective(targetId);
                        }
                    }
                };
                this.async(r);
            }
            ++i;
        }
    }

    protected String getPerspectiveId(ILaunch launch) throws CoreException {
        if (launch == null) {
            return null;
        }
        ILaunchConfiguration config = launch.getLaunchConfiguration();
        if (config == null) {
            return null;
        }
        String perspectiveId = null;
        perspectiveId = DebugUITools.getLaunchPerspective(config.getType(), launch.getLaunchMode());
        if (perspectiveId != null && perspectiveId.equals("perspective_none")) {
            perspectiveId = null;
        }
        return perspectiveId;
    }

    public String getLaunchPerspective(ILaunchConfigurationType type, String mode) {
        String id = this.getUserSpecifiedLaunchPerspective(type, mode);
        if (id == null) {
            id = this.getDefaultLaunchPerspective(type, mode);
        } else if (id.equals("perspective_none")) {
            id = null;
        }
        return id;
    }

    public void setLaunchPerspective(ILaunchConfigurationType type, String mode, String perspective) {
        this.internalSetLaunchPerspective(type.getIdentifier(), mode, perspective);
        try {
            String xml = this.generatePerspectiveXML();
            DebugUIPlugin.getDefault().getPreferenceStore().putValue(IInternalDebugUIConstants.PREF_LAUNCH_PERSPECTIVES, xml);
            DebugUIPlugin.getDefault().savePluginPreferences();
        }
        catch (IOException e) {
            DebugUIPlugin.log(DebugUIPlugin.newErrorStatus(LaunchConfigurationsMessages.getString("PerspectiveManager.9"), e));
        }
        catch (ParserConfigurationException e) {
            DebugUIPlugin.log(DebugUIPlugin.newErrorStatus(LaunchConfigurationsMessages.getString("PerspectiveManager.9"), e));
        }
        catch (TransformerException e) {
            DebugUIPlugin.log(DebugUIPlugin.newErrorStatus(LaunchConfigurationsMessages.getString("PerspectiveManager.9"), e));
        }
    }

    private void internalSetLaunchPerspective(String type, String mode, String perspective) {
        HashMap<String, String> modeMap;
        if (this.fPreferenceMap == null) {
            this.initPerspectives();
        }
        if ((modeMap = (HashMap<String, String>)this.fPreferenceMap.get(type)) == null) {
            modeMap = new HashMap<String, String>();
            this.fPreferenceMap.put(type, modeMap);
        }
        if (perspective.equals("perspective_default")) {
            modeMap.remove(mode);
        } else {
            modeMap.put(mode, perspective);
        }
    }

    private String generatePerspectiveXML() throws ParserConfigurationException, TransformerException, IOException {
        Document doc = DebugUIPlugin.getDocument();
        Element configRootElement = doc.createElement(ELEMENT_PERSPECTIVES);
        doc.appendChild(configRootElement);
        Iterator configTypes = this.fPreferenceMap.keySet().iterator();
        while (configTypes.hasNext()) {
            String type = (String)configTypes.next();
            Map modeMap = (Map)this.fPreferenceMap.get(type);
            if (modeMap == null || modeMap.isEmpty()) continue;
            Iterator modes = modeMap.keySet().iterator();
            while (modes.hasNext()) {
                String mode = (String)modes.next();
                String perspective = (String)modeMap.get(mode);
                Element element = doc.createElement(ELEMENT_PERSPECTIVE);
                element.setAttribute(ATTR_TYPE_ID, type);
                element.setAttribute(ATTR_MODE_ID, mode);
                element.setAttribute(ATTR_PERSPECTIVE_ID, perspective);
                configRootElement.appendChild(element);
            }
        }
        return DebugUIPlugin.serializeDocument(doc);
    }

    protected String getDefaultLaunchPerspective(ILaunchConfigurationType type, String mode) {
        LaunchConfigurationTabGroupExtension extension = LaunchConfigurationPresentationManager.getDefault().getExtension(type.getIdentifier(), mode);
        if (extension != null) {
            String id = extension.getPerspective(mode);
            if (id == null) {
                if (mode.equals("debug")) {
                    return IDebugUIConstants.ID_DEBUG_PERSPECTIVE;
                }
            } else {
                return id;
            }
        }
        return null;
    }

    protected String getUserSpecifiedLaunchPerspective(ILaunchConfigurationType type, String mode) {
        Map modeMap;
        String id = null;
        if (this.fPreferenceMap == null) {
            this.initPerspectives();
        }
        if ((modeMap = (Map)this.fPreferenceMap.get(type.getIdentifier())) != null) {
            id = (String)modeMap.get(mode);
        }
        return id;
    }

    private void initPerspectives() {
        this.fPreferenceMap = new HashMap();
        String xml = DebugUIPlugin.getDefault().getPreferenceStore().getString(IInternalDebugUIConstants.PREF_LAUNCH_PERSPECTIVES);
        if (xml != null && xml.length() > 0) {
            try {
                Element root = null;
                DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                StringReader reader = new StringReader(xml);
                InputSource source = new InputSource(reader);
                root = parser.parse(source).getDocumentElement();
                NodeList list = root.getChildNodes();
                int length = list.getLength();
                int i = 0;
                while (i < length) {
                    Element element;
                    String nodeName;
                    Node node = list.item(i);
                    short nt = node.getNodeType();
                    if (nt == 1 && (nodeName = (element = (Element)node).getNodeName()).equalsIgnoreCase(ELEMENT_PERSPECTIVE)) {
                        String type = element.getAttribute(ATTR_TYPE_ID);
                        String mode = element.getAttribute(ATTR_MODE_ID);
                        String perpsective = element.getAttribute(ATTR_PERSPECTIVE_ID);
                        this.internalSetLaunchPerspective(type, mode, perpsective);
                    }
                    ++i;
                }
            }
            catch (ParserConfigurationException e) {
                DebugUIPlugin.log(e);
            }
            catch (SAXException e) {
                DebugUIPlugin.log(e);
            }
            catch (IOException e) {
                DebugUIPlugin.log(e);
            }
        }
    }
}

