/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.launchConfigurations;

import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.jface.resource.ImageDescriptor;

public class LaunchGroupExtension {
    private IConfigurationElement fConfig;
    private ImageDescriptor fImageDescriptor;
    private ImageDescriptor fBannerImageDescriptor;

    public LaunchGroupExtension(IConfigurationElement element) {
        this.setConfigurationElement(element);
    }

    private void setConfigurationElement(IConfigurationElement element) {
        this.fConfig = element;
    }

    protected IConfigurationElement getConfigurationElement() {
        return this.fConfig;
    }

    public ImageDescriptor getImageDescriptor() {
        if (this.fImageDescriptor == null) {
            this.fImageDescriptor = this.createImageDescriptor("image");
        }
        return this.fImageDescriptor;
    }

    public ImageDescriptor getBannerImageDescriptor() {
        if (this.fBannerImageDescriptor == null) {
            this.fBannerImageDescriptor = this.createImageDescriptor("bannerImage");
        }
        return this.fBannerImageDescriptor;
    }

    public String getLabel() {
        return this.getConfigurationElement().getAttribute("label");
    }

    public String getShellTitle() {
        String title = this.getLabel();
        if (title != null) {
            int index = title.indexOf(38);
            if (index == 0) {
                title = title.substring(1);
            } else if (index > 0 && index < title.length() - 1) {
                String first = title.substring(0, index);
                String last = title.substring(index + 1);
                title = String.valueOf(first) + last;
            }
        }
        return title;
    }

    public String getIdentifier() {
        return this.getConfigurationElement().getAttribute("id");
    }

    public String getCategory() {
        return this.getConfigurationElement().getAttribute("category");
    }

    public String getMode() {
        return this.getConfigurationElement().getAttribute("mode");
    }

    protected ImageDescriptor createImageDescriptor(String attribute) {
        URL iconURL = this.getConfigurationElement().getDeclaringExtension().getDeclaringPluginDescriptor().getInstallURL();
        String iconPath = this.getConfigurationElement().getAttribute(attribute);
        if (iconPath != null) {
            try {
                iconURL = new URL(iconURL, iconPath);
                return ImageDescriptor.createFromURL((URL)iconURL);
            }
            catch (MalformedURLException e) {
                DebugUIPlugin.log(e);
            }
        }
        return null;
    }

    public boolean isPublic() {
        String string = this.getConfigurationElement().getAttribute("public");
        if (string == null) {
            return true;
        }
        return string.equals("true");
    }
}

