/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.launchConfigurations;

import java.util.HashSet;
import java.util.Hashtable;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.ui.ILaunchConfigurationTabGroup;

public class LaunchConfigurationTabGroupExtension {
    private IConfigurationElement fConfig;
    private Set fModes;
    private Map fPerspectives;

    public LaunchConfigurationTabGroupExtension(IConfigurationElement element) {
        this.setConfigurationElement(element);
    }

    private void setConfigurationElement(IConfigurationElement element) {
        this.fConfig = element;
    }

    protected IConfigurationElement getConfigurationElement() {
        return this.fConfig;
    }

    public ILaunchConfigurationType getType() {
        return DebugPlugin.getDefault().getLaunchManager().getLaunchConfigurationType(this.getTypeIdentifier());
    }

    protected Set getModes() {
        IConfigurationElement[] modes;
        if (this.fModes == null && (modes = this.getConfigurationElement().getChildren("launchMode")).length > 0) {
            this.fModes = new HashSet(modes.length);
            this.fPerspectives = new Hashtable(modes.length);
            int i = 0;
            while (i < modes.length) {
                IConfigurationElement element = modes[i];
                String mode = element.getAttribute("mode");
                this.fModes.add(mode);
                String perspective = element.getAttribute("perspective");
                if (perspective != null) {
                    this.fPerspectives.put(mode, perspective);
                }
                ++i;
            }
        }
        return this.fModes;
    }

    protected String getPerspective(String mode) {
        this.getModes();
        String id = null;
        if (this.fPerspectives != null) {
            id = (String)this.fPerspectives.get(mode);
        }
        return id;
    }

    protected String getTypeIdentifier() {
        return this.getConfigurationElement().getAttribute("type");
    }

    protected String getHelpContextId() {
        return this.getConfigurationElement().getAttribute("helpContextId");
    }

    public ILaunchConfigurationTabGroup newTabGroup() throws CoreException {
        return (ILaunchConfigurationTabGroup)this.getConfigurationElement().createExecutableExtension("class");
    }
}

