/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.actions;

import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchShortcutExtension;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;

public class LaunchShortcutAction
extends Action {
    private String fMode;
    private LaunchShortcutExtension fShortcut;

    public LaunchShortcutAction(String mode, LaunchShortcutExtension shortcut) {
        super(shortcut.getLabel(), shortcut.getImageDescriptor());
        this.fMode = mode;
        this.fShortcut = shortcut;
        this.updateEnablement();
    }

    public void run() {
        IWorkbenchPage page;
        IWorkbenchWindow wb = DebugUIPlugin.getActiveWorkbenchWindow();
        if (wb != null && (page = wb.getActivePage()) != null) {
            ISelection selection = page.getSelection();
            if (selection instanceof IStructuredSelection) {
                this.fShortcut.launch(selection, this.fMode);
            } else {
                IEditorPart editor = page.getActiveEditor();
                if (editor != null) {
                    this.fShortcut.launch(editor, this.fMode);
                }
            }
        }
    }

    private void updateEnablement() {
        IWorkbenchPage page;
        IWorkbenchWindow wb = DebugUIPlugin.getActiveWorkbenchWindow();
        boolean enabled = false;
        if (wb != null && (page = wb.getActivePage()) != null) {
            ISelection selection = page.getSelection();
            if (selection instanceof IStructuredSelection) {
                enabled = !((IStructuredSelection)selection).isEmpty();
            } else {
                IEditorPart editor = page.getActiveEditor();
                if (editor != null) {
                    enabled = true;
                }
            }
        }
        this.setEnabled(enabled);
    }
}

