/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.actions;

import java.util.Iterator;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IValueModification;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.internal.ui.DebugPluginImages;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.IDebugHelpContextIds;
import org.eclipse.debug.internal.ui.actions.ActionMessages;
import org.eclipse.debug.internal.ui.actions.ChangeVariableValueInputDialog;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IInputValidator;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.actions.SelectionProviderAction;
import org.eclipse.ui.help.WorkbenchHelp;

public class ChangeVariableValueAction
extends SelectionProviderAction {
    private ChangeVariableValueInputDialog fInputDialog;
    protected IVariable fVariable;

    public ChangeVariableValueAction(Viewer viewer) {
        super((ISelectionProvider)viewer, ActionMessages.getString("ChangeVariableValue.title"));
        this.setDescription(ActionMessages.getString("ChangeVariableValue.toolTipText"));
        this.setImageDescriptor(DebugPluginImages.getImageDescriptor("IMG_ELCL_CHANGE_VARIABLE_VALUE"));
        this.setHoverImageDescriptor(DebugPluginImages.getImageDescriptor("IMG_LCL_CHANGE_VARIABLE_VALUE"));
        this.setDisabledImageDescriptor(DebugPluginImages.getImageDescriptor("IMG_DLCL_CHANGE_VARIABLE_VALUE"));
        WorkbenchHelp.setHelp((IAction)this, (String)IDebugHelpContextIds.CHANGE_VALUE_ACTION);
    }

    protected void doActionPerformed(IVariable variable) {
        IWorkbenchWindow window = DebugUIPlugin.getActiveWorkbenchWindow();
        if (window == null) {
            return;
        }
        Shell activeShell = window.getShell();
        if (this.fInputDialog != null) {
            return;
        }
        this.fVariable = variable;
        String name = "";
        String value = "";
        try {
            name = this.fVariable.getName();
            value = this.fVariable.getValue().getValueString();
        }
        catch (DebugException exception) {
            DebugUIPlugin.errorDialog(activeShell, ActionMessages.getString("ChangeVariableValue.errorDialogTitle"), ActionMessages.getString("ChangeVariableValue.errorDialogMessage"), exception);
            this.fInputDialog = null;
            return;
        }
        this.fInputDialog = new ChangeVariableValueInputDialog(activeShell, ActionMessages.getString("ChangeVariableValueSet_Variable_Value_1"), String.valueOf(ActionMessages.getString("ChangeVariableValueEnter_a_new_value_for__2")) + name + ':', value, new IInputValidator(){

            public String isValid(String input) {
                try {
                    if (ChangeVariableValueAction.this.fVariable.verifyValue(input)) {
                        return null;
                    }
                }
                catch (DebugException debugException) {
                    return ActionMessages.getString("ChangeVariableValueAn_exception_occurred_3");
                }
                return ActionMessages.getString("ChangeVariableValueInvalid_value_4");
            }
        });
        this.fInputDialog.open();
        String newValue = this.fInputDialog.getValue();
        if (newValue != null) {
            try {
                this.fVariable.setValue(newValue);
                this.getSelectionProvider().setSelection((ISelection)new StructuredSelection((Object)variable));
            }
            catch (DebugException de) {
                DebugUIPlugin.errorDialog(activeShell, ActionMessages.getString("ChangeVariableValue.errorDialogTitle"), ActionMessages.getString("ChangeVariableValue.errorDialogMessage"), de);
                this.fInputDialog = null;
                return;
            }
        }
        this.fInputDialog = null;
    }

    protected void update(IStructuredSelection sel) {
        Object object;
        Iterator iter = sel.iterator();
        if (iter.hasNext() && (object = iter.next()) instanceof IValueModification) {
            IValueModification varMod = (IValueModification)object;
            if (!varMod.supportsValueModification()) {
                this.setEnabled(false);
                return;
            }
            this.setEnabled(!iter.hasNext());
            return;
        }
        this.setEnabled(false);
    }

    public void run() {
        Iterator iterator = this.getStructuredSelection().iterator();
        this.doActionPerformed((IVariable)iterator.next());
    }

    public void selectionChanged(IStructuredSelection sel) {
        this.update(sel);
    }
}

