/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui.actions;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.IDebugHelpContextIds;
import org.eclipse.debug.internal.ui.actions.ActionMessages;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchGroupExtension;
import org.eclipse.debug.ui.DebugUITools;
import org.eclipse.debug.ui.IDebugUIConstants;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.actions.SelectionListenerAction;
import org.eclipse.ui.help.WorkbenchHelp;

public class AddToFavoritesAction
extends SelectionListenerAction {
    private ILaunchConfiguration fConfiguration = null;
    private String fMode = null;
    private LaunchGroupExtension fGroup = null;
    static /* synthetic */ Class class$0;

    public AddToFavoritesAction() {
        super("");
        this.setEnabled(false);
        WorkbenchHelp.setHelp((IAction)this, (String)IDebugHelpContextIds.EDIT_LAUNCH_CONFIGURATION_ACTION);
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        ILaunchConfiguration config;
        this.setLaunchConfiguration(null);
        this.setMode(null);
        if (selection.size() == 1) {
            ILaunchConfiguration configuration;
            Object object = selection.getFirstElement();
            ILaunch launch = null;
            if (object instanceof IAdaptable) {
                IAdaptable iAdaptable = (IAdaptable)object;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("[Lorg.eclipse.debug.core.ILaunch;").getComponentType();
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                launch = (ILaunch)iAdaptable.getAdapter((Class)clazz);
            }
            if (launch == null) {
                if (object instanceof ILaunch) {
                    launch = (ILaunch)object;
                } else if (object instanceof IDebugElement) {
                    launch = ((IDebugElement)object).getLaunch();
                } else if (object instanceof IProcess) {
                    launch = ((IProcess)object).getLaunch();
                }
            }
            if (launch != null && (configuration = launch.getLaunchConfiguration()) != null) {
                this.setLaunchConfiguration(configuration);
                this.setMode(launch.getLaunchMode());
                this.setGroup(DebugUIPlugin.getDefault().getLaunchConfigurationManager().getLaunchGroup(configuration, this.getMode()));
                this.setText(MessageFormat.format(ActionMessages.getString("AddToFavoritesAction.1"), this.getGroup().getLabel()));
            }
        }
        if ((config = this.getLaunchConfiguration()) == null) {
            return false;
        }
        if (DebugUITools.isPrivate(config)) {
            return false;
        }
        if (this.getGroup() != null) {
            try {
                List groups = config.getAttribute(IDebugUIConstants.ATTR_FAVORITE_GROUPS, null);
                if (groups != null) {
                    return !groups.contains(this.getGroup().getIdentifier());
                }
                return true;
            }
            catch (CoreException coreException) {}
        }
        return false;
    }

    protected void setLaunchConfiguration(ILaunchConfiguration configuration) {
        this.fConfiguration = configuration;
    }

    protected ILaunchConfiguration getLaunchConfiguration() {
        return this.fConfiguration;
    }

    protected void setMode(String mode) {
        this.fMode = mode;
    }

    protected String getMode() {
        return this.fMode;
    }

    protected void setGroup(LaunchGroupExtension group) {
        this.fGroup = group;
    }

    protected LaunchGroupExtension getGroup() {
        return this.fGroup;
    }

    public void run() {
        final CoreException[] ex = new CoreException[1];
        BusyIndicator.showWhile((Display)DebugUIPlugin.getStandardDisplay(), (Runnable)new Runnable(){

            public void run() {
                try {
                    ArrayList<String> list = AddToFavoritesAction.this.getLaunchConfiguration().getAttribute(IDebugUIConstants.ATTR_FAVORITE_GROUPS, null);
                    if (list == null) {
                        list = new ArrayList<String>();
                    }
                    list.add(AddToFavoritesAction.this.getGroup().getIdentifier());
                    ILaunchConfigurationWorkingCopy copy = AddToFavoritesAction.this.getLaunchConfiguration().getWorkingCopy();
                    copy.setAttribute(IDebugUIConstants.ATTR_FAVORITE_GROUPS, list);
                    copy.doSave();
                    AddToFavoritesAction.this.setEnabled(false);
                }
                catch (CoreException e) {
                    ex[0] = e;
                }
            }
        });
        if (ex[0] != null) {
            DebugUIPlugin.errorDialog(DebugUIPlugin.getShell(), ActionMessages.getString("AddToFavoritesAction.2"), ActionMessages.getString("AddToFavoritesAction.3"), ex[0].getStatus());
        }
    }
}

