/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.internal.ui.InstructionPointerAnnotation;
import org.eclipse.debug.internal.ui.InstructionPointerContext;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.Position;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.jface.text.source.IAnnotationModel;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class InstructionPointerManager {
    private static InstructionPointerManager fgDefault;
    private Map fDebugTargetMap = new HashMap();

    private InstructionPointerManager() {
    }

    public static InstructionPointerManager getDefault() {
        if (fgDefault == null) {
            fgDefault = new InstructionPointerManager();
        }
        return fgDefault;
    }

    public void addAnnotation(ITextEditor textEditor, IStackFrame stackFrame) {
        ArrayList<InstructionPointerContext> contextList;
        IDocumentProvider docProvider = textEditor.getDocumentProvider();
        IEditorInput editorInput = textEditor.getEditorInput();
        IThread thread = stackFrame.getThread();
        boolean tos = false;
        try {
            tos = stackFrame.equals(thread.getTopStackFrame());
        }
        catch (DebugException debugException) {}
        InstructionPointerAnnotation instPtrAnnotation = new InstructionPointerAnnotation(stackFrame, tos);
        Position position = null;
        int charStart = -1;
        int length = -1;
        try {
            charStart = stackFrame.getCharStart();
            length = stackFrame.getCharEnd() - charStart;
        }
        catch (DebugException debugException) {}
        if (charStart < 0) {
            IDocument doc = docProvider.getDocument((Object)editorInput);
            try {
                int lineNumber = stackFrame.getLineNumber() - 1;
                IRegion region = doc.getLineInformation(lineNumber);
                charStart = region.getOffset();
                length = region.getLength();
            }
            catch (BadLocationException badLocationException) {
                return;
            }
            catch (DebugException debugException) {
                return;
            }
        }
        if (charStart < 0) {
            return;
        }
        position = new Position(charStart, length);
        IAnnotationModel annModel = docProvider.getAnnotationModel((Object)editorInput);
        if (annModel == null) {
            return;
        }
        annModel.removeAnnotation((Annotation)instPtrAnnotation);
        annModel.addAnnotation((Annotation)instPtrAnnotation, position);
        IDebugTarget debugTarget = stackFrame.getDebugTarget();
        HashMap threadMap = (HashMap)this.fDebugTargetMap.get(debugTarget);
        if (threadMap == null) {
            threadMap = new HashMap();
            this.fDebugTargetMap.put(debugTarget, threadMap);
        }
        if ((contextList = (ArrayList<InstructionPointerContext>)threadMap.get(thread)) == null) {
            contextList = new ArrayList<InstructionPointerContext>();
            threadMap.put(thread, contextList);
        }
        InstructionPointerContext context = new InstructionPointerContext(textEditor, instPtrAnnotation);
        contextList.remove(context);
        contextList.add(context);
    }

    public void removeAnnotations(IDebugTarget debugTarget) {
        Map threadMap = (Map)this.fDebugTargetMap.get(debugTarget);
        if (threadMap == null) {
            return;
        }
        Object[] threads = threadMap.keySet().toArray();
        int i = 0;
        while (i < threads.length) {
            IThread thread = (IThread)threads[i];
            this.removeAnnotations(thread, threadMap);
            ++i;
        }
        this.fDebugTargetMap.remove(debugTarget);
    }

    public void removeAnnotations(IThread thread) {
        IDebugTarget debugTarget = thread.getDebugTarget();
        Map threadMap = (Map)this.fDebugTargetMap.get(debugTarget);
        if (threadMap == null) {
            return;
        }
        this.removeAnnotations(thread, threadMap);
    }

    private void removeAnnotations(IThread thread, Map threadMap) {
        List contextList = (List)threadMap.get(thread);
        if (contextList != null) {
            Iterator contextIterator = contextList.iterator();
            while (contextIterator.hasNext()) {
                InstructionPointerContext context = (InstructionPointerContext)contextIterator.next();
                this.removeAnnotation(context.getTextEditor(), context.getAnnotation());
            }
        }
        threadMap.remove(thread);
    }

    private void removeAnnotation(ITextEditor textEditor, InstructionPointerAnnotation annotation) {
        IAnnotationModel annotationModel;
        IDocumentProvider docProvider = textEditor.getDocumentProvider();
        if (docProvider != null && (annotationModel = docProvider.getAnnotationModel((Object)textEditor.getEditorInput())) != null) {
            annotationModel.removeAnnotation((Annotation)annotation);
        }
    }
}

