/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui;

import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.internal.ui.DebugPluginImages;
import org.eclipse.debug.internal.ui.DebugUIMessages;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.ui.IDebugEditorPresentation;
import org.eclipse.jface.text.source.Annotation;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.ui.texteditor.DefaultAnnotation;

public class InstructionPointerAnnotation
extends DefaultAnnotation {
    private IStackFrame fStackFrame;
    private boolean fTopStackFrame;

    public InstructionPointerAnnotation(IStackFrame stackFrame, boolean isTopFrame) {
        super(isTopFrame ? "org.eclipse.debug.ui.instructionPointer.current" : "org.eclipse.debug.ui.instructionPointer.secondary", 0, true, isTopFrame ? DebugUIMessages.getString("InstructionPointerAnnotation.0") : DebugUIMessages.getString("InstructionPointerAnnotation.1"));
        this.fTopStackFrame = isTopFrame;
        this.fStackFrame = stackFrame;
    }

    public void paint(GC gc, Canvas canvas, Rectangle bounds) {
        Image image = this.getInstructionPointerImage(this.isTopStackFrame());
        Annotation.drawImage((Image)image, (GC)gc, (Canvas)canvas, (Rectangle)bounds, (int)0x1000000);
    }

    private Image getInstructionPointerImage(boolean topStackFrame) {
        IDebugEditorPresentation presentation = (IDebugEditorPresentation)((Object)DebugUIPlugin.getModelPresentation());
        Image image = presentation.getInstructionPointerImage(this.getStackFrame());
        if (image == null) {
            image = topStackFrame ? DebugPluginImages.getImage("IMG_OBJS_INSTRUCTION_POINTER_TOP") : DebugPluginImages.getImage("IMG_OBJS_INSTRUCTION_POINTER");
        }
        return image;
    }

    public boolean equals(Object other) {
        if (other instanceof InstructionPointerAnnotation) {
            return this.getStackFrame().equals(((InstructionPointerAnnotation)((Object)other)).getStackFrame());
        }
        return false;
    }

    public int hashCode() {
        return this.getStackFrame().hashCode();
    }

    private IStackFrame getStackFrame() {
        return this.fStackFrame;
    }

    private boolean isTopStackFrame() {
        return this.fTopStackFrame;
    }
}

