/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui;

import org.eclipse.core.resources.IMarker;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.debug.core.DebugException;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationType;
import org.eclipse.debug.core.model.IBreakpoint;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IDisconnect;
import org.eclipse.debug.core.model.IExpression;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStackFrame;
import org.eclipse.debug.core.model.ITerminate;
import org.eclipse.debug.core.model.IThread;
import org.eclipse.debug.core.model.IValue;
import org.eclipse.debug.core.model.IVariable;
import org.eclipse.debug.core.model.IWatchExpression;
import org.eclipse.debug.internal.ui.DebugPluginImages;
import org.eclipse.debug.internal.ui.DebugUIMessages;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.debug.internal.ui.views.variables.IndexedVariablePartition;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.model.IWorkbenchAdapter;

public class DefaultLabelProvider
implements ILabelProvider {
    static /* synthetic */ Class class$0;

    public Image getImage(Object element) {
        String key = this.getImageKey(element);
        if (key == null && element instanceof IAdaptable) {
            ImageDescriptor descriptor;
            IWorkbenchAdapter de;
            IAdaptable iAdaptable = (IAdaptable)element;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("[Lorg.eclipse.ui.model.IWorkbenchAdapter;").getComponentType();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((de = (IWorkbenchAdapter)iAdaptable.getAdapter((Class)clazz)) != null && (descriptor = de.getImageDescriptor(element)) != null) {
                return descriptor.createImage();
            }
            return null;
        }
        return DebugPluginImages.getImage(key);
    }

    public String getImageKey(Object element) {
        if (element instanceof IDebugElement) {
            if (element instanceof IVariable) {
                if (element instanceof IndexedVariablePartition) {
                    return "IMG_OBJS_ARRAY_PARTITION";
                }
                return "IMG_OBJS_VARIABLE";
            }
            if (element instanceof IStackFrame) {
                if (((IStackFrame)element).getThread().isSuspended()) {
                    return "IMG_OBJS_STACKFRAME";
                }
                return "IMG_OBJS_STACKFRAME_RUNNING";
            }
            if (element instanceof IThread) {
                IThread thread = (IThread)element;
                if (thread.isSuspended()) {
                    return "IMG_OBJS_THREAD_SUSPENDED";
                }
                if (thread.isTerminated()) {
                    return "IMG_OBJS_THREAD_TERMINATED";
                }
                return "IMG_OBJS_THREAD_RUNNING";
            }
            if (element instanceof IDebugTarget) {
                IDebugTarget target = (IDebugTarget)element;
                if (target.isTerminated() || target.isDisconnected()) {
                    return "IMG_OBJS_DEBUG_TARGET_TERMINATED";
                }
                if (target.isSuspended()) {
                    return "IMG_OBJS_DEBUG_TARGET_SUSPENDED";
                }
                return "IMG_OBJS_DEBUG_TARGET";
            }
            if (element instanceof IExpression) {
                return "IMG_OBJS_EXPRESSION";
            }
        } else {
            if (element instanceof IMarker) {
                return this.getMarkerImageKey((IMarker)element);
            }
            if (element instanceof IProcess) {
                if (((IProcess)element).isTerminated()) {
                    return "IMG_OBJS_OS_PROCESS_TERMINATED";
                }
                return "IMG_OBJS_OS_PROCESS";
            }
            if (element instanceof ILaunch) {
                ILaunch launch = (ILaunch)element;
                ILaunchConfiguration configuration = launch.getLaunchConfiguration();
                if (configuration != null) {
                    try {
                        return configuration.getType().getIdentifier();
                    }
                    catch (CoreException e) {
                        DebugUIPlugin.log(e);
                        return null;
                    }
                }
                if (launch.getLaunchMode().equals("debug")) {
                    return "IMG_OBJS_LAUNCH_DEBUG";
                }
                if (launch.isTerminated()) {
                    return "IMG_OBJS_LAUNCH_RUN_TERMINATED";
                }
                return "IMG_OBJS_LAUNCH_RUN";
            }
            if (element instanceof ILaunchConfigurationType) {
                return ((ILaunchConfigurationType)element).getIdentifier();
            }
            if (element instanceof ILaunchConfiguration) {
                try {
                    return ((ILaunchConfiguration)element).getType().getIdentifier();
                }
                catch (CoreException e) {
                    DebugUIPlugin.log(e);
                    return null;
                }
            }
        }
        return null;
    }

    public String getText(Object element) {
        StringBuffer label = new StringBuffer();
        try {
            if (element instanceof IDebugElement) {
                if (element instanceof IStackFrame) {
                    label.append(((IStackFrame)element).getName());
                } else if (element instanceof IndexedVariablePartition) {
                    label.append(((IndexedVariablePartition)element).getName());
                } else if (element instanceof IVariable) {
                    label.append(this.getVariableText((IVariable)element));
                } else if (element instanceof IThread) {
                    label.append(((IThread)element).getName());
                } else if (element instanceof IDebugTarget) {
                    label.append(((IDebugTarget)element).getName());
                } else if (element instanceof IExpression) {
                    label.append(this.getExpressionText((IExpression)element));
                }
            } else if (element instanceof IMarker) {
                label.append(this.getMarkerText((IMarker)element));
            } else if (element instanceof IProcess) {
                label.append(((IProcess)element).getLabel());
            } else if (element instanceof ILaunch) {
                label.append(this.getLaunchText((ILaunch)element));
            } else if (element instanceof ILaunchConfiguration) {
                label.append(((ILaunchConfiguration)element).getName());
            } else if (element instanceof ILaunchConfigurationType) {
                label.append(((ILaunchConfigurationType)element).getName());
            } else if (element instanceof String) {
                label.append(element);
            } else {
                label.append(this.getAdapterLabel(element));
            }
            if (element instanceof ITerminate) {
                if (((ITerminate)element).isTerminated()) {
                    label.insert(0, DebugUIMessages.getString("DefaultLabelProvider.<terminated>_1"));
                }
            } else if (element instanceof IDisconnect && ((IDisconnect)element).isDisconnected()) {
                label.insert(0, DebugUIMessages.getString("DefaultLabelProvider.<disconnected>_1"));
            }
        }
        catch (DebugException e) {
            DebugUIPlugin.log(e);
            label.append(DebugUIMessages.getString("DefaultLabelProvider.<unknown>_1"));
        }
        return label.toString();
    }

    public String getAdapterLabel(Object object) {
        if (object instanceof IAdaptable) {
            IWorkbenchAdapter de;
            IAdaptable iAdaptable = (IAdaptable)object;
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("[Lorg.eclipse.ui.model.IWorkbenchAdapter;").getComponentType();
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            if ((de = (IWorkbenchAdapter)iAdaptable.getAdapter((Class)clazz)) != null) {
                return de.getLabel(object);
            }
        }
        return DebugUIMessages.getString("DefaultLabelProvider.<unknown>_1");
    }

    protected String getLaunchText(ILaunch launch) {
        if (launch.getLaunchConfiguration() == null || !launch.getLaunchConfiguration().exists() && !launch.getLaunchConfiguration().isWorkingCopy()) {
            return DebugUIMessages.getString("DefaultLabelProvider.<unknown>_1");
        }
        ILaunchConfiguration config = launch.getLaunchConfiguration();
        StringBuffer buff = new StringBuffer(config.getName());
        buff.append(" [");
        try {
            buff.append(config.getType().getName());
        }
        catch (CoreException e) {
            DebugUIPlugin.log(e);
        }
        buff.append("]");
        return buff.toString();
    }

    protected String getExpressionText(IExpression expression) {
        if (expression instanceof IWatchExpression) {
            return this.getWatchExpressionText((IWatchExpression)expression);
        }
        StringBuffer buffer = new StringBuffer(expression.getExpressionText());
        String valueString = null;
        IValue value = expression.getValue();
        if (value != null && (valueString == null || valueString.length() < 1)) {
            try {
                valueString = value.getValueString();
            }
            catch (DebugException de) {
                DebugUIPlugin.log(de);
            }
        }
        if (valueString != null && valueString.length() > 0) {
            buffer.append("= ");
            buffer.append(valueString);
        }
        return buffer.toString();
    }

    protected String getWatchExpressionText(IWatchExpression expression) {
        StringBuffer result = new StringBuffer();
        result.append('\"').append(expression.getExpressionText()).append('\"');
        if (expression.isPending()) {
            result.append(DebugUIMessages.getString("DefaultLabelProvider.12"));
        } else if (expression.hasErrors()) {
            result.append(DebugUIMessages.getString("DefaultLabelProvider.13"));
        } else {
            String valueString;
            IValue value = expression.getValue();
            if (value != null && (valueString = DebugUIPlugin.getModelPresentation().getText(value)).length() > 0) {
                result.append(" = ").append(valueString);
            }
        }
        if (expression.isObsolete()) {
            result.append(DebugUIMessages.getString("DefaultLabelProvider.14"));
        }
        if (!expression.isEnabled()) {
            result.append(DebugUIMessages.getString("DefaultLabelProvider.15"));
        }
        return result.toString();
    }

    protected String getVariableText(IVariable variable) {
        StringBuffer buffer = new StringBuffer();
        try {
            IValue value = variable.getValue();
            buffer.append(variable.getName());
            buffer.append(" = ");
            buffer.append(value.getValueString());
        }
        catch (DebugException de) {
            DebugUIPlugin.log(de);
        }
        return buffer.toString();
    }

    protected String getMarkerText(IMarker marker) {
        try {
            if (marker.exists() && marker.isSubtypeOf(IBreakpoint.BREAKPOINT_MARKER)) {
                return DebugUIMessages.getString("DefaultLabelProvider.Breakpoint_1");
            }
        }
        catch (CoreException e) {
            DebugUIPlugin.log(e);
        }
        return "";
    }

    protected String getMarkerImageKey(IMarker marker) {
        try {
            IBreakpoint breakpoint = DebugPlugin.getDefault().getBreakpointManager().getBreakpoint(marker);
            if (breakpoint != null && marker.exists()) {
                if (breakpoint.isEnabled()) {
                    return "IMG_OBJS_BREAKPOINT";
                }
                return "IMG_OBJS_BREAKPOINT_DISABLED";
            }
        }
        catch (CoreException e) {
            DebugUIPlugin.log(e);
        }
        return null;
    }

    public void addListener(ILabelProviderListener listener) {
    }

    public void dispose() {
    }

    public boolean isLabelProperty(Object element, String property) {
        return false;
    }

    public void removeListener(ILabelProviderListener listener) {
    }
}

