/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IAdapterFactory;
import org.eclipse.core.runtime.IAdapterManager;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchListener;
import org.eclipse.debug.core.ILaunchManager;
import org.eclipse.debug.core.model.IDebugElement;
import org.eclipse.debug.core.model.IDebugTarget;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.internal.ui.AlwaysNeverDialog;
import org.eclipse.debug.internal.ui.ColorManager;
import org.eclipse.debug.internal.ui.DebugPluginImages;
import org.eclipse.debug.internal.ui.DebugUIAdapterFactory;
import org.eclipse.debug.internal.ui.DebugUIMessages;
import org.eclipse.debug.internal.ui.DebugUIPropertiesAdapterFactory;
import org.eclipse.debug.internal.ui.DefaultLabelProvider;
import org.eclipse.debug.internal.ui.DelegatingModelPresentation;
import org.eclipse.debug.internal.ui.launchConfigurations.LaunchConfigurationManager;
import org.eclipse.debug.internal.ui.launchConfigurations.PerspectiveManager;
import org.eclipse.debug.internal.ui.preferences.DebugActionGroupsManager;
import org.eclipse.debug.internal.ui.preferences.IDebugPreferenceConstants;
import org.eclipse.debug.internal.ui.stringsubstitution.SelectedResourceManager;
import org.eclipse.debug.internal.ui.views.console.ConsoleDocumentManager;
import org.eclipse.debug.ui.IDebugModelPresentation;
import org.eclipse.debug.ui.IDebugUIConstants;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.ProgressMonitorDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferenceConverter;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.w3c.dom.Document;

public class DebugUIPlugin
extends AbstractUIPlugin
implements ILaunchListener {
    private static DebugUIPlugin fgDebugUIPlugin = null;
    protected static IDebugModelPresentation fgPresentation = null;
    private static DefaultLabelProvider fgDefaultLabelProvider;
    private boolean fTrace = false;
    private ConsoleDocumentManager fConsoleDocumentManager = null;
    private PerspectiveManager fPerspectiveManager = null;
    private LaunchConfigurationManager fLaunchConfigurationManager = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;

    public boolean isTraceMode() {
        return this.fTrace;
    }

    public static void logTraceMessage(String message) {
        if (DebugUIPlugin.getDefault().isTraceMode()) {
            Status s = new Status(2, IDebugUIConstants.PLUGIN_ID, 120, message, null);
            DebugUIPlugin.getDefault().getLog().log((IStatus)s);
        }
    }

    public DebugUIPlugin(IPluginDescriptor descriptor) {
        super(descriptor);
        fgDebugUIPlugin = this;
    }

    protected ILaunchManager getLaunchManager() {
        return DebugPlugin.getDefault().getLaunchManager();
    }

    public static DebugUIPlugin getDefault() {
        return fgDebugUIPlugin;
    }

    public static String getUniqueIdentifier() {
        if (DebugUIPlugin.getDefault() == null) {
            return "org.eclipse.debug.ui";
        }
        return DebugUIPlugin.getDefault().getDescriptor().getUniqueIdentifier();
    }

    public static IDebugModelPresentation getModelPresentation() {
        if (fgPresentation == null) {
            fgPresentation = new DelegatingModelPresentation();
        }
        return fgPresentation;
    }

    public LaunchConfigurationManager getLaunchConfigurationManager() {
        if (this.fLaunchConfigurationManager == null) {
            this.fLaunchConfigurationManager = new LaunchConfigurationManager();
        }
        return this.fLaunchConfigurationManager;
    }

    public static IWorkbenchWindow getActiveWorkbenchWindow() {
        return DebugUIPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow();
    }

    public static Shell getShell() {
        if (DebugUIPlugin.getActiveWorkbenchWindow() != null) {
            return DebugUIPlugin.getActiveWorkbenchWindow().getShell();
        }
        return null;
    }

    public static ILabelProvider getDefaultLabelProvider() {
        if (fgDefaultLabelProvider == null) {
            fgDefaultLabelProvider = new DefaultLabelProvider();
        }
        return fgDefaultLabelProvider;
    }

    public static Object createExtension(final IConfigurationElement element, final String classAttribute) throws CoreException {
        IPluginDescriptor plugin = element.getDeclaringExtension().getDeclaringPluginDescriptor();
        if (plugin.isPluginActivated()) {
            return element.createExecutableExtension(classAttribute);
        }
        final Object[] ret = new Object[1];
        final CoreException[] exc = new CoreException[1];
        BusyIndicator.showWhile(null, (Runnable)new Runnable(){

            public void run() {
                try {
                    ret[0] = element.createExecutableExtension(classAttribute);
                }
                catch (CoreException e) {
                    exc[0] = e;
                }
            }
        });
        if (exc[0] != null) {
            throw exc[0];
        }
        return ret[0];
    }

    protected ImageRegistry createImageRegistry() {
        return DebugPluginImages.initializeImageRegistry();
    }

    public void shutdown() throws CoreException {
        if (this.fPerspectiveManager != null) {
            this.fPerspectiveManager.shutdown();
        }
        if (DebugActionGroupsManager.defaultExists()) {
            DebugActionGroupsManager.getDefault().shutdown();
        }
        if (this.fLaunchConfigurationManager != null) {
            this.fLaunchConfigurationManager.shutdown();
        }
        if (this.fConsoleDocumentManager != null) {
            this.fConsoleDocumentManager.shutdown();
        }
        ColorManager.getDefault().dispose();
        if (fgPresentation != null) {
            fgPresentation.dispose();
        }
        super.shutdown();
    }

    public void startup() throws CoreException {
        super.startup();
        DebugPlugin.getDefault().getLaunchManager().addLaunchListener((ILaunchListener)this);
        IAdapterManager manager = Platform.getAdapterManager();
        DebugUIPropertiesAdapterFactory propertiesFactory = new DebugUIPropertiesAdapterFactory();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("[Lorg.eclipse.debug.core.model.IDebugElement;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        manager.registerAdapters((IAdapterFactory)propertiesFactory, (Class)clazz);
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("[Lorg.eclipse.debug.core.model.IProcess;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        manager.registerAdapters((IAdapterFactory)propertiesFactory, (Class)clazz2);
        DebugUIAdapterFactory uiFactory = new DebugUIAdapterFactory();
        Class<?> clazz3 = class$2;
        if (clazz3 == null) {
            try {
                clazz3 = class$2 = Class.forName("[Lorg.eclipse.debug.core.ILaunchConfiguration;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        manager.registerAdapters((IAdapterFactory)uiFactory, (Class)clazz3);
        Class<?> clazz4 = class$3;
        if (clazz4 == null) {
            try {
                clazz4 = class$3 = Class.forName("[Lorg.eclipse.debug.core.ILaunchConfigurationType;").getComponentType();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        manager.registerAdapters((IAdapterFactory)uiFactory, (Class)clazz4);
        DebugUIPlugin.getStandardDisplay().asyncExec(new Runnable(){

            public void run() {
                SelectedResourceManager.getDefault();
            }
        });
    }

    protected void initializeDefaultPreferences(IPreferenceStore prefs) {
        prefs.setDefault(IDebugUIConstants.PREF_BUILD_BEFORE_LAUNCH, true);
        prefs.setDefault(IDebugUIConstants.PREF_SAVE_DIRTY_EDITORS_BEFORE_LAUNCH_RADIO, IDebugUIConstants.PREF_PROMPT_SAVE_DIRTY_EDITORS_BEFORE_LAUNCH);
        prefs.setDefault(IDebugUIConstants.PREF_SHOW_DEBUG_PERSPECTIVE_DEFAULT, IDebugUIConstants.ID_DEBUG_PERSPECTIVE);
        prefs.setDefault(IDebugUIConstants.PREF_SHOW_RUN_PERSPECTIVE_DEFAULT, "perspective_none");
        prefs.setDefault(IDebugUIConstants.PREF_AUTO_REMOVE_OLD_LAUNCHES, false);
        prefs.setDefault(IDebugUIConstants.PREF_ACTIVATE_WORKBENCH, true);
        prefs.setDefault(IDebugUIConstants.PREF_WAIT_FOR_BUILD, "prompt");
        prefs.setDefault(IDebugUIConstants.PREF_REUSE_EDITOR, true);
        prefs.setDefault("Console.wrap", false);
        prefs.setDefault("Console.width", 80);
        prefs.setDefault("DEBUG.consoleOpenOnOut", true);
        prefs.setDefault("DEBUG.consoleOpenOnErr", true);
        prefs.setDefault("Console.limitConsoleOutput", true);
        prefs.setDefault("Console.lowWaterMark", 80000);
        prefs.setDefault("Console.highWaterMark", 100000);
        prefs.setDefault("Console.console_tab_width", 8);
        PreferenceConverter.setDefault((IPreferenceStore)prefs, (String)"Console.stdOutColor", (RGB)new RGB(0, 0, 255));
        PreferenceConverter.setDefault((IPreferenceStore)prefs, (String)"Console.stdInColor", (RGB)new RGB(0, 200, 125));
        PreferenceConverter.setDefault((IPreferenceStore)prefs, (String)"Console.stdErrColor", (RGB)new RGB(255, 0, 0));
        prefs.setDefault(IDebugUIConstants.PREF_MAX_HISTORY_SIZE, 10);
        prefs.setDefault("Variables.detail.orientation", "Variables.detail.orientation.underneath");
        PreferenceConverter.setDefault((IPreferenceStore)prefs, (String)"Changed.Variable.RGB", (RGB)new RGB(255, 0, 0));
        prefs.setDefault(IDebugPreferenceConstants.PREF_DETAIL_PANE_WORD_WRAP, false);
        prefs.setDefault("org.eclipse.debug.ui.VariableView+org.eclipse.debug.ui.ShowDetailPaneAction", true);
        prefs.setDefault("org.eclipse.debug.ui.ExpressionView+org.eclipse.debug.ui.ShowDetailPaneAction", true);
        prefs.setDefault("org.eclipse.debug.ui.VariableView+org.eclipse.debug.ui.ShowTypeNamesAction", false);
        prefs.setDefault("org.eclipse.debug.ui.ExpressionView+org.eclipse.debug.ui.ShowTypeNamesAction", false);
    }

    protected IProcess getProcessFromInput(Object input) {
        IProcess processInput = null;
        if (input instanceof IProcess) {
            processInput = (IProcess)input;
        } else if (input instanceof ILaunch) {
            IDebugTarget target = ((ILaunch)input).getDebugTarget();
            if (target != null) {
                processInput = target.getProcess();
            } else {
                IProcess[] processes = ((ILaunch)input).getProcesses();
                if (processes != null && processes.length > 0) {
                    processInput = processes[0];
                }
            }
        } else if (input instanceof IDebugElement) {
            processInput = ((IDebugElement)input).getDebugTarget().getProcess();
        }
        return processInput;
    }

    public static void errorDialog(Shell shell, String title, String message, IStatus s) {
        if (s != null && message.equals(s.getMessage())) {
            message = null;
        }
        ErrorDialog.openError((Shell)shell, (String)title, (String)message, (IStatus)s);
    }

    public static void errorDialog(Shell shell, String title, String message, Throwable t) {
        IStatus status;
        if (t instanceof CoreException) {
            status = ((CoreException)t).getStatus();
            if (status != null && message.equals(status.getMessage())) {
                message = null;
            }
        } else {
            status = new Status(4, DebugUIPlugin.getUniqueIdentifier(), 120, "Error within Debug UI: ", t);
            DebugUIPlugin.log(status);
        }
        ErrorDialog.openError((Shell)shell, (String)title, (String)message, (IStatus)status);
    }

    public static void log(IStatus status) {
        DebugUIPlugin.getDefault().getLog().log(status);
    }

    public static void log(Throwable t) {
        DebugUIPlugin.log(DebugUIPlugin.newErrorStatus("Error logged from Debug UI: ", t));
    }

    public static void logDebugMessage(String message) {
        if (DebugUIPlugin.getDefault().isDebugging()) {
            DebugUIPlugin.logErrorMessage(message);
        }
    }

    public static void logErrorMessage(String message) {
        DebugUIPlugin.log(DebugUIPlugin.newErrorStatus("Internal message logged from Debug UI: " + message, null));
    }

    public static IStatus newErrorStatus(String message, Throwable exception) {
        return new Status(4, DebugUIPlugin.getUniqueIdentifier(), 120, message, exception);
    }

    protected static boolean saveAllEditors(boolean confirm) {
        if (DebugUIPlugin.getActiveWorkbenchWindow() == null) {
            return false;
        }
        return PlatformUI.getWorkbench().saveAllEditors(confirm);
    }

    public static boolean saveAndBuild() {
        boolean status = true;
        String saveDirty = DebugUIPlugin.getDefault().getPreferenceStore().getString(IDebugUIConstants.PREF_SAVE_DIRTY_EDITORS_BEFORE_LAUNCH_RADIO);
        boolean buildBeforeLaunch = DebugUIPlugin.getDefault().getPreferenceStore().getBoolean(IDebugUIConstants.PREF_BUILD_BEFORE_LAUNCH);
        boolean autobuilding = ResourcesPlugin.getWorkspace().isAutoBuilding();
        if (saveDirty.equals(IDebugUIConstants.PREF_NEVER_SAVE_DIRTY_EDITORS_BEFORE_LAUNCH)) {
            if (buildBeforeLaunch) {
                return DebugUIPlugin.doBuild();
            }
        } else {
            boolean prompt = false;
            if (saveDirty.equals(IDebugUIConstants.PREF_PROMPT_SAVE_DIRTY_EDITORS_BEFORE_LAUNCH)) {
                prompt = true;
            }
            if ((status = DebugUIPlugin.saveAllEditors(prompt)) && !autobuilding && buildBeforeLaunch) {
                status = DebugUIPlugin.doBuild();
            }
        }
        return status;
    }

    private static boolean doBuild() {
        ProgressMonitorDialog dialog = new ProgressMonitorDialog(DebugUIPlugin.getShell());
        try {
            dialog.run(true, true, new IRunnableWithProgress(){

                public void run(IProgressMonitor monitor) throws InvocationTargetException {
                    try {
                        ResourcesPlugin.getWorkspace().build(10, monitor);
                    }
                    catch (CoreException e) {
                        throw new InvocationTargetException(e);
                    }
                }
            });
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException e) {
            String title = DebugUIMessages.getString("DebugUIPlugin.Run/Debug_1");
            String message = DebugUIMessages.getString("DebugUIPlugin.Build_error._Check_log_for_details._2");
            Throwable t = e.getTargetException();
            DebugUIPlugin.errorDialog(DebugUIPlugin.getShell(), title, message, t);
            return false;
        }
        return true;
    }

    public static Display getStandardDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    public static Color getPreferenceColor(String type) {
        return ColorManager.getDefault().getColor(PreferenceConverter.getColor((IPreferenceStore)DebugUIPlugin.getDefault().getPreferenceStore(), (String)type));
    }

    public ConsoleDocumentManager getConsoleDocumentManager() {
        if (this.fConsoleDocumentManager == null) {
            this.fConsoleDocumentManager = new ConsoleDocumentManager();
        }
        return this.fConsoleDocumentManager;
    }

    public static String serializeDocument(Document doc) throws TransformerException, IOException {
        ByteArrayOutputStream s = new ByteArrayOutputStream();
        TransformerFactory factory = TransformerFactory.newInstance();
        Transformer transformer = factory.newTransformer();
        transformer.setOutputProperty("method", "xml");
        transformer.setOutputProperty("indent", "yes");
        DOMSource source = new DOMSource(doc);
        StreamResult outputTarget = new StreamResult(s);
        transformer.transform(source, outputTarget);
        return s.toString("UTF8");
    }

    public static Document getDocument() throws ParserConfigurationException {
        DocumentBuilderFactory dfactory = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = dfactory.newDocumentBuilder();
        Document doc = docBuilder.newDocument();
        return doc;
    }

    public static IStructuredSelection resolveSelection(IWorkbenchWindow window) {
        if (window == null) {
            return null;
        }
        ISelection selection = window.getSelectionService().getSelection();
        if (selection == null || selection.isEmpty() || !(selection instanceof IStructuredSelection)) {
            selection = null;
            IWorkbenchPage page = window.getActivePage();
            if (page == null) {
                return null;
            }
            IEditorPart editor = page.getActiveEditor();
            IEditorInput element = null;
            if (editor != null) {
                element = editor.getEditorInput();
            }
            if (selection == null && element != null) {
                selection = new StructuredSelection((Object)element);
            }
        }
        return (IStructuredSelection)selection;
    }

    public void launchAdded(ILaunch launch) {
        DebugPlugin.getDefault().getLaunchManager().removeLaunchListener((ILaunchListener)this);
        this.getConsoleDocumentManager().startup();
        if (this.fPerspectiveManager == null) {
            PerspectiveManager manager = this.getPerspectiveManager();
            manager.launchAdded(launch);
        }
        this.getLaunchConfigurationManager().startup();
    }

    public PerspectiveManager getPerspectiveManager() {
        if (this.fPerspectiveManager == null) {
            this.fPerspectiveManager = new PerspectiveManager();
            this.fPerspectiveManager.startup();
        }
        return this.fPerspectiveManager;
    }

    public void launchChanged(ILaunch launch) {
    }

    public void launchRemoved(ILaunch launch) {
    }

    public static boolean preLaunchSave() {
        String saveDirty = DebugUIPlugin.getDefault().getPreferenceStore().getString(IDebugUIConstants.PREF_SAVE_DIRTY_EDITORS_BEFORE_LAUNCH_RADIO);
        if (saveDirty.equals(IDebugUIConstants.PREF_NEVER_SAVE_DIRTY_EDITORS_BEFORE_LAUNCH)) {
            return true;
        }
        return DebugUIPlugin.saveAllEditors(saveDirty.equals(IDebugUIConstants.PREF_PROMPT_SAVE_DIRTY_EDITORS_BEFORE_LAUNCH));
    }

    public static ILaunch buildAndLaunch(ILaunchConfiguration configuration, String mode, IProgressMonitor monitor) throws CoreException {
        boolean buildBeforeLaunch = DebugUIPlugin.getDefault().getPreferenceStore().getBoolean(IDebugUIConstants.PREF_BUILD_BEFORE_LAUNCH);
        boolean autobuilding = ResourcesPlugin.getWorkspace().isAutoBuilding();
        IProgressMonitor subMonitor = monitor;
        String message = MessageFormat.format("{0}...", configuration.getName());
        if (!autobuilding && buildBeforeLaunch) {
            monitor.beginTask(message, 200);
            subMonitor = new SubProgressMonitor(monitor, 100);
            ResourcesPlugin.getWorkspace().build(10, subMonitor);
            subMonitor = new SubProgressMonitor(monitor, 100);
        } else {
            Job[] build = Platform.getJobManager().find(ResourcesPlugin.FAMILY_AUTO_BUILD);
            if (build.length == 1) {
                boolean join = DebugUIPlugin.waitForBuild(build[0].getState());
                if (join) {
                    try {
                        subMonitor = new SubProgressMonitor(monitor, 100);
                        subMonitor.beginTask(DebugUIMessages.getString("DebugUIPlugin.14"), 100);
                        build[0].join();
                    }
                    catch (InterruptedException e) {
                        throw new CoreException((IStatus)new Status(4, DebugUIPlugin.getUniqueIdentifier(), 4, DebugUIMessages.getString("DebugUIPlugin.15"), (Throwable)e));
                    }
                } else {
                    subMonitor = monitor;
                    subMonitor.beginTask(message, 100);
                }
            }
        }
        return configuration.launch(mode, subMonitor);
    }

    private static boolean waitForBuild(final int buildState) {
        String waitPreference = DebugUIPlugin.getDefault().getPreferenceStore().getString(IDebugUIConstants.PREF_WAIT_FOR_BUILD);
        if ("always".equals(waitPreference)) {
            return true;
        }
        if ("never".equals(waitPreference)) {
            return false;
        }
        final boolean[] wait = new boolean[1];
        Display.getDefault().syncExec(new Runnable(){

            public void run() {
                String message = null;
                if (buildState == 4) {
                    message = DebugUIMessages.getString("DebugUIPlugin.16");
                } else if (buildState == 2) {
                    message = DebugUIMessages.getString("DebugUIPlugin.17");
                }
                wait[0] = message != null ? AlwaysNeverDialog.openQuestion(DebugUIPlugin.getShell(), DebugUIMessages.getString("DebugUIPlugin.18"), message, IDebugUIConstants.PREF_WAIT_FOR_BUILD, DebugUIPlugin.getDefault().getPreferenceStore()) : false;
            }
        });
        return wait[0];
    }
}

