/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.debug.internal.ui;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashMap;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.debug.internal.ui.DebugUIPlugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;

public class DebugPluginImages {
    private static ImageRegistry imageRegistry;
    private static HashMap imageDescriptors;
    private static final String ATTR_LAUNCH_CONFIG_TYPE_ICON = "icon";
    private static final String ATTR_LAUNCH_CONFIG_TYPE_ID = "configTypeID";
    private static URL ICON_BASE_URL;
    private static final String CTOOL = "ctool16/";
    private static final String LOCALTOOL = "clcl16/";
    private static final String DLCL = "dlcl16/";
    private static final String ELCL = "elcl16/";
    private static final String OBJECT = "obj16/";
    private static final String WIZBAN = "wizban/";
    private static final String OVR = "ovr16/";
    private static final String VIEW = "cview16/";

    static {
        ICON_BASE_URL = null;
        String pathSuffix = "icons/full/";
        try {
            ICON_BASE_URL = new URL(DebugUIPlugin.getDefault().getDescriptor().getInstallURL(), pathSuffix);
        }
        catch (MalformedURLException malformedURLException) {}
    }

    private static void declareImages() {
        DebugPluginImages.declareRegistryImage("IMG_ACT_DEBUG", "ctool16/debug_exc.gif");
        DebugPluginImages.declareRegistryImage("IMG_ACT_RUN", "ctool16/run_exc.gif");
        DebugPluginImages.declareRegistryImage("IMG_ACT_SYNCED", "clcl16/synced.gif");
        DebugPluginImages.declareRegistryImage("IMG_LCL_CHANGE_VARIABLE_VALUE", "clcl16/changevariablevalue_co.gif");
        DebugPluginImages.declareRegistryImage("IMG_DLCL_CHANGE_VARIABLE_VALUE", "dlcl16/changevariablevalue_co.gif");
        DebugPluginImages.declareRegistryImage("IMG_ELCL_CHANGE_VARIABLE_VALUE", "elcl16/changevariablevalue_co.gif");
        DebugPluginImages.declareRegistryImage("IMG_LCL_CONTENT_ASSIST", "clcl16/metharg_obj.gif");
        DebugPluginImages.declareRegistryImage("IMG_DLCL_CONTENT_ASSIST", "dlcl16/metharg_obj.gif");
        DebugPluginImages.declareRegistryImage("IMG_ELCL_CONTENT_ASSIST", "elcl16/metharg_obj.gif");
        DebugPluginImages.declareRegistryImage("IMG_LCL_DETAIL_PANE", "clcl16/toggledetailpane_co.gif");
        DebugPluginImages.declareRegistryImage("IMG_LCL_DETAIL_PANE_UNDER", "clcl16/det_pane_under.gif");
        DebugPluginImages.declareRegistryImage("IMG_LCL_DETAIL_PANE_RIGHT", "clcl16/det_pane_right.gif");
        DebugPluginImages.declareRegistryImage("IMG_LCL_DETAIL_PANE_HIDE", "clcl16/det_pane_hide.gif");
        DebugPluginImages.declareRegistryImage("IMG_LCL_LOCK", "clcl16/lock_co.gif");
        DebugPluginImages.declareRegistryImage("IMG_LCL_TYPE_NAMES", "clcl16/tnames_co.gif");
        DebugPluginImages.declareRegistryImage("IMG_LCL_DISCONNECT", "clcl16/disconnect_co.gif");
        DebugPluginImages.declareRegistryImage("IMG_LCL_REMOVE_ALL", "clcl16/rem_all_co.gif");
        DebugPluginImages.declareRegistryImage("IMG_LCL_SHOW_LOGICAL_STRUCTURE", "clcl16/var_cntnt_prvdr.gif");
        DebugPluginImages.declareRegistryImage("IMG_LCL_COLLAPSE_ALL", "clcl16/collapseall.gif");
        DebugPluginImages.declareRegistryImage("IMG_LCL_TERMINATE", "clcl16/terminate_co.gif");
        DebugPluginImages.declareRegistryImage("IMG_DLCL_DETAIL_PANE", "dlcl16/toggledetailpane_co.gif");
        DebugPluginImages.declareRegistryImage("IMG_DLCL_DETAIL_PANE_UNDER", "dlcl16/det_pane_under.gif");
        DebugPluginImages.declareRegistryImage("IMG_DLCL_DETAIL_PANE_RIGHT", "dlcl16/det_pane_right.gif");
        DebugPluginImages.declareRegistryImage("IMG_DLCL_DETAIL_PANE_HIDE", "dlcl16/det_pane_hide.gif");
        DebugPluginImages.declareRegistryImage("IMG_DLCL_LOCK", "dlcl16/lock_co.gif");
        DebugPluginImages.declareRegistryImage("IMG_DLCL_TYPE_NAMES", "dlcl16/tnames_co.gif");
        DebugPluginImages.declareRegistryImage("IMG_DLCL_SHOW_LOGICAL_STRUCTURE", "dlcl16/var_cntnt_prvdr.gif");
        DebugPluginImages.declareRegistryImage("IMG_DLCL_COLLAPSE_ALL", "dlcl16/collapseall.gif");
        DebugPluginImages.declareRegistryImage("IMG_DLCL_TERMINATE", "dlcl16/terminate_co.gif");
        DebugPluginImages.declareRegistryImage("IMG_DLCL_REMOVE_ALL", "dlcl16/rem_all_co.gif");
        DebugPluginImages.declareRegistryImage("IMG_ELCL_DETAIL_PANE", "elcl16/toggledetailpane_co.gif");
        DebugPluginImages.declareRegistryImage("IMG_ELCL_DETAIL_PANE_UNDER", "elcl16/det_pane_under.gif");
        DebugPluginImages.declareRegistryImage("IMG_ELCL_DETAIL_PANE_RIGHT", "elcl16/det_pane_right.gif");
        DebugPluginImages.declareRegistryImage("IMG_ELCL_DETAIL_PANE_HIDE", "elcl16/det_pane_hide.gif");
        DebugPluginImages.declareRegistryImage("IMG_ELCL_LOCK", "elcl16/lock_co.gif");
        DebugPluginImages.declareRegistryImage("IMG_ELCL_TYPE_NAMES", "elcl16/tnames_co.gif");
        DebugPluginImages.declareRegistryImage("IMG_ELCL_SHOW_LOGICAL_STRUCTURE", "elcl16/var_cntnt_prvdr.gif");
        DebugPluginImages.declareRegistryImage("IMG_ELCL_COLLAPSE_ALL", "elcl16/collapseall.gif");
        DebugPluginImages.declareRegistryImage("IMG_ELCL_TERMINATE", "elcl16/terminate_co.gif");
        DebugPluginImages.declareRegistryImage("IMG_OBJS_LAUNCH_DEBUG", "obj16/ldebug_obj.gif");
        DebugPluginImages.declareRegistryImage("IMG_OBJS_LAUNCH_RUN", "obj16/lrun_obj.gif");
        DebugPluginImages.declareRegistryImage("IMG_OBJS_LAUNCH_RUN_TERMINATED", "obj16/terminatedlaunch_obj.gif");
        DebugPluginImages.declareRegistryImage("IMG_OBJS_DEBUG_TARGET", "obj16/debugt_obj.gif");
        DebugPluginImages.declareRegistryImage("IMG_OBJS_DEBUG_TARGET_SUSPENDED", "obj16/debugts_obj.gif");
        DebugPluginImages.declareRegistryImage("IMG_OBJS_DEBUG_TARGET_TERMINATED", "obj16/debugtt_obj.gif");
        DebugPluginImages.declareRegistryImage("IMG_OBJS_THREAD_RUNNING", "obj16/thread_obj.gif");
        DebugPluginImages.declareRegistryImage("IMG_OBJS_THREAD_SUSPENDED", "obj16/threads_obj.gif");
        DebugPluginImages.declareRegistryImage("IMG_OBJS_THREAD_TERMINATED", "obj16/threadt_obj.gif");
        DebugPluginImages.declareRegistryImage("IMG_OBJS_STACKFRAME", "obj16/stckframe_obj.gif");
        DebugPluginImages.declareRegistryImage("IMG_OBJS_STACKFRAME_RUNNING", "obj16/stckframe_running_obj.gif");
        DebugPluginImages.declareRegistryImage("IMG_OBJS_VARIABLE", "obj16/genericvariable_obj.gif");
        DebugPluginImages.declareRegistryImage("IMG_OBJS_BREAKPOINT", "obj16/brkp_obj.gif");
        DebugPluginImages.declareRegistryImage("IMG_OBJS_BREAKPOINT_DISABLED", "obj16/brkpd_obj.gif");
        DebugPluginImages.declareRegistryImage("IMG_OBJS_OS_PROCESS", "obj16/osprc_obj.gif");
        DebugPluginImages.declareRegistryImage("IMG_OBJS_OS_PROCESS_TERMINATED", "obj16/osprct_obj.gif");
        DebugPluginImages.declareRegistryImage("IMG_OBJS_EXPRESSION", "obj16/expression_obj.gif");
        DebugPluginImages.declareRegistryImage("IMG_OBJS_INSTRUCTION_POINTER_TOP", "obj16/inst_ptr_top.gif");
        DebugPluginImages.declareRegistryImage("IMG_OBJS_INSTRUCTION_POINTER", "obj16/inst_ptr.gif");
        DebugPluginImages.declareRegistryImage("IMG_OBJS_ARRAY_PARTITION", "obj16/arraypartition_obj.gif");
        DebugPluginImages.declareRegistryImage("IMG_OBJS_COMMON_TAB", "obj16/common_tab.gif");
        DebugPluginImages.declareRegistryImage("IMG_OBJS_REFRESH_TAB", "obj16/refresh_tab.gif");
        DebugPluginImages.declareRegistryImage("IMG_OBJS_PERSPECTIVE_TAB", "obj16/persp_tab.gif");
        DebugPluginImages.declareRegistryImage("IMG_OBJS_ENVIRONMENT", "obj16/environment_obj.gif");
        DebugPluginImages.declareRegistryImage("IMG_VIEW_BREAKPOINTS", "cview16/breakpoint_view.gif");
        DebugPluginImages.declareRegistryImage("IMG_VIEW_EXPRESSIONS", "cview16/watchlist_view.gif");
        DebugPluginImages.declareRegistryImage("IMG_VIEW_LAUNCHES", "cview16/debug_view.gif");
        DebugPluginImages.declareRegistryImage("IMG_VIEW_VARIABLES", "cview16/variable_view.gif");
        DebugPluginImages.declareRegistryImage("IMG_PERSPECTIVE_DEBUG", "cview16/debug_persp.gif");
        DebugPluginImages.declareRegistryImage("IMG_WIZBAN_DEBUG", "wizban/debug_wiz.gif");
        DebugPluginImages.declareRegistryImage("IMG_WIZBAN_RUN", "wizban/run_wiz.gif");
        DebugPluginImages.declareRegistryImage("IMG_OVR_ERROR", "ovr16/error.gif");
        DebugPluginImages.declareRegistryImage("IMG_OVR_TRANSPARENT", "ovr16/transparent.gif");
        IPluginDescriptor pluginDescriptor = DebugUIPlugin.getDefault().getDescriptor();
        IExtensionPoint extensionPoint = pluginDescriptor.getExtensionPoint("launchConfigurationTypeImages");
        IConfigurationElement[] configElements = extensionPoint.getConfigurationElements();
        int i = 0;
        while (i < configElements.length) {
            IConfigurationElement configElement = configElements[i];
            URL iconURL = configElement.getDeclaringExtension().getDeclaringPluginDescriptor().getInstallURL();
            String iconPath = configElement.getAttribute(ATTR_LAUNCH_CONFIG_TYPE_ICON);
            ImageDescriptor imageDescriptor = ImageDescriptor.getMissingImageDescriptor();
            try {
                iconURL = new URL(iconURL, iconPath);
                imageDescriptor = ImageDescriptor.createFromURL((URL)iconURL);
            }
            catch (MalformedURLException mue) {
                DebugUIPlugin.log(mue);
            }
            String configTypeID = configElement.getAttribute(ATTR_LAUNCH_CONFIG_TYPE_ID);
            if (configTypeID == null) {
                configTypeID = configElement.getAttribute("type");
            }
            imageRegistry.put(configTypeID, imageDescriptor);
            imageDescriptors.put(configTypeID, imageDescriptor);
            ++i;
        }
    }

    private static final void declareRegistryImage(String key, String path) {
        ImageDescriptor desc = ImageDescriptor.getMissingImageDescriptor();
        try {
            desc = ImageDescriptor.createFromURL((URL)DebugPluginImages.makeIconFileURL(path));
        }
        catch (MalformedURLException me) {
            DebugUIPlugin.log(me);
        }
        imageRegistry.put(key, desc);
        imageDescriptors.put(key, desc);
    }

    public static ImageRegistry getImageRegistry() {
        if (imageRegistry == null) {
            DebugPluginImages.initializeImageRegistry();
        }
        return imageRegistry;
    }

    public static ImageRegistry initializeImageRegistry() {
        imageRegistry = new ImageRegistry(DebugUIPlugin.getStandardDisplay());
        imageDescriptors = new HashMap(30);
        DebugPluginImages.declareImages();
        return imageRegistry;
    }

    public static Image getImage(String key) {
        return DebugPluginImages.getImageRegistry().get(key);
    }

    public static ImageDescriptor getImageDescriptor(String key) {
        if (imageDescriptors == null) {
            DebugPluginImages.initializeImageRegistry();
        }
        return (ImageDescriptor)imageDescriptors.get(key);
    }

    private static URL makeIconFileURL(String iconPath) throws MalformedURLException {
        if (ICON_BASE_URL == null) {
            throw new MalformedURLException();
        }
        return new URL(ICON_BASE_URL, iconPath);
    }
}

