/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ant.core;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.StringTokenizer;
import org.eclipse.ant.core.AntCorePlugin;
import org.eclipse.ant.core.IAntClasspathEntry;
import org.eclipse.ant.core.Property;
import org.eclipse.ant.core.Task;
import org.eclipse.ant.core.Type;
import org.eclipse.ant.internal.core.AntClasspathEntry;
import org.eclipse.ant.internal.core.InternalCoreAntMessages;
import org.eclipse.core.internal.plugins.PluginClassLoader;
import org.eclipse.core.internal.plugins.PluginDescriptor;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.ILibrary;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.IPluginPrerequisite;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;

public class AntCorePreferences
implements Preferences.IPropertyChangeListener {
    private List defaultTasks;
    private List defaultTypes;
    private List extraClasspathURLs;
    private List defaultProperties;
    private IAntClasspathEntry[] defaultAntHomeEntries;
    private Task[] customTasks;
    private Task[] oldCustomTasks;
    private Type[] customTypes;
    private Type[] oldCustomTypes;
    private IAntClasspathEntry[] antHomeEntries;
    private IAntClasspathEntry[] additionalEntries;
    private Property[] customProperties;
    private Property[] oldCustomProperties;
    private String[] customPropertyFiles;
    private List pluginClassLoaders;
    private ClassLoader[] orderedPluginClassLoaders;
    private String antHome;
    private boolean runningHeadless = false;

    protected AntCorePreferences(List defaultTasks, List defaultExtraClasspath, List defaultTypes, boolean headless) {
        this(defaultTasks, defaultExtraClasspath, defaultTypes, Collections.EMPTY_LIST, headless);
    }

    protected AntCorePreferences(List defaultTasks, List defaultExtraClasspath, List defaultTypes, List defaultProperties, boolean headless) {
        this.runningHeadless = headless;
        this.initializePluginClassLoaders();
        this.extraClasspathURLs = new ArrayList(20);
        this.defaultTasks = this.computeDefaultTasks(defaultTasks);
        this.defaultTypes = this.computeDefaultTypes(defaultTypes);
        this.computeDefaultExtraClasspathEntries(defaultExtraClasspath);
        this.computeDefaultProperties(defaultProperties);
        this.restoreCustomObjects();
    }

    public void propertyChange(Preferences.PropertyChangeEvent event) {
        Preferences prefs = AntCorePlugin.getPlugin().getPluginPreferences();
        String property = event.getProperty();
        if (property.equals("tasks") || property.startsWith("task.")) {
            this.restoreTasks(prefs);
        } else if (property.equals("types") || property.startsWith("type.")) {
            this.restoreTypes(prefs);
        } else if (property.equals("ant_home_entries")) {
            this.restoreAntHomeEntries(prefs);
        } else if (property.equals("additional_entries")) {
            this.restoreAdditionalEntries(prefs);
        } else if (property.equals("ant_home")) {
            this.restoreAntHome(prefs);
        } else if (property.equals("properties") || property.startsWith("property.")) {
            this.restoreCustomProperties(prefs);
        } else if (property.equals("propertyfiles")) {
            this.restoreCustomPropertyFiles(prefs);
        }
    }

    private void restoreCustomObjects() {
        Preferences prefs = AntCorePlugin.getPlugin().getPluginPreferences();
        this.restoreAntHome(prefs);
        this.restoreTasks(prefs);
        this.restoreTypes(prefs);
        this.restoreAntHomeEntries(prefs);
        this.restoreAdditionalEntries(prefs);
        this.restoreCustomProperties(prefs);
        this.restoreCustomPropertyFiles(prefs);
        prefs.addPropertyChangeListener((Preferences.IPropertyChangeListener)this);
    }

    private void restoreTasks(Preferences prefs) {
        String tasks = prefs.getString("tasks");
        this.customTasks = tasks.equals("") ? new Task[0] : this.extractTasks(prefs, this.getArrayFromString(tasks));
    }

    private void restoreTypes(Preferences prefs) {
        String types = prefs.getString("types");
        this.customTypes = types.equals("") ? new Type[0] : this.extractTypes(prefs, this.getArrayFromString(types));
    }

    private void restoreAntHomeEntries(Preferences prefs) {
        String entries = prefs.getString("ant_urls");
        if (!entries.equals("")) {
            prefs.setToDefault("ant_urls");
            this.antHomeEntries = this.migrateURLEntries(this.getArrayFromString(entries));
            return;
        }
        entries = prefs.getString("ant_home_entries");
        this.antHomeEntries = entries.equals("") ? this.getDefaultAntHomeEntries() : this.extractEntries(this.getArrayFromString(entries));
    }

    private void restoreAdditionalEntries(Preferences prefs) {
        IAntClasspathEntry toolsJarEntry;
        String entries = prefs.getString("urls");
        if (!entries.equals("")) {
            prefs.setToDefault("urls");
            this.additionalEntries = this.migrateURLEntries(this.getArrayFromString(entries));
            return;
        }
        entries = prefs.getString("additional_entries");
        this.additionalEntries = entries.equals("") ? ((toolsJarEntry = this.getToolsJarEntry()) == null ? new IAntClasspathEntry[0] : new IAntClasspathEntry[]{toolsJarEntry}) : this.extractEntries(this.getArrayFromString(entries));
    }

    private IAntClasspathEntry[] migrateURLEntries(String[] urlEntries) {
        ArrayList<AntClasspathEntry> result = new ArrayList<AntClasspathEntry>(urlEntries.length);
        int i = 0;
        while (i < urlEntries.length) {
            block3: {
                URL url;
                try {
                    url = new URL(urlEntries[i]);
                }
                catch (MalformedURLException malformedURLException) {
                    break block3;
                }
                result.add(new AntClasspathEntry(url.getFile()));
            }
            ++i;
        }
        return result.toArray(new IAntClasspathEntry[result.size()]);
    }

    private void restoreAntHome(Preferences prefs) {
        this.antHome = prefs.getString("ant_home");
        if (this.antHome == null || this.antHome.length() == 0) {
            this.antHome = this.getDefaultAntHome();
        }
    }

    public String getDefaultAntHome() {
        IAntClasspathEntry[] entries = this.getDefaultAntHomeEntries();
        if (entries.length > 0) {
            URL antjar = entries[0].getEntryURL();
            Path antHomePath = new Path(antjar.getFile());
            antHomePath = antHomePath.removeLastSegments(2);
            return antHomePath.toFile().getAbsolutePath();
        }
        return null;
    }

    private void restoreCustomProperties(Preferences prefs) {
        String properties = prefs.getString("properties");
        this.customProperties = properties.equals("") ? new Property[0] : this.extractProperties(prefs, this.getArrayFromString(properties));
    }

    private void restoreCustomPropertyFiles(Preferences prefs) {
        String propertyFiles = prefs.getString("propertyfiles");
        this.customPropertyFiles = propertyFiles.equals("") ? new String[0] : this.getArrayFromString(propertyFiles);
    }

    protected Task[] extractTasks(Preferences prefs, String[] tasks) {
        ArrayList<Task> result = new ArrayList<Task>(tasks.length);
        int i = 0;
        while (i < tasks.length) {
            String taskName = tasks[i];
            String[] values = this.getArrayFromString(prefs.getString("task." + taskName));
            if (values.length >= 2) {
                Task task = new Task();
                task.setTaskName(taskName);
                task.setClassName(values[0]);
                String library = values[1];
                if (library.startsWith("file:")) {
                    library = library.substring(5);
                }
                task.setLibraryEntry(new AntClasspathEntry(library));
                result.add(task);
            }
            ++i;
        }
        return result.toArray(new Task[result.size()]);
    }

    protected Type[] extractTypes(Preferences prefs, String[] types) {
        ArrayList<Type> result = new ArrayList<Type>(types.length);
        int i = 0;
        while (i < types.length) {
            String typeName = types[i];
            String[] values = this.getArrayFromString(prefs.getString("type." + typeName));
            if (values.length >= 2) {
                Type type = new Type();
                type.setTypeName(typeName);
                type.setClassName(values[0]);
                String library = values[1];
                if (library.startsWith("file:")) {
                    library = library.substring(5);
                }
                type.setLibraryEntry(new AntClasspathEntry(library));
                result.add(type);
            }
            ++i;
        }
        return result.toArray(new Type[result.size()]);
    }

    protected Property[] extractProperties(Preferences prefs, String[] properties) {
        Property[] result = new Property[properties.length];
        int i = 0;
        while (i < properties.length) {
            String propertyName = properties[i];
            String[] values = this.getArrayFromString(prefs.getString("property." + propertyName));
            if (values.length >= 1) {
                Property property = new Property();
                property.setName(propertyName);
                property.setValue(values[0]);
                result[i] = property;
            }
            ++i;
        }
        return result;
    }

    private IAntClasspathEntry[] extractEntries(String[] entries) {
        IAntClasspathEntry[] result = new IAntClasspathEntry[entries.length];
        int i = 0;
        while (i < entries.length) {
            result[i] = new AntClasspathEntry(entries[i]);
            ++i;
        }
        return result;
    }

    public URL[] getDefaultAntURLs() {
        IAntClasspathEntry[] entries = this.getDefaultAntHomeEntries();
        ArrayList<URL> result = new ArrayList<URL>(3);
        int i = 0;
        while (i < entries.length) {
            IAntClasspathEntry entry = entries[i];
            result.add(entry.getEntryURL());
            ++i;
        }
        URL toolsURL = this.getToolsJarURL();
        if (toolsURL != null) {
            result.add(toolsURL);
        }
        return result.toArray(new URL[result.size()]);
    }

    public IAntClasspathEntry[] getDefaultAntHomeEntries() {
        if (this.defaultAntHomeEntries == null) {
            ArrayList result = new ArrayList(2);
            Plugin antPlugin = Platform.getPlugin((String)"org.apache.ant");
            if (antPlugin != null) {
                IPluginDescriptor descriptor = antPlugin.getDescriptor();
                this.addLibraries(descriptor, result);
            }
            this.defaultAntHomeEntries = result.toArray(new IAntClasspathEntry[result.size()]);
        }
        return this.defaultAntHomeEntries;
    }

    public URL[] getAntURLs() {
        int extra = 0;
        IAntClasspathEntry entry = this.getToolsJarEntry();
        if (entry != null) {
            ++extra;
        }
        URL[] urls = new URL[this.antHomeEntries.length + extra];
        int i = 0;
        while (i < this.antHomeEntries.length) {
            URL url = this.antHomeEntries[i].getEntryURL();
            if (url != null) {
                urls[i] = url;
            }
            ++i;
        }
        if (extra > 0) {
            urls[i] = entry.getEntryURL();
        }
        return urls;
    }

    protected List computeDefaultTasks(List tasks) {
        ArrayList<Task> result = new ArrayList<Task>(tasks.size());
        Iterator iterator = tasks.iterator();
        while (iterator.hasNext()) {
            Status status;
            boolean headlessType;
            String headless;
            IConfigurationElement element = (IConfigurationElement)iterator.next();
            if (this.runningHeadless && (headless = element.getAttribute("headless")) != null && !(headlessType = Boolean.valueOf(headless).booleanValue())) continue;
            Task task = new Task();
            task.setTaskName(element.getAttribute("name"));
            task.setClassName(element.getAttribute("class"));
            String library = element.getAttribute("library");
            if (library == null) {
                Status status2 = new Status(4, "org.eclipse.ant.core", 3, MessageFormat.format(InternalCoreAntMessages.getString("AntCorePreferences.Library_not_specified_for__{0}_4"), task.getTaskName()), null);
                AntCorePlugin.getPlugin().getLog().log((IStatus)status2);
                continue;
            }
            IPluginDescriptor descriptor = element.getDeclaringExtension().getDeclaringPluginDescriptor();
            task.setPluginLabel(descriptor.getLabel());
            try {
                URL url = Platform.asLocalURL((URL)new URL(descriptor.getInstallURL(), library));
                if (new File(url.getPath()).exists()) {
                    if (!this.extraClasspathURLs.contains(url)) {
                        this.extraClasspathURLs.add(url);
                    }
                    result.add(task);
                    this.addPluginClassLoader(descriptor.getPluginClassLoader());
                    task.setLibraryEntry(new AntClasspathEntry(url.getFile()));
                    continue;
                }
                status = new Status(4, "org.eclipse.ant.core", 3, MessageFormat.format(InternalCoreAntMessages.getString("AntCorePreferences.No_library_for_task"), url.toExternalForm(), descriptor.getLabel()), null);
                AntCorePlugin.getPlugin().getLog().log((IStatus)status);
            }
            catch (Exception e) {
                status = new Status(4, "org.eclipse.ant.core", 2, InternalCoreAntMessages.getString("AntCorePreferences.Malformed_URL._1"), (Throwable)e);
                AntCorePlugin.getPlugin().getLog().log((IStatus)status);
            }
        }
        return result;
    }

    protected List computeDefaultTypes(List types) {
        ArrayList<Type> result = new ArrayList<Type>(types.size());
        Iterator iterator = types.iterator();
        while (iterator.hasNext()) {
            Status status;
            boolean headlessTask;
            String headless;
            IConfigurationElement element = (IConfigurationElement)iterator.next();
            if (this.runningHeadless && (headless = element.getAttribute("headless")) != null && !(headlessTask = Boolean.valueOf(headless).booleanValue())) continue;
            Type type = new Type();
            IPluginDescriptor descriptor = element.getDeclaringExtension().getDeclaringPluginDescriptor();
            type.setPluginLabel(descriptor.getLabel());
            type.setTypeName(element.getAttribute("name"));
            type.setClassName(element.getAttribute("class"));
            String library = element.getAttribute("library");
            if (library == null) {
                Status status2 = new Status(4, "org.eclipse.ant.core", 3, MessageFormat.format(InternalCoreAntMessages.getString("AntCorePreferences.Library_not_specified_for__{0}_4"), type.getTypeName()), null);
                AntCorePlugin.getPlugin().getLog().log((IStatus)status2);
                continue;
            }
            try {
                URL url = Platform.asLocalURL((URL)new URL(descriptor.getInstallURL(), library));
                if (new File(url.getPath()).exists()) {
                    if (!this.extraClasspathURLs.contains(url)) {
                        this.extraClasspathURLs.add(url);
                    }
                    result.add(type);
                    this.addPluginClassLoader(descriptor.getPluginClassLoader());
                    type.setLibraryEntry(new AntClasspathEntry(url.getFile()));
                    continue;
                }
                status = new Status(4, "org.eclipse.ant.core", 3, MessageFormat.format(InternalCoreAntMessages.getString("AntCorePreferences.No_library_for_type"), url.toExternalForm(), descriptor.getLabel()), null);
                AntCorePlugin.getPlugin().getLog().log((IStatus)status);
            }
            catch (Exception e) {
                status = new Status(4, "org.eclipse.ant.core", 2, InternalCoreAntMessages.getString("AntCorePreferences.Malformed_URL._1"), (Throwable)e);
                AntCorePlugin.getPlugin().getLog().log((IStatus)status);
            }
        }
        return result;
    }

    protected void computeDefaultExtraClasspathEntries(List entries) {
        Iterator iterator = entries.iterator();
        while (iterator.hasNext()) {
            Status status;
            boolean headlessEntry;
            String headless;
            IConfigurationElement element = (IConfigurationElement)iterator.next();
            if (this.runningHeadless && (headless = element.getAttribute("headless")) != null && !(headlessEntry = Boolean.valueOf(headless).booleanValue())) continue;
            String library = element.getAttribute("library");
            IPluginDescriptor descriptor = element.getDeclaringExtension().getDeclaringPluginDescriptor();
            try {
                URL url = Platform.asLocalURL((URL)new URL(descriptor.getInstallURL(), library));
                if (new File(url.getPath()).exists()) {
                    if (!this.extraClasspathURLs.contains(url)) {
                        this.extraClasspathURLs.add(url);
                    }
                    this.addPluginClassLoader(descriptor.getPluginClassLoader());
                    continue;
                }
                status = new Status(4, "org.eclipse.ant.core", 3, MessageFormat.format(InternalCoreAntMessages.getString("AntCorePreferences.No_library_for_extraClasspathEntry"), url.toExternalForm(), descriptor.getLabel()), null);
                AntCorePlugin.getPlugin().getLog().log((IStatus)status);
            }
            catch (Exception e) {
                status = new Status(4, "org.eclipse.ant.core", 2, InternalCoreAntMessages.getString("AntCorePreferences.Malformed_URL._1"), (Throwable)e);
                AntCorePlugin.getPlugin().getLog().log((IStatus)status);
            }
        }
    }

    private void computeDefaultProperties(List properties) {
        this.defaultProperties = new ArrayList(properties.size());
        Iterator iterator = properties.iterator();
        while (iterator.hasNext()) {
            IPluginDescriptor descriptor;
            Property property;
            String name;
            boolean headlessProperty;
            String headless;
            IConfigurationElement element = (IConfigurationElement)iterator.next();
            if (this.runningHeadless && (headless = element.getAttribute("headless")) != null && !(headlessProperty = Boolean.valueOf(headless).booleanValue()) || (name = element.getAttribute("name")) == null) continue;
            String value = element.getAttribute("value");
            if (value != null) {
                property = new Property(name, value);
                descriptor = element.getDeclaringExtension().getDeclaringPluginDescriptor();
                property.setPluginLabel(descriptor.getLabel());
                this.defaultProperties.add(property);
                continue;
            }
            property = new Property();
            property.setName(name);
            descriptor = element.getDeclaringExtension().getDeclaringPluginDescriptor();
            property.setPluginLabel(descriptor.getLabel());
            String className = element.getAttribute("class");
            property.setValueProvider(className, descriptor.getPluginClassLoader());
            this.defaultProperties.add(property);
        }
    }

    public IAntClasspathEntry getToolsJarEntry(IPath javaHomePath) {
        File tools;
        if (javaHomePath.lastSegment().equalsIgnoreCase("jre")) {
            javaHomePath = javaHomePath.removeLastSegments(1);
        }
        if (!(tools = (javaHomePath = javaHomePath.append("lib").append("tools.jar")).toFile()).exists()) {
            javaHomePath = javaHomePath.removeLastSegments(1);
            tools = (javaHomePath = javaHomePath.append("classes.zip")).toFile();
            if (!tools.exists()) {
                return null;
            }
        }
        return new AntClasspathEntry(tools.getAbsolutePath());
    }

    public URL getToolsJarURL() {
        Path path = new Path(System.getProperty("java.home"));
        return this.getToolsJarEntry((IPath)path).getEntryURL();
    }

    public IAntClasspathEntry getToolsJarEntry() {
        Path path = new Path(System.getProperty("java.home"));
        return this.getToolsJarEntry((IPath)path);
    }

    private void addLibraries(IPluginDescriptor source, List destination) {
        URL root = source.getInstallURL();
        ILibrary[] libraries = source.getRuntimeLibraries();
        int i = 0;
        while (i < libraries.length) {
            try {
                URL url = new URL(root, libraries[i].getPath().toString());
                destination.add(new AntClasspathEntry(Platform.asLocalURL((URL)url).getFile()));
            }
            catch (Exception e) {
                Status status = new Status(4, "org.eclipse.ant.core", 2, InternalCoreAntMessages.getString("AntCorePreferences.Malformed_URL._1"), (Throwable)e);
                AntCorePlugin.getPlugin().getLog().log((IStatus)status);
            }
            ++i;
        }
    }

    protected void addPluginClassLoader(ClassLoader loader) {
        if (!this.pluginClassLoaders.contains(loader)) {
            this.pluginClassLoaders.add(loader);
        }
    }

    public URL[] getExtraClasspathURLs() {
        return this.extraClasspathURLs.toArray(new URL[this.extraClasspathURLs.size()]);
    }

    public URL[] getURLs() {
        IAntClasspathEntry entry;
        int i;
        ArrayList<URL> result = new ArrayList<URL>(50);
        if (this.antHomeEntries != null) {
            i = 0;
            while (i < this.antHomeEntries.length) {
                entry = this.antHomeEntries[i];
                result.add(entry.getEntryURL());
                ++i;
            }
        }
        if (this.additionalEntries != null && this.additionalEntries.length > 0) {
            i = 0;
            while (i < this.additionalEntries.length) {
                entry = this.additionalEntries[i];
                result.add(entry.getEntryURL());
                ++i;
            }
        }
        if (this.extraClasspathURLs != null) {
            result.addAll(this.extraClasspathURLs);
        }
        return result.toArray(new URL[result.size()]);
    }

    public IAntClasspathEntry[] getClasspathEntries() {
        ArrayList<IAntClasspathEntry> result = new ArrayList<IAntClasspathEntry>(50);
        if (this.antHomeEntries != null) {
            result.addAll(Arrays.asList(this.antHomeEntries));
        }
        if (this.additionalEntries != null && this.additionalEntries.length > 0) {
            result.addAll(Arrays.asList(this.additionalEntries));
        }
        if (this.extraClasspathURLs != null) {
            result.addAll(this.extraClasspathURLs);
        }
        return result.toArray(new IAntClasspathEntry[result.size()]);
    }

    protected ClassLoader[] getPluginClassLoaders() {
        if (this.orderedPluginClassLoaders == null) {
            Iterator classLoaders = this.pluginClassLoaders.iterator();
            HashMap<String, PluginClassLoader> idToLoader = new HashMap<String, PluginClassLoader>(this.pluginClassLoaders.size());
            IPluginDescriptor[] descriptors = new IPluginDescriptor[this.pluginClassLoaders.size()];
            int i = 0;
            while (classLoaders.hasNext()) {
                PluginClassLoader loader = (PluginClassLoader)classLoaders.next();
                PluginDescriptor descriptor = loader.getPluginDescriptor();
                idToLoader.put(descriptor.getUniqueIdentifier(), loader);
                descriptors[i] = descriptor;
                ++i;
            }
            String[] ids = this.computePrerequisiteOrderPlugins(descriptors);
            this.orderedPluginClassLoaders = new ClassLoader[this.pluginClassLoaders.size()];
            int j = 0;
            while (j < ids.length) {
                String id = ids[j];
                this.orderedPluginClassLoaders[j] = (ClassLoader)idToLoader.get(id);
                ++j;
            }
        }
        return this.orderedPluginClassLoaders;
    }

    private String[] computePrerequisiteOrderPlugins(IPluginDescriptor[] plugins) {
        ArrayList<String[]> prereqs = new ArrayList<String[]>(9);
        HashSet<String> pluginList = new HashSet<String>(plugins.length);
        int i = 0;
        while (i < plugins.length) {
            pluginList.add(plugins[i].getUniqueIdentifier());
            ++i;
        }
        i = 0;
        while (i < plugins.length) {
            boolean boot = false;
            boolean runtime = false;
            boolean found = false;
            IPluginPrerequisite[] prereqList = plugins[i].getPluginPrerequisites();
            if (prereqList != null) {
                int j = 0;
                while (j < prereqList.length) {
                    String prereq = prereqList[j].getUniqueIdentifier();
                    boot = boot || prereq.equals("org.eclipse.core.boot");
                    boolean bl = runtime = runtime || prereq.equals("org.eclipse.core.runtime");
                    if (pluginList.contains(prereq)) {
                        found = true;
                        prereqs.add(new String[]{plugins[i].getUniqueIdentifier(), prereq});
                    }
                    ++j;
                }
            }
            if (!found) {
                String[] stringArray = new String[2];
                stringArray[0] = plugins[i].getUniqueIdentifier();
                prereqs.add(stringArray);
            }
            if (!plugins[i].getUniqueIdentifier().equals("org.apache.xerces")) {
                if (!boot && pluginList.contains("org.eclipse.core.boot") && !plugins[i].getUniqueIdentifier().equals("org.eclipse.core.boot")) {
                    prereqs.add(new String[]{plugins[i].getUniqueIdentifier(), "org.eclipse.core.boot"});
                }
                if (!runtime && pluginList.contains("org.eclipse.core.runtime") && !plugins[i].getUniqueIdentifier().equals("org.eclipse.core.runtime") && !plugins[i].getUniqueIdentifier().equals("org.eclipse.core.boot")) {
                    prereqs.add(new String[]{plugins[i].getUniqueIdentifier(), "org.eclipse.core.runtime"});
                }
            }
            ++i;
        }
        String[][] prereqArray = (String[][])prereqs.toArray((T[])new String[prereqs.size()][]);
        return this.computeNodeOrder(prereqArray);
    }

    private String[] computeNodeOrder(String[][] specs) {
        Map counts = this.computeCounts(specs);
        ArrayList nodes = new ArrayList(counts.size());
        while (!counts.isEmpty()) {
            List roots = this.findRootNodes(counts);
            if (roots.isEmpty()) break;
            Iterator i = roots.iterator();
            while (i.hasNext()) {
                counts.remove(i.next());
            }
            nodes.addAll(roots);
            this.removeArcs(specs, roots, counts);
        }
        String[] result = new String[nodes.size()];
        nodes.toArray(result);
        return result;
    }

    private void removeArcs(String[][] mappings, List roots, Map counts) {
        Iterator j = roots.iterator();
        while (j.hasNext()) {
            String root = (String)j.next();
            int i = 0;
            while (i < mappings.length) {
                String input;
                Integer count;
                if (root.equals(mappings[i][1]) && (count = (Integer)counts.get(input = mappings[i][0])) != null) {
                    counts.put(input, new Integer(count - 1));
                }
                ++i;
            }
        }
    }

    private List findRootNodes(Map counts) {
        ArrayList<String> result = new ArrayList<String>(5);
        Iterator i = counts.keySet().iterator();
        while (i.hasNext()) {
            String node = (String)i.next();
            int count = (Integer)counts.get(node);
            if (count != 0) continue;
            result.add(node);
        }
        return result;
    }

    private Map computeCounts(String[][] mappings) {
        HashMap<String, Integer> counts = new HashMap<String, Integer>(5);
        int i = 0;
        while (i < mappings.length) {
            String from = mappings[i][0];
            Integer fromCount = (Integer)counts.get(from);
            String to = mappings[i][1];
            if (to == null) {
                counts.put(from, new Integer(0));
            } else {
                if ((Integer)counts.get(to) == null) {
                    counts.put(to, new Integer(0));
                }
                fromCount = fromCount == null ? new Integer(1) : new Integer(fromCount + 1);
                counts.put(from, fromCount);
            }
            ++i;
        }
        return counts;
    }

    private void initializePluginClassLoaders() {
        this.pluginClassLoaders = new ArrayList(10);
        this.pluginClassLoaders.add(Platform.getPlugin((String)"org.eclipse.ant.core").getDescriptor().getPluginClassLoader());
    }

    public List getTasks() {
        ArrayList<Task> result = new ArrayList<Task>(10);
        if (this.defaultTasks != null && !this.defaultTasks.isEmpty()) {
            result.addAll(this.defaultTasks);
        }
        if (this.customTasks != null && this.customTasks.length != 0) {
            result.addAll(Arrays.asList(this.customTasks));
        }
        return result;
    }

    public Task[] getCustomTasks() {
        return this.customTasks;
    }

    public Type[] getCustomTypes() {
        return this.customTypes;
    }

    public Property[] getCustomProperties() {
        return this.customProperties;
    }

    public List getProperties() {
        ArrayList<Property> result = new ArrayList<Property>(10);
        if (this.defaultProperties != null && !this.defaultProperties.isEmpty()) {
            result.addAll(this.defaultProperties);
        }
        if (this.customProperties != null && this.customProperties.length != 0) {
            result.addAll(Arrays.asList(this.customProperties));
        }
        return result;
    }

    public String[] getCustomPropertyFiles() {
        return this.customPropertyFiles;
    }

    public URL[] getCustomURLs() {
        URL[] urls = new URL[this.additionalEntries.length];
        int i = 0;
        while (i < this.additionalEntries.length) {
            URL url = this.additionalEntries[i].getEntryURL();
            if (url != null) {
                urls[i] = url;
            }
            ++i;
        }
        return urls;
    }

    public void setCustomTasks(Task[] tasks) {
        this.oldCustomTasks = this.customTasks;
        this.customTasks = tasks;
    }

    public void setCustomTypes(Type[] types) {
        this.oldCustomTypes = this.customTypes;
        this.customTypes = types;
    }

    public void setCustomURLs(URL[] urls) {
        this.additionalEntries = new IAntClasspathEntry[urls.length];
        int i = 0;
        while (i < urls.length) {
            URL url = urls[i];
            AntClasspathEntry entry = new AntClasspathEntry(url.getFile());
            this.additionalEntries[i] = entry;
            ++i;
        }
    }

    public void setAntURLs(URL[] urls) {
        this.antHomeEntries = new IAntClasspathEntry[urls.length];
        int i = 0;
        while (i < urls.length) {
            URL url = urls[i];
            AntClasspathEntry entry = new AntClasspathEntry(url.getFile());
            this.antHomeEntries[i] = entry;
            ++i;
        }
    }

    public void setCustomPropertyFiles(String[] paths) {
        this.customPropertyFiles = paths;
    }

    public void setCustomProperties(Property[] properties) {
        this.oldCustomProperties = this.customProperties;
        this.customProperties = properties;
    }

    public List getTypes() {
        ArrayList<Type> result = new ArrayList<Type>(10);
        if (this.defaultTypes != null && !this.defaultTypes.isEmpty()) {
            result.addAll(this.defaultTypes);
        }
        if (this.customTypes != null && this.customTypes.length != 0) {
            result.addAll(Arrays.asList(this.customTypes));
        }
        return result;
    }

    public List getDefaultTypes() {
        ArrayList result = new ArrayList(10);
        if (this.defaultTypes != null && !this.defaultTypes.isEmpty()) {
            result.addAll(this.defaultTypes);
        }
        return result;
    }

    public List getDefaultTasks() {
        ArrayList result = new ArrayList(10);
        if (this.defaultTasks != null && !this.defaultTasks.isEmpty()) {
            result.addAll(this.defaultTasks);
        }
        return result;
    }

    public List getDefaultProperties() {
        ArrayList result = new ArrayList(10);
        if (this.defaultProperties != null && !this.defaultProperties.isEmpty()) {
            result.addAll(this.defaultProperties);
        }
        return result;
    }

    protected String[] getArrayFromString(String list) {
        String separator = ",";
        if (list == null || list.trim().equals("")) {
            return new String[0];
        }
        ArrayList<String> result = new ArrayList<String>();
        StringTokenizer tokens = new StringTokenizer(list, separator);
        while (tokens.hasMoreTokens()) {
            String token = tokens.nextToken().trim();
            if (token.equals("")) continue;
            result.add(token);
        }
        return result.toArray(new String[result.size()]);
    }

    public void updatePluginPreferences() {
        Preferences prefs = AntCorePlugin.getPlugin().getPluginPreferences();
        prefs.removePropertyChangeListener((Preferences.IPropertyChangeListener)this);
        this.updateTasks(prefs);
        this.updateTypes(prefs);
        this.updateAntHomeEntries(prefs);
        this.updateAdditionalEntries(prefs);
        this.updateProperties(prefs);
        this.updatePropertyFiles(prefs);
        AntCorePlugin.getPlugin().savePluginPreferences();
        prefs.addPropertyChangeListener((Preferences.IPropertyChangeListener)this);
    }

    protected void updateTasks(Preferences prefs) {
        if (this.oldCustomTasks != null) {
            int i = 0;
            while (i < this.oldCustomTasks.length) {
                Task oldTask = this.oldCustomTasks[i];
                prefs.setToDefault("task." + oldTask.getTaskName());
                ++i;
            }
            this.oldCustomTasks = null;
        }
        if (this.customTasks.length == 0) {
            prefs.setValue("tasks", "");
            return;
        }
        StringBuffer tasks = new StringBuffer();
        int i = 0;
        while (i < this.customTasks.length) {
            tasks.append(this.customTasks[i].getTaskName());
            tasks.append(',');
            prefs.setValue("task." + this.customTasks[i].getTaskName(), String.valueOf(this.customTasks[i].getClassName()) + "," + this.customTasks[i].getLibraryEntry().getLabel());
            ++i;
        }
        prefs.setValue("tasks", tasks.toString());
    }

    protected void updateTypes(Preferences prefs) {
        if (this.oldCustomTypes != null) {
            int i = 0;
            while (i < this.oldCustomTypes.length) {
                Type oldType = this.oldCustomTypes[i];
                prefs.setToDefault("type." + oldType.getTypeName());
                ++i;
            }
            this.oldCustomTypes = null;
        }
        if (this.customTypes.length == 0) {
            prefs.setValue("types", "");
            return;
        }
        StringBuffer types = new StringBuffer();
        int i = 0;
        while (i < this.customTypes.length) {
            types.append(this.customTypes[i].getTypeName());
            types.append(',');
            prefs.setValue("type." + this.customTypes[i].getTypeName(), String.valueOf(this.customTypes[i].getClassName()) + "," + this.customTypes[i].getLibraryEntry().getLabel());
            ++i;
        }
        prefs.setValue("types", types.toString());
    }

    protected void updateProperties(Preferences prefs) {
        if (this.oldCustomProperties != null) {
            int i = 0;
            while (i < this.oldCustomProperties.length) {
                Property oldProperty = this.oldCustomProperties[i];
                prefs.setToDefault("property." + oldProperty.getName());
                ++i;
            }
            this.oldCustomProperties = null;
        }
        if (this.customProperties.length == 0) {
            prefs.setValue("properties", "");
            return;
        }
        StringBuffer properties = new StringBuffer();
        int i = 0;
        while (i < this.customProperties.length) {
            properties.append(this.customProperties[i].getName());
            properties.append(',');
            prefs.setValue("property." + this.customProperties[i].getName(), this.customProperties[i].getValue());
            ++i;
        }
        prefs.setValue("properties", properties.toString());
    }

    protected void updateAdditionalEntries(Preferences prefs) {
        prefs.setValue("urls", "");
        String serialized = null;
        IAntClasspathEntry toolsJarEntry = this.getToolsJarEntry();
        if (this.additionalEntries.length == 1 && toolsJarEntry != null && this.additionalEntries[0].getLabel().equals(toolsJarEntry.getLabel())) {
            serialized = "";
        } else {
            StringBuffer entries = new StringBuffer();
            int i = 0;
            while (i < this.additionalEntries.length) {
                entries.append(this.additionalEntries[i].getLabel());
                entries.append(',');
                ++i;
            }
            serialized = entries.toString();
        }
        prefs.setValue("additional_entries", serialized);
        String prefAntHome = "";
        if (this.antHome != null && !this.antHome.equals(this.getDefaultAntHome())) {
            prefAntHome = this.antHome;
        }
        prefs.setValue("ant_home", prefAntHome);
    }

    protected void updateAntHomeEntries(Preferences prefs) {
        prefs.setValue("ant_urls", "");
        IAntClasspathEntry[] defaultEntries = this.getDefaultAntHomeEntries();
        boolean dflt = false;
        if (defaultEntries.length == this.antHomeEntries.length) {
            dflt = true;
            int i = 0;
            while (i < this.antHomeEntries.length) {
                if (!this.antHomeEntries[i].equals(defaultEntries[i])) {
                    dflt = false;
                    break;
                }
                ++i;
            }
        }
        if (dflt) {
            prefs.setValue("ant_home_entries", "");
            return;
        }
        StringBuffer entries = new StringBuffer();
        int i = 0;
        while (i < this.antHomeEntries.length) {
            entries.append(this.antHomeEntries[i].getLabel());
            entries.append(',');
            ++i;
        }
        prefs.setValue("ant_home_entries", entries.toString());
    }

    protected void updatePropertyFiles(Preferences prefs) {
        StringBuffer files = new StringBuffer();
        int i = 0;
        while (i < this.customPropertyFiles.length) {
            files.append(this.customPropertyFiles[i]);
            files.append(',');
            ++i;
        }
        prefs.setValue("propertyfiles", files.toString());
    }

    public void setAntHome(String antHome) {
        this.antHome = antHome;
    }

    public String getAntHome() {
        return this.antHome;
    }

    public IAntClasspathEntry[] getAntHomeClasspathEntries() {
        return this.antHomeEntries;
    }

    public IAntClasspathEntry[] getAdditionalClasspathEntries() {
        return this.additionalEntries;
    }

    public void setAntHomeClasspathEntries(IAntClasspathEntry[] entries) {
        this.antHomeEntries = entries;
    }

    public void setAdditionalClasspathEntries(IAntClasspathEntry[] entries) {
        this.additionalEntries = entries;
    }

    public URL getRemoteAntURL() {
        Plugin antUIPlugin = Platform.getPlugin((String)"org.eclipse.ant.ui");
        if (antUIPlugin != null) {
            IPluginDescriptor descriptor = antUIPlugin.getDescriptor();
            try {
                URL root = descriptor.getInstallURL();
                return Platform.asLocalURL((URL)new URL(root, "lib/remoteAnt.jar"));
            }
            catch (MalformedURLException malformedURLException) {
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    public URL[] getRemoteAntURLs() {
        URL remote;
        IAntClasspathEntry entry;
        ArrayList<URL> result = new ArrayList<URL>(30);
        if (this.antHomeEntries != null) {
            int i = 0;
            while (i < this.antHomeEntries.length) {
                entry = this.antHomeEntries[i];
                result.add(entry.getEntryURL());
                ++i;
            }
        }
        if ((remote = this.getRemoteAntURL()) != null) {
            result.add(remote);
        }
        if ((entry = this.getToolsJarEntry()) != null) {
            result.add(entry.getEntryURL());
        }
        return result.toArray(new URL[result.size()]);
    }
}

