/*
 * Decompiled with CFR 0.152.
 */
package org.osgi.util.tracker;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.osgi.framework.BundleContext;
import org.osgi.framework.Filter;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceEvent;
import org.osgi.framework.ServiceListener;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class ServiceTracker
implements ServiceTrackerCustomizer {
    private static final boolean DEBUG = false;
    protected final BundleContext context;
    protected final Filter filter;
    private Tracked tracked;
    private ServiceTrackerCustomizer customizer;

    public ServiceTracker(BundleContext bundleContext, ServiceReference serviceReference, ServiceTrackerCustomizer serviceTrackerCustomizer) {
        this.context = bundleContext;
        this.customizer = serviceTrackerCustomizer == null ? this : serviceTrackerCustomizer;
        try {
            this.filter = bundleContext.createFilter("(service.id=" + serviceReference.getProperty("service.id").toString() + ")");
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            throw new RuntimeException("unexpected InvalidSyntaxException: " + invalidSyntaxException.getMessage());
        }
    }

    public ServiceTracker(BundleContext bundleContext, String string, ServiceTrackerCustomizer serviceTrackerCustomizer) {
        this.context = bundleContext;
        this.customizer = serviceTrackerCustomizer == null ? this : serviceTrackerCustomizer;
        try {
            this.filter = bundleContext.createFilter("(objectClass=" + string + ")");
        }
        catch (InvalidSyntaxException invalidSyntaxException) {
            throw new RuntimeException("unexpected InvalidSyntaxException: " + invalidSyntaxException.getMessage());
        }
        if (string == null) {
            throw new NullPointerException();
        }
    }

    public ServiceTracker(BundleContext bundleContext, Filter filter, ServiceTrackerCustomizer serviceTrackerCustomizer) {
        this.context = bundleContext;
        this.filter = filter;
        ServiceTrackerCustomizer serviceTrackerCustomizer2 = this.customizer = serviceTrackerCustomizer == null ? this : serviceTrackerCustomizer;
        if (bundleContext == null || filter == null) {
            throw new NullPointerException();
        }
    }

    public synchronized void open() {
        if (this.tracked == null) {
            ServiceReference[] serviceReferenceArray;
            Tracked tracked = this.tracked = new Tracked(this.customizer, this.filter);
            synchronized (tracked) {
                this.context.addServiceListener((ServiceListener)this.tracked);
                try {
                    serviceReferenceArray = this.context.getServiceReferences(null, this.filter.toString());
                }
                catch (InvalidSyntaxException invalidSyntaxException) {
                    throw new RuntimeException("unexpected InvalidSyntaxException");
                }
            }
            if (serviceReferenceArray != null) {
                int n = serviceReferenceArray.length;
                int n2 = 0;
                while (n2 < n) {
                    ServiceReference serviceReference = serviceReferenceArray[n2];
                    if (serviceReference.getBundle() != null) {
                        this.tracked.track(serviceReference);
                    }
                    ++n2;
                }
            }
        }
    }

    public synchronized void close() {
        if (this.tracked != null) {
            this.tracked.close();
            ServiceReference[] serviceReferenceArray = this.getServiceReferences();
            Tracked tracked = this.tracked;
            this.tracked = null;
            try {
                this.context.removeServiceListener((ServiceListener)tracked);
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            if (serviceReferenceArray != null) {
                int n = 0;
                while (n < serviceReferenceArray.length) {
                    tracked.untrack(serviceReferenceArray[n]);
                    ++n;
                }
            }
        }
    }

    protected void finalize() throws Throwable {
        this.close();
    }

    public Object addingService(ServiceReference serviceReference) {
        return this.context.getService(serviceReference);
    }

    public void modifiedService(ServiceReference serviceReference, Object object) {
    }

    public void removedService(ServiceReference serviceReference, Object object) {
        this.context.ungetService(serviceReference);
    }

    public Object waitForService(long l) throws InterruptedException {
        if (l < 0L) {
            throw new IllegalArgumentException("timeout value is negative");
        }
        Object object = this.getService();
        while (object == null) {
            Tracked tracked = this.tracked;
            if (tracked == null) {
                return null;
            }
            Tracked tracked2 = tracked;
            synchronized (tracked2) {
                if (tracked.size() == 0) {
                    tracked.wait(l);
                }
            }
            object = this.getService();
            if (l <= 0L) continue;
            return object;
        }
        return object;
    }

    public ServiceReference[] getServiceReferences() {
        Tracked tracked = this.tracked;
        if (tracked == null) {
            return null;
        }
        Tracked tracked2 = tracked;
        synchronized (tracked2) {
            int n = tracked.size();
            if (n == 0) {
                ServiceReference[] serviceReferenceArray = null;
                return serviceReferenceArray;
            }
            ServiceReference[] serviceReferenceArray = new ServiceReference[n];
            Enumeration enumeration = tracked.keys();
            int n2 = 0;
            while (n2 < n) {
                serviceReferenceArray[n2] = (ServiceReference)enumeration.nextElement();
                ++n2;
            }
            ServiceReference[] serviceReferenceArray2 = serviceReferenceArray;
            return serviceReferenceArray2;
        }
    }

    public Object[] getServices() {
        Tracked tracked = this.tracked;
        if (tracked == null) {
            return null;
        }
        Tracked tracked2 = tracked;
        synchronized (tracked2) {
            int n = tracked.size();
            if (n == 0) {
                Object[] objectArray = null;
                return objectArray;
            }
            Object[] objectArray = new Object[n];
            Enumeration enumeration = tracked.elements();
            int n2 = 0;
            while (n2 < n) {
                objectArray[n2] = enumeration.nextElement();
                ++n2;
            }
            Object[] objectArray2 = objectArray;
            return objectArray2;
        }
    }

    public ServiceReference getServiceReference() {
        int n;
        ServiceReference[] serviceReferenceArray = this.getServiceReferences();
        int n2 = n = serviceReferenceArray == null ? 0 : serviceReferenceArray.length;
        if (n > 0) {
            int n3 = 0;
            if (n > 1) {
                int[] nArray = new int[n];
                int n4 = 0;
                int n5 = Integer.MIN_VALUE;
                int n6 = 0;
                while (n6 < n) {
                    int n7;
                    Object object = serviceReferenceArray[n6].getProperty("service.ranking");
                    nArray[n6] = n7 = object instanceof Integer ? (Integer)object : 0;
                    if (n7 > n5) {
                        n3 = n6;
                        n5 = n7;
                        n4 = 1;
                    } else if (n7 == n5) {
                        ++n4;
                    }
                    ++n6;
                }
                if (n4 > 1) {
                    long l = Long.MAX_VALUE;
                    int n8 = 0;
                    while (n8 < n) {
                        long l2;
                        if (nArray[n8] == n5 && (l2 = ((Long)serviceReferenceArray[n8].getProperty("service.id")).longValue()) < l) {
                            n3 = n8;
                            l = l2;
                        }
                        ++n8;
                    }
                }
            }
            return serviceReferenceArray[n3];
        }
        return null;
    }

    public Object getService(ServiceReference serviceReference) {
        Tracked tracked = this.tracked;
        if (tracked == null) {
            return null;
        }
        return tracked.get(serviceReference);
    }

    public Object getService() {
        ServiceReference serviceReference = this.getServiceReference();
        if (serviceReference != null) {
            return this.getService(serviceReference);
        }
        return null;
    }

    public void remove(ServiceReference serviceReference) {
        Tracked tracked = this.tracked;
        if (tracked == null) {
            return;
        }
        tracked.untrack(serviceReference);
    }

    public int size() {
        Tracked tracked = this.tracked;
        if (tracked == null) {
            return 0;
        }
        return tracked.size();
    }

    public int getTrackingCount() {
        Tracked tracked = this.tracked;
        if (tracked == null) {
            return -1;
        }
        return tracked.getTrackingCount();
    }

    static class Tracked
    extends Hashtable
    implements ServiceListener {
        private ServiceTrackerCustomizer customizer;
        private Filter filter;
        private Vector adding;
        private boolean closed;
        private int trackingCount;

        protected Tracked(ServiceTrackerCustomizer serviceTrackerCustomizer, Filter filter) {
            this.customizer = serviceTrackerCustomizer;
            this.filter = filter;
            this.closed = false;
            this.trackingCount = 0;
            this.adding = new Vector(10, 10);
        }

        protected void close() {
            this.closed = true;
        }

        protected int getTrackingCount() {
            return this.trackingCount;
        }

        public void serviceChanged(ServiceEvent serviceEvent) {
            if (this.closed) {
                return;
            }
            ServiceReference serviceReference = serviceEvent.getServiceReference();
            switch (serviceEvent.getType()) {
                case 1: 
                case 2: {
                    if (this.filter.match(serviceReference)) {
                        this.track(serviceReference);
                        break;
                    }
                    this.untrack(serviceReference);
                    break;
                }
                case 4: {
                    this.untrack(serviceReference);
                }
            }
        }

        protected void track(ServiceReference serviceReference) {
            Tracked tracked;
            Object object = this.get(serviceReference);
            if (object != null) {
                this.customizer.modifiedService(serviceReference, object);
                return;
            }
            Tracked tracked2 = this;
            synchronized (tracked2) {
                if (this.adding.indexOf(serviceReference, 0) != -1) {
                    return;
                }
                this.adding.addElement(serviceReference);
            }
            boolean bl = false;
            try {
                object = this.customizer.addingService(serviceReference);
                Object var6_6 = null;
                tracked = this;
            }
            catch (Throwable throwable) {
                Object var6_7 = null;
                Tracked tracked3 = this;
                synchronized (tracked3) {
                    if (this.adding.removeElement(serviceReference)) {
                        if (object != null) {
                            this.put(serviceReference, object);
                            ++this.trackingCount;
                            this.notifyAll();
                        }
                    } else {
                        bl = true;
                    }
                }
                throw throwable;
            }
            synchronized (tracked) {
                if (this.adding.removeElement(serviceReference)) {
                    if (object != null) {
                        this.put(serviceReference, object);
                        ++this.trackingCount;
                        this.notifyAll();
                    }
                } else {
                    bl = true;
                }
            }
            if (bl) {
                this.customizer.removedService(serviceReference, object);
            }
        }

        protected void untrack(ServiceReference serviceReference) {
            Object v;
            Tracked tracked = this;
            synchronized (tracked) {
                if (this.adding.removeElement(serviceReference)) {
                    return;
                }
                v = this.remove(serviceReference);
                if (v == null) {
                    return;
                }
                ++this.trackingCount;
            }
            this.customizer.removedService(serviceReference, v);
        }
    }
}

