package util;

import core.csbtree.CSBTree;

/**
 * CSB+ tree map.
 * 
 * @author alekh
 */
public class CSBTreeMap implements Map{

		private CSBTree csbtree;

		public CSBTreeMap(int k, int k_star) {
			csbtree = new CSBTree(k, k_star);
		}

		public void delete(int key) {
			csbtree.remove(key);
		}

		public void insert(int key, int value) {
			csbtree.add(key, value);
		}

		public void pointQuery(int key, IntPushOperator results) {
			csbtree.get(key, results);
		}

		public void rangeQuery(int lowKey, int highKey, IntPushOperator results) {
			csbtree.queryRange(lowKey, highKey, results);
		}

		public long size() {
			return csbtree.size();
		}
}
