package util;

import core.btree.BTree;

public class BTreeMap implements Map {

	private BTree btree;

	public BTreeMap(int k, int k_star) {
		btree = new BTree(k, k_star);
	}

	public void delete(int key) {
		btree.remove(key);
	}

	public void insert(int key, int value) {
		btree.add(key, value);
	}

	public void pointQuery(int key, IntPushOperator results) {
		btree.get(key, results);
	}

	public void rangeQuery(int lowKey, int highKey, IntPushOperator results) {
		btree.queryRange(lowKey, highKey, results);
	}

	public long size() {
		return btree.size();
	}

}
