package test;

import java.util.Random;

import junit.framework.TestCase;
import util.CSBTreeMap;
import util.JavaTreeMap;
import util.Map;
import util.SinkIntPushOperator;

public class MapTest extends TestCase {
	final static int maxKey = 10 * 1000 * 1000;

	final static int maxRangeSize = 1000;

	private boolean[] keyBitMap = null;

	private Map myMap;

	private Map referenceMap = new JavaTreeMap();

	private Random rand;

	boolean insertFailure = false;

	boolean pqFailure = false;

	boolean rqFailure = false;

	boolean deleteFailure = false;

	private final int numberOfOperations = 100 * 1000;

	public MapTest() {
		myMap = new CSBTreeMap(16,16);
		rand = new Random(42);
		keyBitMap = new boolean[maxKey + 1];
		for (int i = 0; i < maxKey + 1; i++) {
			keyBitMap[i] = false;
		}
	}

	public void testAll() {

		// test for similar size when inserting:
		for (int i = 0; i < numberOfOperations; i++) {
			if (i % 10000 == 0)
				System.err.print(i + " ");
			int key = rand.nextInt(maxKey);
			int value = 42000000 + key;
			if (!keyBitMap[key]) {
				keyBitMap[key] = true;
				referenceMap.insert(key, value);
				myMap.insert(key, value);
				// test for same sizes:
				if (referenceMap.size() != myMap.size()) {
					System.out.println("maps have different size \nfailure after performing "
							+ (i * 100.0 / numberOfOperations) + "% of this test.");
					insertFailure = true;
					break;
				}
			}
		}
		if (!insertFailure)
			System.out.println("\ninsert test passed: trees have same size=" + myMap.size());

		// test all point queries:
		SinkIntPushOperator results = new SinkIntPushOperator();
		for (int key = 0; key <= maxKey; key++) {
			if (key % 1000000 == 0)
				System.err.print(key + " ");

			results.setDeleteMode(false);
			myMap.pointQuery(key, results);
			results.setDeleteMode(true);
			referenceMap.pointQuery(key, results);
			if (results.size() != 0) {
				System.out.println("map results differ:" + key + " " + results + "\nfailure after performing "
						+ (key * 100.0 / (maxKey + 1)) + "% of this test.");
				pqFailure = true;

				break;
			}

		}
		if (!pqFailure)
			System.out.println("\npoint query test passed: all point queries correct");

		// test all range queries:
		results = new SinkIntPushOperator();
		for (int lowKey = 0; lowKey <= maxKey; lowKey++) {
			int highKey = Math.min(lowKey + rand.nextInt(maxRangeSize), maxKey);

			if (lowKey % 1000000 == 0)
				System.err.print(lowKey + " ");

			results.setDeleteMode(false);
			myMap.rangeQuery(lowKey, highKey, results);
			results.setDeleteMode(true);
			referenceMap.rangeQuery(lowKey, highKey, results);
			if (results.size() != 0) {
				System.out.println("map results differ:" + lowKey + " " + results + "\nfailure after performing "
						+ (lowKey * 100.0 / (maxKey + 1)) + "% of this test.");
				rqFailure = true;

				break;

			}
		}
		if (!rqFailure)
			System.out.println("\nrange query test passed: all range queries correct");

		// test for similar size when deleting:
		for (int i = 0; i < numberOfOperations; i++) {
			if (i % 10000 == 0)
				System.err.print(i + " ");
			int key = rand.nextInt(maxKey);
			if (keyBitMap[key]) {
				keyBitMap[key] = false;
				referenceMap.delete(key);
				myMap.delete(key);
				// test for same sizes:
				if (referenceMap.size() != myMap.size()) {
					System.out.println("maps have different size \nfailure after performing "
							+ (i * 100.0 / numberOfOperations) + "% of this test.");
					deleteFailure = true;
					break;
				}
			}
		}
		if (!deleteFailure)
			System.out.println("\ndelete test passed: trees have same size=" + myMap.size());

		if (insertFailure || pqFailure || rqFailure || deleteFailure) {
			fail("\nWARNING: SOME TESTS FAILED!");
		} else {
			System.out.println("ALL TESTS PASSED!");
		}
	}
}
