/*
 * Decompiled with CFR 0.152.
 */
package test;

import java.util.Random;
import util.BTreeMap;
import util.CSBTreeMap;
import util.DummyIntPushOperator;
import util.DummyMap;
import util.IntPushOperator;
import util.Map;

public class WorkloadGenerator {
    static final boolean verbose = false;
    static final int maxKey = 10000000;
    static final int maxRangeSize = 1000;
    private boolean[] keyBitMap = new boolean[10000001];
    private int currentIndexSize = 0;
    private Random rand;

    public WorkloadGenerator(long seed) {
        this.rand = new Random(seed);
    }

    public void executeWorkload(int numberOfOperations, double isQueryProbability, double isRangeQueryProbability, double deleteOverInsertProbability, Map myIndex, IntPushOperator results, boolean suppressWarnings) {
        int lowKey = -1;
        int highKey = -1;
        int value = -1;
        block0: for (int i = 0; i < numberOfOperations; ++i) {
            lowKey = this.rand.nextInt(10000000);
            if (this.rand.nextDouble() <= isQueryProbability) {
                if (this.rand.nextDouble() <= isRangeQueryProbability) {
                    highKey = Math.min(lowKey + this.rand.nextInt(1000), 10000000);
                    myIndex.rangeQuery(lowKey, highKey, results);
                    continue;
                }
                myIndex.pointQuery(lowKey, results);
                continue;
            }
            value = 42000000 + this.rand.nextInt(1000000);
            if (this.rand.nextDouble() <= deleteOverInsertProbability) {
                if (!this.keyBitMap[lowKey]) continue;
                myIndex.delete(lowKey);
                this.keyBitMap[lowKey] = false;
                --this.currentIndexSize;
                continue;
            }
            for (int probing = 0; probing < 10; ++probing) {
                int _lowKey = (lowKey + probing) % 10000001;
                if (this.keyBitMap[_lowKey]) continue;
                myIndex.insert(_lowKey, value);
                this.keyBitMap[_lowKey] = true;
                ++this.currentIndexSize;
                continue block0;
            }
        }
        System.out.println("# desired tree size:\t" + this.currentIndexSize + "\ttree size reported by implementation:\t" + myIndex.size());
        if (!suppressWarnings & (long)this.currentIndexSize != myIndex.size()) {
            System.err.println("WARNING: TREE SIZE OF IMPLEMENTATION NOT CORRECT!");
        }
    }

    public static void main(String[] args) {
        Map studentIndex = null;
        int k = 16;
        int k_star = 16;
        String treeType = "csbtree";
        if (args.length == 1) {
            treeType = args[0];
        }
        if (args.length == 3) {
            k = Integer.parseInt(args[0]);
            k_star = Integer.parseInt(args[1]);
            treeType = args[2];
        }
        if (treeType.equals("btree")) {
            studentIndex = new BTreeMap(k, k_star);
        } else if (treeType.equals("csbtree")) {
            studentIndex = new CSBTreeMap(k, k_star);
        } else {
            System.exit(1);
        }
        Map[] myIndex = new Map[]{new DummyMap(), studentIndex};
        long[] totalTime = new long[2];
        for (int round = 0; round < 2; ++round) {
            WorkloadGenerator workloadGenerator = new WorkloadGenerator(42L);
            DummyIntPushOperator results = new DummyIntPushOperator();
            int numberOfOperations = 1000000;
            double isQueryProbability = 0.0;
            double isRangeQueryProbability = 0.5;
            double deleteOverInsertProbability = 0.0;
            workloadGenerator.executeWorkload(numberOfOperations, isQueryProbability, isRangeQueryProbability, deleteOverInsertProbability, myIndex[round], results, round == 0);
            long begin = System.nanoTime();
            isQueryProbability = 0.7;
            isRangeQueryProbability = 0.6;
            deleteOverInsertProbability = 0.5;
            workloadGenerator.executeWorkload(numberOfOperations *= 10, isQueryProbability, isRangeQueryProbability, deleteOverInsertProbability, myIndex[round], results, round == 0);
            totalTime[round] = System.nanoTime() - begin;
        }
        System.out.println("Time: " + (double)totalTime[0] / 1.0E9 + "sec");
        System.out.println("Time: " + (double)totalTime[1] / 1.0E9 + "sec");
        System.out.println("Total time for " + studentIndex.getClass().getName() + ": " + (double)(totalTime[1] - totalTime[0]) / 1.0E9 + "sec");
    }
}

