/*
 * Decompiled with CFR 0.152.
 */
package core.csbtree;

import core.csbtree.CSBTreeNode;
import core.csbtree.NodeGroup;

public class NodeGroupArrayMap {
    protected int[] keys;
    protected CSBTreeNode[] nodes;
    protected int[] currentSizes;
    protected int m;
    protected int numberOfNodes = 0;

    public NodeGroupArrayMap(int m) {
        this.m = m;
        this.keys = new int[m];
        this.numberOfNodes = 1;
        this.nodes = new CSBTreeNode[1];
        this.currentSizes = new int[1];
        this.nodes[0] = NodeGroup.NULL;
        this.currentSizes[0] = 0;
    }

    public static int binarySearch(int[] a, int key, int from, int to) {
        int low = from;
        int high = to;
        while (low <= high) {
            int mid = low + high >> 1;
            long midVal = a[mid];
            if (midVal < (long)key) {
                low = mid + 1;
                continue;
            }
            if (midVal > (long)key) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public NodeGroupArrayMap(int m, int numberOfNodes) {
        this.m = m;
        this.numberOfNodes = numberOfNodes;
        this.keys = new int[m * numberOfNodes];
        this.nodes = new CSBTreeNode[numberOfNodes];
        this.currentSizes = new int[numberOfNodes];
    }

    public int getIntervalPosition(int key, int index) {
        if (this.currentSizes[index] == 0) {
            return -1;
        }
        int pos = NodeGroupArrayMap.binarySearch(this.keys, key, index * this.m, index * this.m + this.currentSizes[index] - 1);
        pos = pos < 0 ? -(pos + 1) : ++pos;
        return pos;
    }

    public void put(int key, int pos, int index) {
        int indexXm = index * this.m;
        if (pos < this.currentSizes[index]) {
            System.arraycopy(this.keys, indexXm + pos, this.keys, indexXm + pos + 1, this.currentSizes[index] - pos);
            this.keys[indexXm + pos] = key;
            int n = index;
            this.currentSizes[n] = this.currentSizes[n] + 1;
        } else {
            this.keys[indexXm + this.currentSizes[index]] = key;
            int n = index;
            this.currentSizes[n] = this.currentSizes[n] + 1;
        }
    }

    public int splitNode(int pivot, int pos, int index, CSBTreeNode rightchild) {
        ++this.numberOfNodes;
        int posInNode = pos % this.m;
        if (pos == (index + 1) * this.m) {
            posInNode = this.m;
        }
        int[] newKeys = new int[this.numberOfNodes * this.m];
        CSBTreeNode[] newNodes = new CSBTreeNode[this.numberOfNodes];
        int[] newCurrentSizes = new int[this.numberOfNodes];
        int addPivotTo = 0;
        int splitPosInNode = this.currentSizes[index] + 1 >> 1;
        if (posInNode > splitPosInNode) {
            ++splitPosInNode;
            addPivotTo = 2;
        } else if (posInNode == splitPosInNode) {
            addPivotTo = 1;
        }
        int splitPos = index * this.m + splitPosInNode;
        if (addPivotTo == 1) {
            System.arraycopy(this.keys, 0, newKeys, 0, splitPos);
        } else {
            System.arraycopy(this.keys, 0, newKeys, 0, splitPos - 1);
        }
        System.arraycopy(this.keys, splitPos, newKeys, (index + 1) * this.m, this.currentSizes[index] - splitPosInNode);
        System.arraycopy(this.keys, (index + 1) * this.m, newKeys, (index + 2) * this.m, (this.numberOfNodes - index - 2) * this.m);
        System.arraycopy(this.nodes, 0, newNodes, 0, index + 1);
        System.arraycopy(this.nodes, index + 1, newNodes, index + 2, this.numberOfNodes - index - 2);
        newNodes[index + 1] = rightchild;
        System.arraycopy(this.currentSizes, 0, newCurrentSizes, 0, index + 1);
        System.arraycopy(this.currentSizes, index + 1, newCurrentSizes, index + 2, this.numberOfNodes - index - 2);
        newCurrentSizes[index] = addPivotTo == 1 ? splitPosInNode : splitPosInNode - 1;
        newCurrentSizes[index + 1] = this.currentSizes[index] - splitPosInNode;
        int newPivot = this.keys[splitPos - 1];
        this.keys = newKeys;
        this.nodes = newNodes;
        this.currentSizes = newCurrentSizes;
        switch (addPivotTo) {
            case 0: {
                this.put(pivot, posInNode, index);
                return newPivot;
            }
            case 2: {
                this.put(pivot, posInNode -= splitPosInNode, index + 1);
                return newPivot;
            }
        }
        return pivot;
    }

    public boolean isNodeFull(int index) {
        return this.currentSizes[index] >= this.m;
    }

    public NodeGroupArrayMap splitNodeGroup() {
        int numberOfNodesInLeftChild = (this.numberOfNodes + 1) / 2;
        int numberOfNodesInRightChild = this.numberOfNodes - numberOfNodesInLeftChild;
        int[] newKeys = new int[numberOfNodesInLeftChild * this.m];
        CSBTreeNode[] newNodes = new CSBTreeNode[numberOfNodesInLeftChild];
        int[] newCurrentSizes = new int[numberOfNodesInLeftChild];
        NodeGroupArrayMap rightchild = new NodeGroupArrayMap(this.m, numberOfNodesInRightChild);
        System.arraycopy(this.keys, 0, newKeys, 0, numberOfNodesInLeftChild * this.m);
        System.arraycopy(this.keys, numberOfNodesInLeftChild * this.m, rightchild.keys, 0, numberOfNodesInRightChild * this.m);
        System.arraycopy(this.nodes, 0, newNodes, 0, numberOfNodesInLeftChild);
        System.arraycopy(this.nodes, numberOfNodesInLeftChild, rightchild.nodes, 0, numberOfNodesInRightChild);
        System.arraycopy(this.currentSizes, 0, newCurrentSizes, 0, numberOfNodesInLeftChild);
        System.arraycopy(this.currentSizes, numberOfNodesInLeftChild, rightchild.currentSizes, 0, numberOfNodesInRightChild);
        this.keys = newKeys;
        this.nodes = newNodes;
        this.currentSizes = newCurrentSizes;
        this.numberOfNodes = numberOfNodesInLeftChild;
        return rightchild;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        block0: for (int i = 0; i < this.numberOfNodes; ++i) {
            String nodeValue = this.nodes[i] == NodeGroup.NULL ? "NULL | " : Integer.toString(this.nodes[i].hashCode()) + " | ";
            sb.append(nodeValue);
            for (int j = 0; j < this.currentSizes[i]; ++j) {
                if (j == this.currentSizes[i] - 1) {
                    sb.append(this.keys[j + i * this.m] + "/ ");
                    continue block0;
                }
                sb.append(this.keys[j + i * this.m] + ".");
            }
        }
        return sb.toString();
    }
}

