/*
 * Decompiled with CFR 0.152.
 */
package core.csbtree;

import core.csbtree.CSBTreeNode;
import core.csbtree.LeafCarrier;
import core.csbtree.NodeGroupArrayMap;
import core.csbtree.SplitInfo;
import java.io.OutputStream;
import util.IntPushOperator;

public class NodeGroup
implements CSBTreeNode {
    protected static final NodeGroup NULL = new NodeGroup(0, null);
    protected NodeGroupArrayMap entries;
    protected int k;

    public NodeGroup(int k, NodeGroupArrayMap entries) {
        this.k = k;
        this.entries = entries;
    }

    public NodeGroup(CSBTreeNode child, int pivot, int k) {
        this.k = k;
        this.entries = new NodeGroupArrayMap(4 * k);
        this.entries.nodes[0] = child;
        this.entries.keys[0] = pivot;
        this.entries.currentSizes[0] = 1;
    }

    public SplitInfo add(int index, int key, int value, boolean isParentNodeFull, int lowKey, int highKey, LeafCarrier leafCarrier) {
        SplitInfo splitInfo;
        int pos = this.entries.getIntervalPosition(key, index);
        CSBTreeNode next = this.entries.nodes[index];
        int newLowKey = pos == 0 ? lowKey : this.entries.keys[pos - 1];
        int newHighKey = pos == (this.entries.numberOfNodes - 1) * 4 * this.k + this.entries.currentSizes[this.entries.numberOfNodes - 1] ? highKey : this.entries.keys[pos];
        int newIndex = pos % (4 * this.k);
        if (pos == (index + 1) * 4 * this.k) {
            newIndex = 4 * this.k;
        }
        if ((splitInfo = next.add(newIndex, key, value, this.entries.isNodeFull(index), newLowKey, newHighKey, leafCarrier)) != null) {
            if (splitInfo.rightNode == null) {
                this.entries.put(splitInfo.pivot, pos % (4 * this.k), index);
            } else {
                return this.split(splitInfo.pivot, splitInfo.rightNode, isParentNodeFull, index);
            }
        }
        return null;
    }

    private SplitInfo split(int pivot, CSBTreeNode rightchild, boolean isParentNodeFull, int index) {
        int pos = this.entries.getIntervalPosition(pivot, index);
        int nextPivot = this.entries.splitNode(pivot, pos, index, rightchild);
        if (!isParentNodeFull) {
            return new SplitInfo(this, nextPivot, null);
        }
        NodeGroup newNode = new NodeGroup(this.k, this.entries.splitNodeGroup());
        return new SplitInfo(this, nextPivot, newNode);
    }

    public void remove(int index, int key, int value, int lowKey, int highKey) {
        int pos = this.entries.getIntervalPosition(key, index);
        CSBTreeNode next = this.entries.nodes[index];
        int newIndex = pos % (4 * this.k);
        if (pos == (index + 1) * 4 * this.k) {
            newIndex = 4 * this.k;
        }
        if (next != null || pos != -1) {
            int newLowKey = pos == 0 ? lowKey : this.entries.keys[pos - 1];
            int newHighKey = pos == (this.entries.numberOfNodes - 1) * 4 * this.k + this.entries.currentSizes[this.entries.numberOfNodes - 1] ? highKey : this.entries.keys[pos];
            next.remove(newIndex, key, value, newLowKey, newHighKey);
        }
    }

    public void get(int index, int key, IntPushOperator results) {
        int pos = this.entries.getIntervalPosition(key, index);
        CSBTreeNode next = this.entries.nodes[index];
        int newIndex = pos % (4 * this.k);
        if (pos == (index + 1) * 4 * this.k) {
            newIndex = 4 * this.k;
        }
        if (next != null || pos != -1) {
            next.get(newIndex, key, results);
        }
    }

    public void queryRange(int index, int lowKey, int highKey, IntPushOperator results) {
        int pos = this.entries.getIntervalPosition(lowKey, index);
        CSBTreeNode next = this.entries.nodes[index];
        int newIndex = pos % (4 * this.k);
        if (pos == (index + 1) * 4 * this.k) {
            newIndex = 4 * this.k;
        }
        if (next != null || pos != -1) {
            next.queryRange(newIndex, lowKey, highKey, results);
        }
    }

    public boolean isLeaf() {
        return false;
    }

    public boolean isEmpty() {
        return this.entries.numberOfNodes == 0;
    }

    public void toDot(OutputStream dest) {
    }

    public boolean isFull(int index) {
        return this.entries.currentSizes[index] == 4 * this.k;
    }

    public String toString() {
        return "[" + this.entries.toString() + "]";
    }
}

