/*
 * Decompiled with CFR 0.152.
 */
package core.csbtree;

import util.IntPushOperator;

public class LeafGroupArrayMap {
    protected int two_k_star;
    protected int[] keys;
    protected int[] values;
    protected int currentGroupSize = 0;
    protected int[] currentLeafSize;
    protected int currentSize = 0;
    protected static final int STOP = 0;
    protected static final int CONTINUE_WITH_BINSEARCH = 1;
    protected static final int CONTINUE_WITH_SCAN = 2;

    public static int binarySearch(int[] a, int key, int from, int to) {
        int low = from;
        int high = to;
        while (low <= high) {
            int pos;
            int mid = low + high >> 1;
            long midVal = a[mid];
            if (midVal < (long)key) {
                low = mid + 1;
                continue;
            }
            if (midVal > (long)key) {
                high = mid - 1;
                continue;
            }
            for (pos = mid - 1; pos >= from && a[pos] == key; --pos) {
            }
            return pos + 1;
        }
        return -(low + 1);
    }

    public LeafGroupArrayMap(int n) {
        this.two_k_star = n;
        this.keys = new int[n];
        this.values = new int[n];
        this.currentLeafSize = new int[1];
        this.currentGroupSize = this.two_k_star;
    }

    public boolean tryAdd(int leafNumber, int key, int value) {
        int leafStartPosition = (leafNumber - 1) * this.two_k_star;
        int leafEndPosition = leafStartPosition + this.currentLeafSize[leafNumber - 1] - 1;
        if (this.currentLeafSize[leafNumber - 1] == 0) {
            this.keys[leafStartPosition] = key;
            this.values[leafStartPosition] = value;
            int n = leafNumber - 1;
            this.currentLeafSize[n] = this.currentLeafSize[n] + 1;
            if (leafNumber == this.currentLeafSize.length) {
                ++this.currentSize;
            }
            return false;
        }
        int pos = LeafGroupArrayMap.binarySearch(this.keys, key, leafStartPosition, leafEndPosition);
        if (pos < 0) {
            pos = -(pos + 1);
        }
        while (pos <= leafEndPosition && this.keys[pos] <= key) {
            ++pos;
        }
        if (pos == this.currentGroupSize) {
            return true;
        }
        if (pos == leafNumber * this.two_k_star) {
            return this.tryAdd(leafNumber + 1, key, value);
        }
        this.addAtPos(key, value, leafNumber, pos);
        return false;
    }

    public boolean tryAdd(int key, int value) {
        return this.tryAdd(1, key, value);
    }

    public int indexOf(int leafNumber, int position) {
        return this.two_k_star * (leafNumber - 1) + position - 1;
    }

    public int leaves() {
        return this.currentLeafSize.length;
    }

    public int size() {
        return this.currentGroupSize;
    }

    public int size(int leafNumber) {
        return this.currentLeafSize[leafNumber - 1];
    }

    public int getKeyNumber() {
        int count = 0;
        for (int i = 0; i < this.currentLeafSize.length; ++i) {
            count += this.currentLeafSize[i];
        }
        return count;
    }

    public void addAtPos(int key, int value, int leafNumber, int pos) {
        int leafLastIndex = this.indexOf(leafNumber, this.currentLeafSize[leafNumber - 1]);
        if (pos <= leafLastIndex) {
            System.arraycopy(this.keys, pos, this.keys, pos + 1, leafLastIndex - pos + 1);
            System.arraycopy(this.values, pos, this.values, pos + 1, leafLastIndex - pos + 1);
            int n = leafNumber - 1;
            this.currentLeafSize[n] = this.currentLeafSize[n] + 1;
            if (leafNumber == this.currentLeafSize.length) {
                ++this.currentSize;
            }
            this.keys[pos] = key;
            this.values[pos] = value;
        } else {
            this.keys[leafLastIndex + 1] = key;
            this.values[leafLastIndex + 1] = value;
            int n = leafNumber - 1;
            this.currentLeafSize[n] = this.currentLeafSize[n] + 1;
            if (leafNumber == this.currentLeafSize.length) {
                ++this.currentSize;
            }
        }
    }

    public void split(int leafNumber) {
        int leafEnd = this.indexOf(leafNumber, this.currentLeafSize[leafNumber - 1]);
        int mid = this.indexOf(leafNumber, this.currentLeafSize[leafNumber - 1] / 2 + 1);
        int[] newkeys = new int[this.currentGroupSize + this.two_k_star];
        int[] newvalues = new int[this.currentGroupSize + this.two_k_star];
        int[] newCurrentLeafSize = new int[this.leaves() + 1];
        System.arraycopy(this.keys, 0, newkeys, 0, mid);
        System.arraycopy(this.keys, mid, newkeys, leafEnd + 1, this.two_k_star - mid % this.two_k_star);
        System.arraycopy(this.keys, leafEnd + 1, newkeys, leafEnd + 1 + this.two_k_star, this.currentGroupSize - leafEnd - 1);
        System.arraycopy(this.values, 0, newvalues, 0, mid);
        System.arraycopy(this.values, mid, newvalues, leafEnd + 1, this.two_k_star - mid % this.two_k_star);
        System.arraycopy(this.values, leafEnd + 1, newvalues, leafEnd + 1 + this.two_k_star, this.currentGroupSize - leafEnd - 1);
        System.arraycopy(this.currentLeafSize, 0, newCurrentLeafSize, 0, leafNumber - 1);
        System.arraycopy(this.currentLeafSize, leafNumber, newCurrentLeafSize, leafNumber + 1, this.leaves() - leafNumber);
        newCurrentLeafSize[leafNumber - 1] = this.currentLeafSize[leafNumber - 1] / 2;
        newCurrentLeafSize[leafNumber] = this.currentLeafSize[leafNumber - 1] - this.currentLeafSize[leafNumber - 1] / 2;
        this.keys = newkeys;
        this.values = newvalues;
        this.currentLeafSize = newCurrentLeafSize;
        this.currentSize = this.currentGroupSize + this.currentLeafSize[this.currentLeafSize.length - 1];
        this.currentGroupSize += this.two_k_star;
    }

    public LeafGroupArrayMap split() {
        int midLeaf = (this.leaves() + 3) / 2;
        int mid = this.indexOf(midLeaf, 1);
        LeafGroupArrayMap newMap = new LeafGroupArrayMap(this.two_k_star);
        newMap.currentLeafSize = new int[this.leaves() - midLeaf + 1];
        newMap.keys = new int[this.currentGroupSize - mid];
        newMap.values = new int[this.currentGroupSize - mid];
        System.arraycopy(this.keys, mid, newMap.keys, 0, this.currentSize - mid);
        System.arraycopy(this.values, mid, newMap.values, 0, this.currentSize - mid);
        System.arraycopy(this.currentLeafSize, midLeaf - 1, newMap.currentLeafSize, 0, this.leaves() - midLeaf + 1);
        newMap.currentGroupSize = (this.leaves() - midLeaf + 1) * this.two_k_star;
        newMap.currentSize = newMap.currentGroupSize - this.two_k_star + newMap.currentLeafSize[newMap.currentLeafSize.length - 1];
        int[] newKeys = new int[(midLeaf - 1) * this.two_k_star];
        int[] newValues = new int[(midLeaf - 1) * this.two_k_star];
        int[] newCurrentLeafSize = new int[midLeaf - 1];
        System.arraycopy(this.keys, 0, newKeys, 0, mid);
        System.arraycopy(this.values, 0, newValues, 0, mid);
        System.arraycopy(this.currentLeafSize, 0, newCurrentLeafSize, 0, midLeaf - 1);
        this.keys = newKeys;
        this.values = newValues;
        this.currentLeafSize = newCurrentLeafSize;
        this.currentGroupSize = (midLeaf - 1) * this.two_k_star;
        this.currentSize = this.currentGroupSize - this.two_k_star + this.currentLeafSize[this.currentLeafSize.length - 1];
        return newMap;
    }

    public boolean remove(int leafNumber, int key, int value) {
        boolean continueSearch;
        if (this.currentGroupSize == 0) {
            return true;
        }
        int leafStartPosition = (leafNumber - 1) * this.two_k_star;
        int leafEndPosition = leafStartPosition + this.currentLeafSize[leafNumber - 1] - 1;
        int pos = LeafGroupArrayMap.binarySearch(this.keys, key, leafStartPosition, leafEndPosition);
        if (pos < 0) {
            if ((pos = -(pos + 1)) == this.currentSize) {
                return true;
            }
            if (pos == leafEndPosition + 2) {
                return this.remove(leafNumber + 1, key, value);
            }
            return true;
        }
        int firstOccurrence = -1;
        while (pos <= leafEndPosition && this.keys[pos] == key) {
            if (value == Integer.MIN_VALUE) {
                if (firstOccurrence == -1) {
                    firstOccurrence = pos;
                }
            } else if (this.values[pos] == value) {
                firstOccurrence = pos;
                break;
            }
            ++pos;
        }
        int lastOccurrence = value == Integer.MIN_VALUE ? pos - 1 : firstOccurrence;
        boolean bl = value == Integer.MIN_VALUE || firstOccurrence == -1 ? pos == leafEndPosition + 1 : (continueSearch = false);
        if (firstOccurrence != -1) {
            System.arraycopy(this.keys, lastOccurrence + 1, this.keys, firstOccurrence, leafEndPosition - lastOccurrence);
            System.arraycopy(this.values, lastOccurrence + 1, this.values, firstOccurrence, leafEndPosition - lastOccurrence);
            int n = leafNumber - 1;
            this.currentLeafSize[n] = this.currentLeafSize[n] - (lastOccurrence - firstOccurrence + 1);
            this.currentSize -= lastOccurrence - firstOccurrence + 1;
        }
        return continueSearch;
    }

    public boolean remove(int key, int value) {
        return this.remove(1, key, value);
    }

    public int get(int leafNumber, int key, IntPushOperator results) {
        int leafStartPosition = (leafNumber - 1) * this.two_k_star;
        int leafEndPosition = leafStartPosition + this.currentLeafSize[leafNumber - 1] - 1;
        if (this.currentSize == 0) {
            return 1;
        }
        if (this.currentLeafSize[leafNumber - 1] == 0) {
            return this.get(leafNumber + 1, key, results);
        }
        int pos = LeafGroupArrayMap.binarySearch(this.keys, key, leafStartPosition, leafEndPosition);
        if (pos < 0) {
            if ((pos = -(pos + 1)) == this.currentSize) {
                return 1;
            }
            if (pos == leafEndPosition + 2) {
                return this.get(leafNumber + 1, key, results);
            }
            return 0;
        }
        return this.continueGet(pos, key, results);
    }

    public int get(int key, IntPushOperator results) {
        return this.get(1, key, results);
    }

    public int continueGet(int pos, int key, IntPushOperator results) {
        while (pos < this.currentSize && this.keys[pos] == key) {
            results.pass(this.values[pos]);
            ++pos;
        }
        return pos == this.currentSize ? 2 : 0;
    }

    public int queryRange(int leafNumber, int lowKey, int highKey, IntPushOperator results) {
        int leafStartPosition = (leafNumber - 1) * this.two_k_star;
        int leafEndPosition = leafStartPosition + this.currentLeafSize[leafNumber - 1] - 1;
        if (this.currentSize == 0) {
            return 1;
        }
        if (this.currentLeafSize[leafNumber - 1] == 0) {
            return this.queryRange(leafNumber + 1, lowKey, highKey, results);
        }
        int pos = LeafGroupArrayMap.binarySearch(this.keys, lowKey, leafStartPosition, leafEndPosition);
        if (pos < 0) {
            pos = -(pos + 1);
        }
        return this.continueScan(pos, highKey, results);
    }

    public int queryRange(int lowKey, int highKey, IntPushOperator results) {
        return this.queryRange(1, lowKey, highKey, results);
    }

    public int continueScan(int pos, int highKey, IntPushOperator results) {
        boolean returnedSomething = false;
        while (pos < this.currentSize && this.keys[pos] <= highKey) {
            results.pass(this.values[pos]);
            ++pos;
            returnedSomething = true;
        }
        return pos == this.currentSize ? (returnedSomething ? 2 : 1) : 0;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.currentSize; ++i) {
            sb.append(this.keys[i] + "=");
            sb.append(this.values[i]);
            if (i + 1 >= this.currentSize) continue;
            sb.append(", ");
        }
        return sb.toString();
    }
}

