/*
 * Decompiled with CFR 0.152.
 */
package core.csbtree;

import core.csbtree.CSBTreeNode;
import core.csbtree.LeafCarrier;
import core.csbtree.LeafGroupArrayMap;
import core.csbtree.SplitInfo;
import java.io.OutputStream;
import util.IntPushOperator;

public class LeafGroup
implements CSBTreeNode {
    protected LeafGroupArrayMap entries;
    protected int k;
    protected int k_star;
    protected LeafGroup nextLeafGroup;

    public LeafGroup(int k, int k_star, LeafGroupArrayMap entries) {
        this.k = k;
        this.k_star = k_star;
        this.entries = entries;
        this.nextLeafGroup = null;
    }

    public LeafGroup(int k, int k_star) {
        this(k, k_star, new LeafGroupArrayMap(2 * k_star));
    }

    public SplitInfo add(int index, int key, int value, boolean isParentNodeFull, int lowKey, int highKey, LeafCarrier leafCarrier) {
        boolean continueSearch = this.entries.tryAdd(index + 1, key, value);
        LeafGroup currentLeafGroup = this;
        while (continueSearch && currentLeafGroup.nextLeafGroup != null && currentLeafGroup.nextLeafGroup.entries.keys[0] < highKey) {
            continueSearch = currentLeafGroup.nextLeafGroup.entries.tryAdd(key, value);
            currentLeafGroup = currentLeafGroup.nextLeafGroup;
        }
        if (continueSearch) {
            int leafNumber = currentLeafGroup.entries.leaves();
            currentLeafGroup.entries.addAtPos(key, value, leafNumber, 2 * this.k_star * (currentLeafGroup.entries.leaves() - 1) + currentLeafGroup.entries.size(leafNumber));
        }
        if (leafCarrier != null) {
            leafCarrier.carriedLeaf = currentLeafGroup;
        }
        if (currentLeafGroup.entries.size(index + 1) >= 2 * this.k_star) {
            SplitInfo splitInfo = currentLeafGroup.split(index + 1);
            if (isParentNodeFull) {
                return currentLeafGroup.split(splitInfo);
            }
            return splitInfo;
        }
        return null;
    }

    private SplitInfo split(int leafNumber) {
        this.entries.split(leafNumber);
        int newLeafFirstIndex = this.entries.indexOf(leafNumber + 1, 1);
        return new SplitInfo(this, this.entries.keys[newLeafFirstIndex], null);
    }

    private SplitInfo split(SplitInfo splitInfo) {
        LeafGroup newLeafGroup = new LeafGroup(this.k, this.k_star, this.entries.split());
        newLeafGroup.nextLeafGroup = this.nextLeafGroup;
        this.nextLeafGroup = newLeafGroup;
        return new SplitInfo(this, splitInfo.pivot, newLeafGroup);
    }

    public void remove(int index, int key, int value, int lowKey, int highKey) {
        boolean continueSearch = this.entries.remove(index + 1, key, value);
        LeafGroup currentLeafGroup = this;
        while (continueSearch && currentLeafGroup.nextLeafGroup != null && currentLeafGroup.nextLeafGroup.entries.keys[0] < highKey) {
            continueSearch = currentLeafGroup.nextLeafGroup.entries.remove(key, value);
            if (currentLeafGroup.nextLeafGroup.entries.size() == 0) {
                currentLeafGroup.nextLeafGroup = currentLeafGroup.nextLeafGroup.nextLeafGroup;
                continue;
            }
            currentLeafGroup = currentLeafGroup.nextLeafGroup;
        }
    }

    public void get(int index, int key, IntPushOperator results) {
        int continueSearch = this.entries.get(index + 1, key, results);
        LeafGroup currentLeaf = this.nextLeafGroup;
        while (continueSearch != 0 && currentLeaf != null) {
            continueSearch = continueSearch == 1 ? currentLeaf.entries.get(key, results) : currentLeaf.entries.continueGet(0, key, results);
            currentLeaf = currentLeaf.nextLeafGroup;
        }
        results.thatsallfolks();
    }

    public void queryRange(int index, int lowKey, int highKey, IntPushOperator results) {
        int continueSearch = this.entries.queryRange(index + 1, lowKey, highKey, results);
        LeafGroup currentLeaf = this.nextLeafGroup;
        while (continueSearch != 0 && currentLeaf != null) {
            continueSearch = continueSearch == 2 ? currentLeaf.entries.continueScan(0, highKey, results) : currentLeaf.entries.queryRange(lowKey, highKey, results);
            currentLeaf = currentLeaf.nextLeafGroup;
        }
        results.thatsallfolks();
    }

    public boolean isEmpty() {
        return this.entries.size() == 0;
    }

    public boolean isFull(int index) {
        return this.entries.currentLeafSize[index] == 2 * this.k_star;
    }

    public boolean isLeaf() {
        return true;
    }

    public void toDot(OutputStream dest) {
    }
}

