/*
 * Decompiled with CFR 0.152.
 */
package core.csbtree;

import core.csbtree.CSBTreeNode;
import core.csbtree.LeafCarrier;
import core.csbtree.LeafGroup;
import core.csbtree.NodeGroup;
import core.csbtree.SplitInfo;
import java.io.IOException;
import java.io.OutputStream;
import util.IntPushOperator;

public class CSBTree {
    protected CSBTreeNode root = null;
    protected LeafGroup firstLeaf = null;
    protected int k;
    protected int k_star;
    private double leafUtilization;
    private int leafGroupCount;
    private int leafCount;
    private int elemCount;
    private boolean refreshNeeded = true;
    private int addCounter = 0;
    private int getCounter = 0;
    private int delCounter = 0;
    private int rangeQueryCounter = 0;

    public CSBTree(int k, int k_star) {
        this.k = k;
        this.k_star = k_star;
    }

    public void add(int key, int value, LeafCarrier leafCarrier) {
        if (this.root == null) {
            this.firstLeaf = new LeafGroup(this.k, this.k_star);
            this.root = this.firstLeaf;
        }
        SplitInfo splitInfo = this.root.add(0, key, value, false, Integer.MIN_VALUE, Integer.MAX_VALUE, leafCarrier);
        ++this.addCounter;
        if (splitInfo != null) {
            NodeGroup newRoot = new NodeGroup(splitInfo.leftNode, splitInfo.pivot, this.k);
            this.root = newRoot;
        }
        this.refreshNeeded = true;
    }

    public void add(int key, int value) {
        this.add(key, value, null);
    }

    public void get(int key, IntPushOperator results) {
        this.root.get(0, key, results);
        ++this.getCounter;
    }

    public void remove(int key) {
        this.root.remove(0, key, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MAX_VALUE);
        this.refreshNeeded = true;
        ++this.delCounter;
    }

    public void queryRange(int lowKey, int highKey, IntPushOperator results) {
        this.root.queryRange(0, lowKey, highKey, results);
        ++this.rangeQueryCounter;
    }

    public String toString() {
        return this.root.toString();
    }

    public void toDot(OutputStream dest) {
        try {
            dest.write("digraph g {\n".getBytes());
            dest.write("node [shape=record,height=.1];\n".getBytes());
            this.root.toDot(dest);
            LeafGroup currentLeaf = this.firstLeaf;
            while (currentLeaf != null) {
                currentLeaf.toDot(dest);
                currentLeaf = currentLeaf.nextLeafGroup;
            }
            dest.write("}\n".getBytes());
            dest.flush();
            dest.close();
        }
        catch (IOException e) {
            System.out.println("could not write dotty");
            e.printStackTrace();
        }
    }

    public void printStats() {
        this.calculateStats();
        System.out.print("leafUtilization:\t" + this.leafUtilization + "\tleafCount:\t" + this.leafCount + "\telementCount:\t" + this.elemCount + "\t");
    }

    public long size() {
        this.calculateStats();
        return this.elemCount;
    }

    private void calculateStats() {
        if (this.refreshNeeded) {
            LeafGroup currentLeaf = this.firstLeaf;
            this.elemCount = 0;
            this.leafCount = 0;
            this.leafGroupCount = 0;
            while (currentLeaf != null) {
                this.leafCount += currentLeaf.entries.leaves();
                this.elemCount += currentLeaf.entries.getKeyNumber();
                currentLeaf = currentLeaf.nextLeafGroup;
                ++this.leafGroupCount;
            }
            this.leafUtilization = (double)this.elemCount / (double)(this.leafCount * 2 * this.k_star);
            this.refreshNeeded = false;
        }
    }

    public double getLeafUtilization() {
        this.calculateStats();
        return this.leafUtilization;
    }

    public int getLeafCount() {
        this.calculateStats();
        return this.leafCount;
    }

    public int getElemCount() {
        this.calculateStats();
        return this.elemCount;
    }
}

