/*
 * Decompiled with CFR 0.152.
 */
package core.btree;

import core.btree.LeafArrayMap;
import java.util.Random;
import junit.framework.Assert;
import junit.framework.TestCase;
import util.IntPushOperator;

public class LeafArrayMapTest
extends TestCase {
    public void testLeafArrayMap() {
        int value;
        int key;
        int i;
        int no = 10;
        LeafArrayMap am = new LeafArrayMap(10);
        Random rand = new Random(33333L);
        for (i = 0; i < 10; ++i) {
            key = rand.nextInt(42);
            value = 100 + key;
            System.out.println(key + " " + value);
            am.tryAdd(key, value);
            System.out.println("POST INSERT:\n" + am);
            System.out.println("--------------------------");
            am.get(key, new CheckIntPushOperator(key, -1));
        }
        rand = new Random(33333L);
        for (i = 0; i < 10; ++i) {
            key = rand.nextInt(42);
            value = 100 + key;
            System.out.println(key + " " + value);
            am.remove(key, value);
            System.out.println("POST DELETE:\n" + am);
            System.out.println("--------------------------");
            am.get(key, new CheckIntPushOperator(key, 0));
        }
    }

    public static class CheckIntPushOperator
    implements IntPushOperator {
        private int key;
        private int assertCount;
        private int count;

        public void pass(int[] element) {
        }

        public CheckIntPushOperator(int key, int assertCount) {
            this.key = key;
            this.assertCount = assertCount;
            this.count = 0;
        }

        public void pass(int element) {
            if (element - 100 != this.key) {
                Assert.fail((String)("could not find correct mappings for key " + this.key));
            }
            ++this.count;
        }

        public void thatsallfolks() {
            if (this.assertCount > 0 && this.count != this.assertCount) {
                Assert.fail((String)("number of expected values " + this.assertCount + " did not match actual " + this.count));
            }
        }
    }
}

