/*
 * Decompiled with CFR 0.152.
 */
package core.btree;

import util.IntPushOperator;

public class LeafArrayMap {
    protected int[] keys;
    protected int[] values;
    protected int currentSize = 0;
    protected static final int STOP = 0;
    protected static final int CONTINUE_WITH_BINSEARCH = 1;
    protected static final int CONTINUE_WITH_SCAN = 2;

    public static int binarySearch(int[] a, int key, int from, int to) {
        int low = from;
        int high = to;
        while (low <= high) {
            int pos;
            int mid = low + high >> 1;
            long midVal = a[mid];
            if (midVal < (long)key) {
                low = mid + 1;
                continue;
            }
            if (midVal > (long)key) {
                high = mid - 1;
                continue;
            }
            for (pos = mid - 1; pos >= from && a[pos] == key; --pos) {
            }
            return pos + 1;
        }
        return -(low + 1);
    }

    public LeafArrayMap(int n) {
        this.keys = new int[n];
        this.values = new int[n];
    }

    public int getMidKey() {
        return this.keys[this.currentSize / 2];
    }

    public LeafArrayMap split() {
        LeafArrayMap newMap = new LeafArrayMap(this.keys.length);
        int mid = this.currentSize / 2;
        int count = 0;
        for (int i = mid; i < this.currentSize; ++i) {
            newMap.keys[count] = this.keys[i];
            newMap.values[count] = this.values[i];
            ++count;
        }
        newMap.currentSize = this.currentSize - mid;
        this.currentSize = mid;
        return newMap;
    }

    public boolean tryAdd(int key, int value) {
        if (this.currentSize == 0) {
            this.keys[0] = key;
            this.values[0] = value;
            ++this.currentSize;
            return false;
        }
        int pos = LeafArrayMap.binarySearch(this.keys, key, 0, this.currentSize - 1);
        if (pos < 0) {
            pos = -(pos + 1);
        }
        while (pos < this.currentSize && this.keys[pos] <= key) {
            ++pos;
        }
        if (pos == this.currentSize) {
            return true;
        }
        this.addAtPos(key, value, pos);
        return false;
    }

    public void addAtPos(int key, int value, int pos) {
        if (pos < this.currentSize) {
            System.arraycopy(this.keys, pos, this.keys, pos + 1, this.currentSize - pos);
            System.arraycopy(this.values, pos, this.values, pos + 1, this.currentSize - pos);
            ++this.currentSize;
            this.keys[pos] = key;
            this.values[pos] = value;
        } else {
            this.keys[this.currentSize] = key;
            this.values[this.currentSize] = value;
            ++this.currentSize;
        }
    }

    public int get(int key, IntPushOperator results) {
        if (this.currentSize == 0) {
            return 1;
        }
        int pos = LeafArrayMap.binarySearch(this.keys, key, 0, this.currentSize - 1);
        if (pos < 0) {
            return (pos = -(pos + 1)) == this.currentSize ? 1 : 0;
        }
        return this.continueGet(pos, key, results);
    }

    public int continueGet(int pos, int key, IntPushOperator results) {
        while (pos < this.currentSize && this.keys[pos] == key) {
            results.pass(this.values[pos]);
            ++pos;
        }
        return pos == this.currentSize ? 2 : 0;
    }

    public boolean remove(int key, int value) {
        boolean continueSearch;
        if (this.currentSize == 0) {
            return true;
        }
        int pos = LeafArrayMap.binarySearch(this.keys, key, 0, this.currentSize - 1);
        if (pos < 0) {
            return (pos = -(pos + 1)) == this.currentSize;
        }
        int firstOccurrence = -1;
        while (pos < this.currentSize && this.keys[pos] == key) {
            if (value == Integer.MIN_VALUE) {
                if (firstOccurrence == -1) {
                    firstOccurrence = pos;
                }
            } else if (this.values[pos] == value) {
                firstOccurrence = pos;
                break;
            }
            ++pos;
        }
        int lastOccurrence = value == Integer.MIN_VALUE ? pos - 1 : firstOccurrence;
        boolean bl = value == Integer.MIN_VALUE || firstOccurrence == -1 ? pos == this.currentSize : (continueSearch = false);
        if (firstOccurrence != -1) {
            System.arraycopy(this.keys, lastOccurrence + 1, this.keys, firstOccurrence, this.currentSize - (lastOccurrence + 1));
            System.arraycopy(this.values, lastOccurrence + 1, this.values, firstOccurrence, this.currentSize - (lastOccurrence + 1));
            this.currentSize -= lastOccurrence - firstOccurrence + 1;
        }
        return continueSearch;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < this.currentSize; ++i) {
            sb.append(this.keys[i] + "=");
            sb.append(this.values[i]);
            if (i + 1 >= this.currentSize) continue;
            sb.append(", ");
        }
        return sb.toString();
    }

    public int size() {
        return this.currentSize;
    }

    public int queryRange(int lowKey, int highKey, IntPushOperator results) {
        if (this.currentSize == 0) {
            return 1;
        }
        int pos = LeafArrayMap.binarySearch(this.keys, lowKey, 0, this.currentSize - 1);
        if (pos < 0) {
            pos = -(pos + 1);
        }
        return this.continueScan(pos, highKey, results);
    }

    public int continueScan(int pos, int highKey, IntPushOperator results) {
        boolean returnedSomething = false;
        while (pos < this.currentSize && this.keys[pos] <= highKey) {
            results.pass(this.values[pos]);
            ++pos;
            returnedSomething = true;
        }
        return pos == this.currentSize ? (returnedSomething ? 2 : 1) : 0;
    }

    public void deleteAtPos(int i) {
        System.arraycopy(this.keys, i + 1, this.keys, i, this.currentSize - (i + 1));
        System.arraycopy(this.values, i + 1, this.values, i, this.currentSize - (i + 1));
        --this.currentSize;
    }
}

