/*
 * Decompiled with CFR 0.152.
 */
package core.btree;

import core.btree.BTreeNode;
import core.btree.LeafArrayMap;
import core.btree.LeafCarrier;
import core.btree.SplitInfo;
import java.io.IOException;
import java.io.OutputStream;
import util.IntPushOperator;

public class Leaf
implements BTreeNode {
    protected LeafArrayMap entries;
    protected int k_star;
    protected Leaf nextLeaf;

    public Leaf(int k_star, LeafArrayMap entries) {
        this.k_star = k_star;
        this.entries = entries;
        this.nextLeaf = null;
    }

    public Leaf(int k_star) {
        this(k_star, new LeafArrayMap(2 * k_star));
    }

    public SplitInfo add(int key, int value, int lowKey, int highKey, LeafCarrier leafCarrier) {
        boolean continueSearch = this.entries.tryAdd(key, value);
        Leaf currentLeaf = this;
        while (continueSearch && currentLeaf.nextLeaf != null && currentLeaf.nextLeaf.entries.keys[0] < highKey) {
            continueSearch = currentLeaf.nextLeaf.entries.tryAdd(key, value);
            currentLeaf = currentLeaf.nextLeaf;
        }
        if (continueSearch) {
            currentLeaf.entries.addAtPos(key, value, currentLeaf.entries.size());
        }
        if (leafCarrier != null) {
            leafCarrier.carriedLeaf = currentLeaf;
        }
        if (currentLeaf.entries.size() >= 2 * this.k_star) {
            return currentLeaf.split();
        }
        return null;
    }

    private SplitInfo split() {
        Leaf newLeaf = new Leaf(this.k_star, this.entries.split());
        newLeaf.nextLeaf = this.nextLeaf;
        this.nextLeaf = newLeaf;
        if (newLeaf.entries.keys[0] == this.entries.keys[this.entries.size() - 1]) {
            return null;
        }
        return new SplitInfo(this, newLeaf.entries.keys[0], newLeaf);
    }

    public void remove(int key, int value, int lowKey, int highKey) {
        boolean continueSearch = this.entries.remove(key, value);
        Leaf currentLeaf = this;
        while (continueSearch && currentLeaf.nextLeaf != null && currentLeaf.nextLeaf.entries.keys[0] < highKey) {
            continueSearch = currentLeaf.nextLeaf.entries.remove(key, value);
            if (currentLeaf.nextLeaf.entries.size() == 0) {
                currentLeaf.nextLeaf = currentLeaf.nextLeaf.nextLeaf;
                continue;
            }
            currentLeaf = currentLeaf.nextLeaf;
        }
    }

    public String toString() {
        return "[" + this.entries.toString() + "]";
    }

    public void get(int key, IntPushOperator results) {
        int continueSearch = this.entries.get(key, results);
        Leaf currentLeaf = this.nextLeaf;
        while (continueSearch != 0 && currentLeaf != null) {
            continueSearch = continueSearch == 1 ? currentLeaf.entries.get(key, results) : currentLeaf.entries.continueGet(0, key, results);
            currentLeaf = currentLeaf.nextLeaf;
        }
        results.thatsallfolks();
    }

    public void toDot(OutputStream dest) {
        StringBuffer sb = new StringBuffer();
        sb.append("nodeX" + this.hashCode() + " [shape=record,label=\"{{");
        for (int i = 0; i < this.entries.size(); ++i) {
            sb.append("{" + this.entries.keys[i] + " |");
            sb.append(this.entries.values[i] + "}");
            if (i == this.entries.size() - 1) continue;
            sb.append("|");
        }
        sb.append("}}\"];\n");
        try {
            dest.write(sb.toString().getBytes());
            if (this.nextLeaf != null) {
                dest.write(("\"nodeX" + this.hashCode() + "\":" + this.entries.size() + " -> \"" + "nodeX" + this.nextLeaf.hashCode() + "\":0;\n").getBytes());
            }
        }
        catch (IOException e) {
            System.out.println("could not write dotty");
            e.printStackTrace();
        }
    }

    public void queryRange(int lowKey, int highKey, IntPushOperator results) {
        int continueSearch = this.entries.queryRange(lowKey, highKey, results);
        Leaf currentLeaf = this.nextLeaf;
        while (continueSearch != 0 && currentLeaf != null) {
            continueSearch = continueSearch == 2 ? currentLeaf.entries.continueScan(0, highKey, results) : currentLeaf.entries.queryRange(lowKey, highKey, results);
            currentLeaf = currentLeaf.nextLeaf;
        }
        results.thatsallfolks();
    }

    public boolean isLeaf() {
        return true;
    }

    public boolean isEmpty() {
        return this.entries.size() == 0;
    }

    public void removeValue(int value) {
        boolean foundValue = false;
        Leaf currentLeaf = this;
        while (!foundValue && currentLeaf != null) {
            for (int i = 0; i < currentLeaf.entries.size(); ++i) {
                if (currentLeaf.entries.values[i] != value) continue;
                currentLeaf.entries.deleteAtPos(i);
                foundValue = true;
            }
            currentLeaf = currentLeaf.nextLeaf;
        }
    }
}

