/*
 * Decompiled with CFR 0.152.
 */
package core.btree;

import core.btree.BTreeNode;
import core.btree.InternalNode;

public class InternalNodeArrayMap {
    protected int[] keys;
    protected BTreeNode[] nodes;
    protected int currentSize = 0;

    public static int binarySearch(int[] a, int key, int from, int to) {
        int low = from;
        int high = to;
        while (low <= high) {
            int mid = low + high >> 1;
            long midVal = a[mid];
            if (midVal < (long)key) {
                low = mid + 1;
                continue;
            }
            if (midVal > (long)key) {
                high = mid - 1;
                continue;
            }
            return mid;
        }
        return -(low + 1);
    }

    public InternalNodeArrayMap(int n) {
        this.keys = new int[n];
        this.nodes = new BTreeNode[n + 1];
        this.nodes[0] = InternalNode.NULL;
    }

    public int getMidKey() {
        return this.keys[this.currentSize / 2];
    }

    public InternalNodeArrayMap split() {
        int i;
        InternalNodeArrayMap newMap = new InternalNodeArrayMap(this.keys.length);
        int mid = this.currentSize / 2;
        int count = 0;
        newMap.nodes[0] = this.nodes[mid + 1];
        for (i = mid + 1; i < this.currentSize; ++i) {
            newMap.keys[count] = this.keys[i];
            newMap.nodes[++count] = this.nodes[i + 1];
        }
        for (i = mid; i < this.currentSize; ++i) {
            this.nodes[i + 1] = null;
        }
        newMap.currentSize = this.currentSize - mid - 1;
        this.currentSize = mid;
        return newMap;
    }

    public void put(int key, BTreeNode rightNode) {
        if (this.currentSize == 0) {
            this.keys[0] = key;
            this.nodes[1] = rightNode;
            ++this.currentSize;
            return;
        }
        int pos = InternalNodeArrayMap.binarySearch(this.keys, key, 0, this.currentSize - 1);
        if (pos >= 0) {
            this.keys[pos] = key;
            this.nodes[pos + 1] = rightNode;
        } else if ((pos = -(pos + 1)) < this.currentSize) {
            System.arraycopy(this.keys, pos, this.keys, pos + 1, this.currentSize - pos);
            System.arraycopy(this.nodes, pos + 1, this.nodes, pos + 2, this.currentSize - pos);
            this.keys[pos] = key;
            this.nodes[pos + 1] = rightNode;
            ++this.currentSize;
        } else {
            this.keys[this.currentSize] = key;
            this.nodes[this.currentSize + 1] = rightNode;
            ++this.currentSize;
        }
    }

    public BTreeNode get(int key) {
        int pos = this.getIntervalPosition(key);
        if (pos == -1) {
            return null;
        }
        return this.nodes[pos];
    }

    public int getIntervalPosition(int key) {
        if (this.currentSize == 0) {
            return -1;
        }
        int pos = InternalNodeArrayMap.binarySearch(this.keys, key, 0, this.currentSize - 1);
        pos = pos < 0 ? -(pos + 1) : ++pos;
        return pos;
    }

    public boolean delete(int key) {
        if (this.currentSize == 0) {
            return false;
        }
        int pos = InternalNodeArrayMap.binarySearch(this.keys, key, 0, this.currentSize - 1);
        if (pos >= 0) {
            this.deleteAtPos(pos);
            return true;
        }
        return false;
    }

    public void deleteAtPos(int pos) {
        System.arraycopy(this.keys, pos + 1, this.keys, pos, this.currentSize - pos);
        System.arraycopy(this.nodes, pos + 2, this.nodes, pos + 1, this.currentSize - pos);
        this.nodes[this.currentSize] = null;
        --this.currentSize;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        if (this.nodes[0] == InternalNode.NULL) {
            sb.append("NULL | ");
        } else {
            String nodeValue = this.nodes[0] == null ? null : Integer.toString(this.nodes[0].hashCode());
            sb.append(nodeValue + " | ");
        }
        for (int i = 0; i < this.currentSize; ++i) {
            sb.append(this.keys[i] + " | ");
            String nodeValue = this.nodes[i + 1] == null ? null : Integer.toString(this.nodes[i + 1].hashCode());
            sb.append(nodeValue);
            if (i + 1 >= this.currentSize) continue;
            sb.append(" | ");
        }
        return sb.toString();
    }

    public int size() {
        return this.currentSize;
    }
}

