/*
 * Decompiled with CFR 0.152.
 */
package core.btree;

import core.btree.BTreeNode;
import core.btree.InternalNodeArrayMap;
import core.btree.LeafCarrier;
import core.btree.SplitInfo;
import java.io.IOException;
import java.io.OutputStream;
import util.IntPushOperator;

public class InternalNode
implements BTreeNode {
    protected static final InternalNode NULL = new InternalNode(0, null);
    protected InternalNodeArrayMap entries;
    protected int k;

    public InternalNode(int k, InternalNodeArrayMap entries) {
        this.k = k;
        this.entries = entries;
    }

    public InternalNode(BTreeNode leftChild, int pivot, BTreeNode rightChild, int k) {
        this.k = k;
        this.entries = new InternalNodeArrayMap(2 * k);
        this.entries.nodes[0] = leftChild;
        this.entries.put(pivot, rightChild);
    }

    public SplitInfo add(int key, int value, int lowKey, int highKey, LeafCarrier leafCarrier) {
        int newHighKey;
        int newLowKey;
        int pos = this.entries.getIntervalPosition(key);
        BTreeNode next = this.entries.nodes[pos];
        SplitInfo splitInfo = next.add(key, value, newLowKey = pos == 0 ? lowKey : this.entries.keys[pos - 1], newHighKey = pos == this.entries.size() ? highKey : this.entries.keys[pos], leafCarrier);
        if (splitInfo != null) {
            this.entries.put(splitInfo.pivot, splitInfo.rightNode);
            if (this.entries.size() >= 2 * this.k) {
                return this.split();
            }
        }
        return null;
    }

    private SplitInfo split() {
        int midKey = this.entries.getMidKey();
        InternalNode newNode = new InternalNode(this.k, this.entries.split());
        return new SplitInfo(this, midKey, newNode);
    }

    public void remove(int key, int value, int lowKey, int highKey) {
        int pos = this.entries.getIntervalPosition(key);
        BTreeNode next = this.entries.nodes[pos];
        if (next != null) {
            int newLowKey = pos == 0 ? lowKey : this.entries.keys[pos - 1];
            int newHighKey = pos == this.entries.size() ? highKey : this.entries.keys[pos];
            next.remove(key, value, newLowKey, newHighKey);
        }
    }

    private void removeChildAtPos(int pos) {
        if (pos == 0) {
            this.entries.nodes[pos] = null;
        } else {
            this.entries.deleteAtPos(pos);
        }
    }

    public String toString() {
        return "[" + this.entries.toString() + "]";
    }

    public void get(int key, IntPushOperator results) {
        BTreeNode next = this.entries.get(key);
        next.get(key, results);
    }

    public void toDot(OutputStream dest) {
        int i;
        StringBuffer sb = new StringBuffer();
        sb.append("nodeX" + this.hashCode() + " [shape=record,label=\"{");
        sb.append("{");
        for (i = 0; i < this.entries.size(); ++i) {
            sb.append("<" + i + "> |");
            sb.append("<key" + i + ">" + this.entries.keys[i] + "|");
        }
        sb.append("<" + this.entries.size() + ">}}\"];\n");
        try {
            dest.write(sb.toString().getBytes());
            for (i = 0; i < this.entries.size() + 1; ++i) {
                dest.write(("\"nodeX" + this.hashCode() + "\":" + i + " -> \"" + "nodeX" + this.entries.nodes[i].hashCode() + "\";\n").getBytes());
                if (!(this.entries.nodes[i] instanceof InternalNode)) continue;
                this.entries.nodes[i].toDot(dest);
            }
        }
        catch (IOException e) {
            System.out.println("could not write dotty");
            e.printStackTrace();
        }
    }

    public void queryRange(int lowKey, int highKey, IntPushOperator results) {
        BTreeNode next = this.entries.get(lowKey);
        next.queryRange(lowKey, highKey, results);
    }

    public boolean isLeaf() {
        return false;
    }

    public boolean isEmpty() {
        return this.entries.size() == 0 && this.entries.nodes[0] == null;
    }
}

