/*
 * Decompiled with CFR 0.152.
 */
package core.btree;

import core.btree.BTree;
import core.btree.InternalNode;
import core.btree.Leaf;
import java.io.BufferedOutputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import junit.framework.Assert;
import junit.framework.TestCase;
import util.IntPushOperator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BTreeTest
extends TestCase {
    public void testBTreeSingleThread() {
        int k = 5;
        int k_star = 50;
        int no = 200000;
        boolean validateIntermediaryStates = false;
        BTree btree = new BTree(5, 50);
        for (int j = 0; j < 2; ++j) {
            int i;
            int key;
            TreeMap<Integer, List<Integer>> keySpace = new TreeMap<Integer, List<Integer>>();
            Random rand = new Random(33333L);
            for (int i2 = 0; i2 < 200000; ++i2) {
                key = rand.nextInt(200000);
                int value = 200000 + key;
                btree.add(key, value, null);
                ArrayList<Integer> values = (ArrayList<Integer>)keySpace.get(key);
                if (values == null) {
                    values = new ArrayList<Integer>();
                    keySpace.put(key, values);
                }
                values.add(value);
                btree.get(key, new CheckValuesOperator(values, false));
            }
            System.out.println("========================================");
            System.out.println("=  Generating dotty in /tmp/btree" + (j + 1) + ".1.dot  =");
            try {
                btree.toDot(new BufferedOutputStream(new FileOutputStream("/tmp/btree" + (j + 1) + ".1.dot")));
            }
            catch (FileNotFoundException e) {
                BTreeTest.fail((String)"could not write dotty");
            }
            try {
                this.validateTree(btree);
            }
            catch (Exception e) {
                e.printStackTrace();
                BTreeTest.fail((String)"btree structure violated after insertion of keys");
            }
            System.out.println("========================================");
            btree.printStats();
            System.out.println();
            rand = new Random(33333L);
            for (i = 0; i < 200000; ++i) {
                key = rand.nextInt(200000);
                List values = (List)keySpace.get(key);
                btree.get(key, new CheckValuesOperator(values, false));
            }
            this.checkRange(btree, keySpace, 16, 21);
            this.checkRange(btree, keySpace, 16, 42);
            for (i = 0; i < 100; ++i) {
                int lowKeyInRange = rand.nextInt(200000);
                int highKeyInRange = rand.nextInt(200000);
                if (highKeyInRange < lowKeyInRange) {
                    int tmp = highKeyInRange;
                    highKeyInRange = lowKeyInRange;
                    lowKeyInRange = tmp;
                }
                this.checkRange(btree, keySpace, lowKeyInRange, highKeyInRange);
            }
            rand = new Random(33333L);
            for (i = 0; i < 200000; ++i) {
                key = rand.nextInt(200000);
                Collection<Integer> mappingsToKey = Collections.emptySet();
                if (keySpace.containsKey(key)) {
                    if (j == 0) {
                        List values = (List)keySpace.get(key);
                        btree.get(key, new CheckValuesOperator(values, false));
                        keySpace.remove(key);
                        btree.remove(key);
                    } else {
                        int value = 200000 + key;
                        List values = (List)keySpace.get(key);
                        btree.get(key, new CheckValuesOperator(values, false));
                        values.remove(values.size() - 1);
                        if (values.isEmpty()) {
                            keySpace.remove(key);
                        } else {
                            mappingsToKey = values;
                        }
                        btree.remove(key, value);
                    }
                }
                btree.get(key, new CheckValuesOperator(mappingsToKey, false));
            }
            System.out.println("========================================");
            System.out.println("=  Generating dotty in /tmp/btree" + (j + 1) + ".2.dot  =");
            try {
                btree.toDot(new BufferedOutputStream(new FileOutputStream("/tmp/btree" + (j + 1) + ".2.dot")));
            }
            catch (FileNotFoundException e) {
                BTreeTest.fail((String)"could not write dotty");
            }
            try {
                this.validateTree(btree);
            }
            catch (Exception e) {
                e.printStackTrace();
                BTreeTest.fail((String)"btree structure violated after deletion of keys");
            }
            System.out.println("========================================");
            btree.printStats();
            System.out.println();
        }
    }

    private void checkRange(BTree btree, SortedMap<Integer, List<Integer>> keySpace, int lowKey, int highKey) {
        System.out.print("Values between " + lowKey + " and " + highKey + "--> ");
        HashSet<Integer> expectedValues = new HashSet<Integer>();
        SortedMap<Integer, List<Integer>> expectedMappings = keySpace.subMap(lowKey, highKey + 1);
        for (List values : expectedMappings.values()) {
            expectedValues.addAll(values);
        }
        btree.queryRange(lowKey, highKey, new CheckValuesOperator(expectedValues, false));
        System.out.println();
    }

    private void validateTree(BTree btree) throws Exception {
        Leaf currentLeaf;
        int leafCount;
        if (btree.root instanceof InternalNode) {
            InternalNode root = (InternalNode)btree.root;
            leafCount = this.checkSubTreeBetween(root, Integer.MIN_VALUE, Integer.MAX_VALUE, btree.k);
        } else {
            currentLeaf = (Leaf)btree.root;
            leafCount = 0;
            while (currentLeaf != null) {
                currentLeaf = currentLeaf.nextLeaf;
                ++leafCount;
            }
        }
        currentLeaf = btree.firstLeaf;
        int lastKey = Integer.MIN_VALUE;
        int count = 0;
        while (currentLeaf != null) {
            for (int i = 0; i < currentLeaf.entries.size(); ++i) {
                if (currentLeaf.entries.keys[i] < lastKey) {
                    throw new Exception("leaf level is not sorted: " + lastKey);
                }
                lastKey = currentLeaf.entries.keys[i];
            }
            currentLeaf = currentLeaf.nextLeaf;
            ++count;
        }
        if (count < leafCount) {
            throw new Exception("not as many leaves (" + count + ") can be found on the leaf level as expected (" + leafCount + ")");
        }
    }

    private int checkSubTreeBetween(InternalNode node, int minValue, int maxValue, int k) throws Exception {
        int leafCount = 0;
        int lowKey = minValue;
        for (int i = 0; i < node.entries.size(); ++i) {
            if (node.entries.keys[i] < minValue || node.entries.keys[i] >= maxValue) {
                throw new Exception("key range not valid for node between " + node.entries.keys[0] + " and " + node.entries.keys[node.entries.size() - 1] + " - key: " + node.entries.keys[i]);
            }
            if (node.entries.nodes[i] instanceof InternalNode) {
                InternalNode next = (InternalNode)node.entries.nodes[i];
                leafCount += this.checkSubTreeBetween(next, lowKey, node.entries.keys[i], k);
            } else {
                ++leafCount;
                Leaf leaf = (Leaf)node.entries.nodes[i];
                this.checkLeafBetween(leaf, lowKey, node.entries.keys[i]);
            }
            lowKey = node.entries.keys[i];
        }
        if (node.entries.nodes[node.entries.size()] instanceof InternalNode) {
            InternalNode last = (InternalNode)node.entries.nodes[node.entries.size()];
            leafCount += this.checkSubTreeBetween(last, lowKey, maxValue, k);
        } else {
            ++leafCount;
            Leaf leaf = (Leaf)node.entries.nodes[node.entries.size()];
            this.checkLeafBetween(leaf, lowKey, maxValue);
        }
        return leafCount;
    }

    private void checkLeafBetween(Leaf leaf, int lowKey, int highKey) throws Exception {
        Leaf current = leaf;
        while (current != null) {
            for (int i = 0; i < current.entries.size(); ++i) {
                if (current.entries.keys[i] >= lowKey && current.entries.keys[i] < highKey) continue;
                throw new Exception("key range not valid for leaf [" + current.entries.keys[0] + ", " + current.entries.keys[current.entries.size() - 1] + "] - violating key: " + current.entries.keys[i]);
            }
            if (current.nextLeaf != null && current.nextLeaf.entries.keys[0] < highKey) {
                current = current.nextLeaf;
                continue;
            }
            current = null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class CheckValuesOperator
    implements IntPushOperator {
        private Collection<Integer> expectedValues;
        private Set<Integer> obtainedValues;
        private boolean print;

        @Override
        public void pass(int[] element) {
        }

        public CheckValuesOperator(Collection<Integer> expectedValues, boolean print) {
            this.expectedValues = expectedValues;
            this.obtainedValues = new HashSet<Integer>();
            this.print = print;
        }

        @Override
        public void pass(int element) {
            this.obtainedValues.add(element);
            if (this.print) {
                System.out.print(element + " ");
            }
        }

        @Override
        public void thatsallfolks() {
            if (!this.obtainedValues.containsAll(this.expectedValues)) {
                Assert.fail((String)"some values were expected but not received by the push operator");
            }
            if (!this.expectedValues.containsAll(this.obtainedValues)) {
                this.obtainedValues.removeAll(this.expectedValues);
                System.out.println("got the following unexpected values: " + this.obtainedValues);
                Assert.fail((String)"some values were obtained by the push operator but not expected");
            }
            if (this.print) {
                System.out.println();
                System.out.println("iteration finished");
            }
        }
    }
}

