/*
 * Decompiled with CFR 0.152.
 */
package core.btree;

import core.btree.BTreeNode;
import core.btree.InternalNode;
import core.btree.Leaf;
import core.btree.LeafCarrier;
import core.btree.SplitInfo;
import java.io.IOException;
import java.io.OutputStream;
import util.IntPushOperator;

public class BTree {
    protected BTreeNode root = null;
    protected Leaf firstLeaf = null;
    protected int k;
    protected int k_star;
    private double leafUtilization;
    private int leafCount;
    private int elemCount;
    private boolean refreshNeeded = true;

    public BTree(int k, int k_star) {
        this.k = k;
        this.k_star = k_star;
    }

    public void add(int key, int value, LeafCarrier leafCarrier) {
        SplitInfo splitInfo;
        if (this.root == null) {
            this.firstLeaf = new Leaf(this.k_star);
            this.root = this.firstLeaf;
        }
        if ((splitInfo = this.root.add(key, value, Integer.MIN_VALUE, Integer.MAX_VALUE, leafCarrier)) != null) {
            InternalNode newRoot = new InternalNode(splitInfo.leftNode, splitInfo.pivot, splitInfo.rightNode, this.k);
            this.root = newRoot;
        }
        this.refreshNeeded = true;
    }

    public void add(int key, int value) {
        this.add(key, value, null);
    }

    public void get(int key, IntPushOperator results) {
        this.root.get(key, results);
    }

    public void remove(int key) {
        this.root.remove(key, Integer.MIN_VALUE, Integer.MIN_VALUE, Integer.MAX_VALUE);
        this.refreshNeeded = true;
    }

    public void remove(int key, int value) {
        this.root.remove(key, value, Integer.MIN_VALUE, Integer.MAX_VALUE);
        this.refreshNeeded = true;
    }

    public void queryRange(int lowKey, int highKey, IntPushOperator results) {
        this.root.queryRange(lowKey, highKey, results);
    }

    public String toString() {
        return this.root.toString();
    }

    public void toDot(OutputStream dest) {
        try {
            dest.write("digraph g {\n".getBytes());
            dest.write("node [shape=record,height=.1];\n".getBytes());
            this.root.toDot(dest);
            Leaf currentLeaf = this.firstLeaf;
            while (currentLeaf != null) {
                currentLeaf.toDot(dest);
                currentLeaf = currentLeaf.nextLeaf;
            }
            dest.write("}\n".getBytes());
            dest.flush();
            dest.close();
        }
        catch (IOException e) {
            System.out.println("could not write dotty");
            e.printStackTrace();
        }
    }

    public void printStats() {
        this.calculateStats();
        System.out.print("leafUtilization:\t" + this.leafUtilization + "\tleafCount:\t" + this.leafCount + "\telementCount:\t" + this.elemCount + "\t");
    }

    public long size() {
        this.calculateStats();
        return this.elemCount;
    }

    private void calculateStats() {
        if (this.refreshNeeded) {
            Leaf currentLeaf = this.firstLeaf;
            this.elemCount = 0;
            this.leafCount = 0;
            while (currentLeaf != null) {
                ++this.leafCount;
                this.elemCount += currentLeaf.entries.size();
                currentLeaf = currentLeaf.nextLeaf;
            }
            this.leafUtilization = (double)this.elemCount / (double)(this.leafCount * 2 * this.k_star);
            this.refreshNeeded = false;
        }
    }

    public double getLeafUtilization() {
        this.calculateStats();
        return this.leafUtilization;
    }

    public int getLeafCount() {
        this.calculateStats();
        return this.leafCount;
    }

    public int getElemCount() {
        this.calculateStats();
        return this.elemCount;
    }
}

